/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.queue.discovery;

import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationListener;
import org.thingsboard.server.queue.discovery.event.TbApplicationEvent;

public abstract class TbApplicationEventListener<T extends TbApplicationEvent>
implements ApplicationListener<T> {
    private static final Logger log = LoggerFactory.getLogger(TbApplicationEventListener.class);
    private int lastProcessedSequenceNumber = Integer.MIN_VALUE;
    private final Lock seqNumberLock = new ReentrantLock();

    public void onApplicationEvent(T event) {
        boolean validUpdate = false;
        this.seqNumberLock.lock();
        try {
            if (((TbApplicationEvent)((Object)event)).getSequenceNumber() > this.lastProcessedSequenceNumber) {
                validUpdate = true;
                this.lastProcessedSequenceNumber = ((TbApplicationEvent)((Object)event)).getSequenceNumber();
            }
        }
        finally {
            this.seqNumberLock.unlock();
        }
        if (validUpdate && this.filterTbApplicationEvent(event)) {
            this.onTbApplicationEvent(event);
        } else {
            log.info("Application event ignored due to invalid sequence number ({} > {}). Event: {}", new Object[]{this.lastProcessedSequenceNumber, ((TbApplicationEvent)((Object)event)).getSequenceNumber(), event});
        }
    }

    protected abstract void onTbApplicationEvent(T var1);

    protected boolean filterTbApplicationEvent(T event) {
        return true;
    }
}

