/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.queue.discovery;

import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Service;
import org.thingsboard.server.common.msg.queue.ServiceType;
import org.thingsboard.server.common.msg.queue.TopicPartitionInfo;

@Service
public class NotificationsTopicService {
    private Map<String, TopicPartitionInfo> tbCoreNotificationTopics = new HashMap<String, TopicPartitionInfo>();
    private Map<String, TopicPartitionInfo> tbRuleEngineNotificationTopics = new HashMap<String, TopicPartitionInfo>();

    public TopicPartitionInfo getNotificationsTopic(ServiceType serviceType, String serviceId) {
        switch (serviceType) {
            case TB_CORE: {
                return this.tbCoreNotificationTopics.computeIfAbsent(serviceId, id -> this.buildNotificationsTopicPartitionInfo(serviceType, serviceId));
            }
            case TB_RULE_ENGINE: {
                return this.tbRuleEngineNotificationTopics.computeIfAbsent(serviceId, id -> this.buildNotificationsTopicPartitionInfo(serviceType, serviceId));
            }
        }
        return this.buildNotificationsTopicPartitionInfo(serviceType, serviceId);
    }

    private TopicPartitionInfo buildNotificationsTopicPartitionInfo(ServiceType serviceType, String serviceId) {
        return new TopicPartitionInfo(serviceType.name().toLowerCase() + ".notifications." + serviceId, null, null, false);
    }
}

