/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.queue.common;

import com.google.protobuf.GeneratedMessageV3;
import java.util.UUID;
import org.thingsboard.server.queue.TbQueueMsg;
import org.thingsboard.server.queue.TbQueueMsgHeaders;
import org.thingsboard.server.queue.common.DefaultTbQueueMsgHeaders;

public class TbProtoQueueMsg<T extends GeneratedMessageV3>
implements TbQueueMsg {
    private final UUID key;
    protected final T value;
    private final TbQueueMsgHeaders headers;

    public TbProtoQueueMsg(UUID key, T value) {
        this(key, value, new DefaultTbQueueMsgHeaders());
    }

    public TbProtoQueueMsg(UUID key, T value, TbQueueMsgHeaders headers) {
        this.key = key;
        this.value = value;
        this.headers = headers;
    }

    public UUID getKey() {
        return this.key;
    }

    public TbQueueMsgHeaders getHeaders() {
        return this.headers;
    }

    public byte[] getData() {
        return this.value.toByteArray();
    }

    public T getValue() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TbProtoQueueMsg)) {
            return false;
        }
        TbProtoQueueMsg other = (TbProtoQueueMsg)o;
        if (!other.canEqual(this)) {
            return false;
        }
        UUID this$key = this.getKey();
        UUID other$key = other.getKey();
        if (this$key == null ? other$key != null : !((Object)this$key).equals(other$key)) {
            return false;
        }
        T this$value = this.getValue();
        T other$value = other.getValue();
        if (this$value == null ? other$value != null : !this$value.equals(other$value)) {
            return false;
        }
        TbQueueMsgHeaders this$headers = this.getHeaders();
        TbQueueMsgHeaders other$headers = other.getHeaders();
        return !(this$headers == null ? other$headers != null : !this$headers.equals(other$headers));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TbProtoQueueMsg;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        UUID $key = this.getKey();
        result = result * 59 + ($key == null ? 43 : ((Object)$key).hashCode());
        T $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        TbQueueMsgHeaders $headers = this.getHeaders();
        result = result * 59 + ($headers == null ? 43 : $headers.hashCode());
        return result;
    }

    public String toString() {
        return "TbProtoQueueMsg(key=" + this.getKey() + ", value=" + this.getValue() + ", headers=" + this.getHeaders() + ")";
    }
}

