/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.queue.common;

import java.util.concurrent.atomic.AtomicInteger;
import org.thingsboard.server.common.msg.queue.RuleEngineException;
import org.thingsboard.server.queue.TbQueueCallback;
import org.thingsboard.server.queue.TbQueueMsgMetadata;

public class MultipleTbQueueCallbackWrapper
implements TbQueueCallback {
    private final AtomicInteger tbQueueCallbackCount;
    private final TbQueueCallback callback;

    public MultipleTbQueueCallbackWrapper(int tbQueueCallbackCount, TbQueueCallback callback) {
        this.tbQueueCallbackCount = new AtomicInteger(tbQueueCallbackCount);
        this.callback = callback;
    }

    public void onSuccess(TbQueueMsgMetadata metadata) {
        if (this.tbQueueCallbackCount.decrementAndGet() <= 0) {
            this.callback.onSuccess(metadata);
        }
    }

    public void onFailure(Throwable t) {
        this.callback.onFailure((Throwable)new RuleEngineException(t.getMessage(), t));
    }
}

