/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.queue.common;

import java.util.List;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.common.util.ThingsBoardThreadFactory;
import org.thingsboard.server.common.msg.queue.TopicPartitionInfo;
import org.thingsboard.server.common.stats.MessagesStats;
import org.thingsboard.server.queue.TbQueueConsumer;
import org.thingsboard.server.queue.TbQueueHandler;
import org.thingsboard.server.queue.TbQueueMsg;
import org.thingsboard.server.queue.TbQueueProducer;
import org.thingsboard.server.queue.TbQueueResponseTemplate;
import org.thingsboard.server.queue.common.AbstractTbQueueTemplate;
import org.thingsboard.server.queue.common.AsyncCallbackTemplate;

public class DefaultTbQueueResponseTemplate<Request extends TbQueueMsg, Response extends TbQueueMsg>
extends AbstractTbQueueTemplate
implements TbQueueResponseTemplate<Request, Response> {
    private static final Logger log = LoggerFactory.getLogger(DefaultTbQueueResponseTemplate.class);
    private final TbQueueConsumer<Request> requestTemplate;
    private final TbQueueProducer<Response> responseTemplate;
    private final ConcurrentMap<UUID, String> pendingRequests;
    private final ExecutorService loopExecutor;
    private final ScheduledExecutorService timeoutExecutor;
    private final ExecutorService callbackExecutor;
    private final MessagesStats stats;
    private final int maxPendingRequests;
    private final long requestTimeout;
    private final long pollInterval;
    private volatile boolean stopped = false;
    private final AtomicInteger pendingRequestCount = new AtomicInteger();

    public DefaultTbQueueResponseTemplate(TbQueueConsumer<Request> requestTemplate, TbQueueProducer<Response> responseTemplate, TbQueueHandler<Request, Response> handler, long pollInterval, long requestTimeout, int maxPendingRequests, ExecutorService executor, MessagesStats stats) {
        this.requestTemplate = requestTemplate;
        this.responseTemplate = responseTemplate;
        this.pendingRequests = new ConcurrentHashMap<UUID, String>();
        this.maxPendingRequests = maxPendingRequests;
        this.pollInterval = pollInterval;
        this.requestTimeout = requestTimeout;
        this.callbackExecutor = executor;
        this.stats = stats;
        this.timeoutExecutor = Executors.newSingleThreadScheduledExecutor((ThreadFactory)ThingsBoardThreadFactory.forName((String)("tb-queue-response-template-timeout-" + requestTemplate.getTopic())));
        this.loopExecutor = Executors.newSingleThreadExecutor((ThreadFactory)ThingsBoardThreadFactory.forName((String)("tb-queue-response-template-loop-" + requestTemplate.getTopic())));
    }

    public void init(TbQueueHandler<Request, Response> handler) {
        this.responseTemplate.init();
        this.requestTemplate.subscribe();
        this.loopExecutor.submit(() -> {
            while (!this.stopped) {
                try {
                    while (this.pendingRequestCount.get() >= this.maxPendingRequests) {
                        try {
                            Thread.sleep(this.pollInterval);
                        }
                        catch (InterruptedException e) {
                            log.trace("Failed to wait until the server has capacity to handle new requests", (Throwable)e);
                        }
                    }
                    List requests = this.requestTemplate.poll(this.pollInterval);
                    if (requests.isEmpty()) continue;
                    requests.forEach(request -> {
                        long currentTime = System.currentTimeMillis();
                        long expireTs = DefaultTbQueueResponseTemplate.bytesToLong(request.getHeaders().get("expireTs"));
                        if (expireTs >= currentTime) {
                            byte[] requestIdHeader = request.getHeaders().get("requestId");
                            if (requestIdHeader == null) {
                                log.error("[{}] Missing requestId in header", request);
                                return;
                            }
                            byte[] responseTopicHeader = request.getHeaders().get("responseTopic");
                            if (responseTopicHeader == null) {
                                log.error("[{}] Missing response topic in header", request);
                                return;
                            }
                            UUID requestId = DefaultTbQueueResponseTemplate.bytesToUuid(requestIdHeader);
                            String responseTopic = this.bytesToString(responseTopicHeader);
                            try {
                                this.pendingRequestCount.getAndIncrement();
                                this.stats.incrementTotal();
                                AsyncCallbackTemplate.withCallbackAndTimeout(handler.handle(request), response -> {
                                    this.pendingRequestCount.decrementAndGet();
                                    response.getHeaders().put("requestId", this.uuidToBytes(requestId));
                                    this.responseTemplate.send(TopicPartitionInfo.builder().topic(responseTopic).build(), response, null);
                                    this.stats.incrementSuccessful();
                                }, e -> {
                                    this.pendingRequestCount.decrementAndGet();
                                    if (e.getCause() != null && e.getCause() instanceof TimeoutException) {
                                        log.warn("[{}] Timeout to process the request: {}", new Object[]{requestId, request, e});
                                    } else {
                                        log.trace("[{}] Failed to process the request: {}", new Object[]{requestId, request, e});
                                    }
                                    this.stats.incrementFailed();
                                }, this.requestTimeout, this.timeoutExecutor, this.callbackExecutor);
                            }
                            catch (Throwable e2) {
                                this.pendingRequestCount.decrementAndGet();
                                log.warn("[{}] Failed to process the request: {}", new Object[]{requestId, request, e2});
                                this.stats.incrementFailed();
                            }
                        }
                    });
                    this.requestTemplate.commit();
                }
                catch (Throwable e) {
                    log.warn("Failed to obtain messages from queue.", e);
                    try {
                        Thread.sleep(this.pollInterval);
                    }
                    catch (InterruptedException e2) {
                        log.trace("Failed to wait until the server has capacity to handle new requests", (Throwable)e2);
                    }
                }
            }
        });
    }

    public void stop() {
        this.stopped = true;
        if (this.requestTemplate != null) {
            this.requestTemplate.unsubscribe();
        }
        if (this.responseTemplate != null) {
            this.responseTemplate.stop();
        }
        if (this.timeoutExecutor != null) {
            this.timeoutExecutor.shutdownNow();
        }
        if (this.loopExecutor != null) {
            this.loopExecutor.shutdownNow();
        }
    }

    public static <Request extends TbQueueMsg, Response extends TbQueueMsg> DefaultTbQueueResponseTemplateBuilder<Request, Response> builder() {
        return new DefaultTbQueueResponseTemplateBuilder();
    }

    public static class DefaultTbQueueResponseTemplateBuilder<Request extends TbQueueMsg, Response extends TbQueueMsg> {
        private TbQueueConsumer<Request> requestTemplate;
        private TbQueueProducer<Response> responseTemplate;
        private TbQueueHandler<Request, Response> handler;
        private long pollInterval;
        private long requestTimeout;
        private int maxPendingRequests;
        private ExecutorService executor;
        private MessagesStats stats;

        DefaultTbQueueResponseTemplateBuilder() {
        }

        public DefaultTbQueueResponseTemplateBuilder<Request, Response> requestTemplate(TbQueueConsumer<Request> requestTemplate) {
            this.requestTemplate = requestTemplate;
            return this;
        }

        public DefaultTbQueueResponseTemplateBuilder<Request, Response> responseTemplate(TbQueueProducer<Response> responseTemplate) {
            this.responseTemplate = responseTemplate;
            return this;
        }

        public DefaultTbQueueResponseTemplateBuilder<Request, Response> handler(TbQueueHandler<Request, Response> handler) {
            this.handler = handler;
            return this;
        }

        public DefaultTbQueueResponseTemplateBuilder<Request, Response> pollInterval(long pollInterval) {
            this.pollInterval = pollInterval;
            return this;
        }

        public DefaultTbQueueResponseTemplateBuilder<Request, Response> requestTimeout(long requestTimeout) {
            this.requestTimeout = requestTimeout;
            return this;
        }

        public DefaultTbQueueResponseTemplateBuilder<Request, Response> maxPendingRequests(int maxPendingRequests) {
            this.maxPendingRequests = maxPendingRequests;
            return this;
        }

        public DefaultTbQueueResponseTemplateBuilder<Request, Response> executor(ExecutorService executor) {
            this.executor = executor;
            return this;
        }

        public DefaultTbQueueResponseTemplateBuilder<Request, Response> stats(MessagesStats stats) {
            this.stats = stats;
            return this;
        }

        public DefaultTbQueueResponseTemplate<Request, Response> build() {
            return new DefaultTbQueueResponseTemplate<Request, Response>(this.requestTemplate, this.responseTemplate, this.handler, this.pollInterval, this.requestTimeout, this.maxPendingRequests, this.executor, this.stats);
        }

        public String toString() {
            return "DefaultTbQueueResponseTemplate.DefaultTbQueueResponseTemplateBuilder(requestTemplate=" + this.requestTemplate + ", responseTemplate=" + this.responseTemplate + ", handler=" + this.handler + ", pollInterval=" + this.pollInterval + ", requestTimeout=" + this.requestTimeout + ", maxPendingRequests=" + this.maxPendingRequests + ", executor=" + this.executor + ", stats=" + this.stats + ")";
        }
    }
}

