/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.queue.common;

import java.util.Arrays;
import java.util.UUID;
import org.thingsboard.server.queue.TbQueueMsg;
import org.thingsboard.server.queue.common.DefaultTbQueueMsgHeaders;

public class DefaultTbQueueMsg
implements TbQueueMsg {
    private final UUID key;
    private final byte[] data;
    private final DefaultTbQueueMsgHeaders headers;

    public DefaultTbQueueMsg(TbQueueMsg msg) {
        this.key = msg.getKey();
        this.data = msg.getData();
        DefaultTbQueueMsgHeaders headers = new DefaultTbQueueMsgHeaders();
        msg.getHeaders().getData().forEach(headers::put);
        this.headers = headers;
    }

    public UUID getKey() {
        return this.key;
    }

    public byte[] getData() {
        return this.data;
    }

    public DefaultTbQueueMsgHeaders getHeaders() {
        return this.headers;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DefaultTbQueueMsg)) {
            return false;
        }
        DefaultTbQueueMsg other = (DefaultTbQueueMsg)o;
        if (!other.canEqual(this)) {
            return false;
        }
        UUID this$key = this.getKey();
        UUID other$key = other.getKey();
        if (this$key == null ? other$key != null : !((Object)this$key).equals(other$key)) {
            return false;
        }
        if (!Arrays.equals(this.getData(), other.getData())) {
            return false;
        }
        DefaultTbQueueMsgHeaders this$headers = this.getHeaders();
        DefaultTbQueueMsgHeaders other$headers = other.getHeaders();
        return !(this$headers == null ? other$headers != null : !this$headers.equals(other$headers));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DefaultTbQueueMsg;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        UUID $key = this.getKey();
        result = result * 59 + ($key == null ? 43 : ((Object)$key).hashCode());
        result = result * 59 + Arrays.hashCode(this.getData());
        DefaultTbQueueMsgHeaders $headers = this.getHeaders();
        result = result * 59 + ($headers == null ? 43 : $headers.hashCode());
        return result;
    }

    public String toString() {
        return "DefaultTbQueueMsg(key=" + this.getKey() + ", data=" + Arrays.toString(this.getData()) + ", headers=" + this.getHeaders() + ")";
    }
}

