/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.queue.common;

import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;

public class AsyncCallbackTemplate {
    public static <T> void withCallbackAndTimeout(ListenableFuture<T> future, Consumer<T> onSuccess, Consumer<Throwable> onFailure, long timeoutInMs, ScheduledExecutorService timeoutExecutor, Executor callbackExecutor) {
        future = Futures.withTimeout(future, (long)timeoutInMs, (TimeUnit)TimeUnit.MILLISECONDS, (ScheduledExecutorService)timeoutExecutor);
        AsyncCallbackTemplate.withCallback(future, onSuccess, onFailure, callbackExecutor);
    }

    public static <T> void withCallback(ListenableFuture<T> future, final Consumer<T> onSuccess, final Consumer<Throwable> onFailure, Executor executor) {
        FutureCallback callback = new FutureCallback<T>(){

            public void onSuccess(T result) {
                try {
                    onSuccess.accept(result);
                }
                catch (Throwable th) {
                    this.onFailure(th);
                }
            }

            public void onFailure(Throwable t) {
                onFailure.accept(t);
            }
        };
        if (executor != null) {
            Futures.addCallback(future, (FutureCallback)callback, (Executor)executor);
        } else {
            Futures.addCallback(future, (FutureCallback)callback, (Executor)MoreExecutors.directExecutor());
        }
    }
}

