/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.queue.usagestats;

import java.util.EnumMap;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.thingsboard.server.common.data.ApiUsageRecordKey;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.id.CustomerId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.msg.queue.ServiceType;
import org.thingsboard.server.common.msg.queue.TopicPartitionInfo;
import org.thingsboard.server.common.stats.TbApiUsageReportClient;
import org.thingsboard.server.gen.transport.TransportProtos;
import org.thingsboard.server.queue.TbQueueProducer;
import org.thingsboard.server.queue.common.TbProtoQueueMsg;
import org.thingsboard.server.queue.discovery.PartitionService;
import org.thingsboard.server.queue.provider.TbQueueProducerProvider;
import org.thingsboard.server.queue.scheduler.SchedulerComponent;

@Component
public class DefaultTbApiUsageReportClient
implements TbApiUsageReportClient {
    private static final Logger log = LoggerFactory.getLogger(DefaultTbApiUsageReportClient.class);
    @Value(value="${usage.stats.report.enabled:true}")
    private boolean enabled;
    @Value(value="${usage.stats.report.enabled_per_customer:false}")
    private boolean enabledPerCustomer;
    @Value(value="${usage.stats.report.interval:10}")
    private int interval;
    private final EnumMap<ApiUsageRecordKey, ConcurrentMap<OwnerId, AtomicLong>> stats = new EnumMap(ApiUsageRecordKey.class);
    private final PartitionService partitionService;
    private final SchedulerComponent scheduler;
    private final TbQueueProducerProvider producerProvider;
    private TbQueueProducer<TbProtoQueueMsg<TransportProtos.ToUsageStatsServiceMsg>> msgProducer;

    public DefaultTbApiUsageReportClient(PartitionService partitionService, SchedulerComponent scheduler, TbQueueProducerProvider producerProvider) {
        this.partitionService = partitionService;
        this.scheduler = scheduler;
        this.producerProvider = producerProvider;
    }

    @PostConstruct
    private void init() {
        if (this.enabled) {
            this.msgProducer = this.producerProvider.getTbUsageStatsMsgProducer();
            for (ApiUsageRecordKey key : ApiUsageRecordKey.values()) {
                this.stats.put(key, new ConcurrentHashMap());
            }
            this.scheduler.scheduleWithFixedDelay(() -> {
                try {
                    this.reportStats();
                }
                catch (Exception e) {
                    log.warn("Failed to report statistics: ", (Throwable)e);
                }
            }, new Random().nextInt(this.interval), this.interval, TimeUnit.SECONDS);
        }
    }

    private void reportStats() {
        ConcurrentHashMap<OwnerId, TransportProtos.ToUsageStatsServiceMsg.Builder> report = new ConcurrentHashMap<OwnerId, TransportProtos.ToUsageStatsServiceMsg.Builder>();
        for (ApiUsageRecordKey key : ApiUsageRecordKey.values()) {
            ConcurrentMap<OwnerId, AtomicLong> statsForKey = this.stats.get(key);
            statsForKey.forEach((ownerId, statsValue) -> {
                long value = statsValue.get();
                if (value == 0L) {
                    return;
                }
                TransportProtos.ToUsageStatsServiceMsg.Builder statsMsgBuilder = report.computeIfAbsent((OwnerId)ownerId, id -> {
                    TransportProtos.ToUsageStatsServiceMsg.Builder newStatsMsgBuilder = TransportProtos.ToUsageStatsServiceMsg.newBuilder();
                    TenantId tenantId = ownerId.getTenantId();
                    newStatsMsgBuilder.setTenantIdMSB(tenantId.getId().getMostSignificantBits());
                    newStatsMsgBuilder.setTenantIdLSB(tenantId.getId().getLeastSignificantBits());
                    EntityId entityId = ownerId.getEntityId();
                    if (entityId != null && entityId.getEntityType() == EntityType.CUSTOMER) {
                        newStatsMsgBuilder.setCustomerIdMSB(entityId.getId().getMostSignificantBits());
                        newStatsMsgBuilder.setCustomerIdLSB(entityId.getId().getLeastSignificantBits());
                    }
                    return newStatsMsgBuilder;
                });
                statsMsgBuilder.addValues(TransportProtos.UsageStatsKVProto.newBuilder().setKey(key.name()).setValue(value).build());
            });
            statsForKey.clear();
        }
        report.forEach((ownerId, statsMsg) -> {
            TenantId tenantId = ownerId.getTenantId();
            EntityId entityId = Optional.ofNullable(ownerId.getEntityId()).orElse((EntityId)tenantId);
            TopicPartitionInfo tpi = this.partitionService.resolve(ServiceType.TB_CORE, tenantId, entityId).newByTopic(this.msgProducer.getDefaultTopic());
            this.msgProducer.send(tpi, new TbProtoQueueMsg<TransportProtos.ToUsageStatsServiceMsg>(UUID.randomUUID(), statsMsg.build()), null);
        });
        if (!report.isEmpty()) {
            log.debug("Reporting API usage statistics for {} tenants and customers", (Object)report.size());
        }
    }

    public void report(TenantId tenantId, CustomerId customerId, ApiUsageRecordKey key, long value) {
        if (this.enabled) {
            ConcurrentMap<OwnerId, AtomicLong> statsForKey = this.stats.get(key);
            statsForKey.computeIfAbsent(new OwnerId(tenantId), id -> new AtomicLong()).addAndGet(value);
            statsForKey.computeIfAbsent(new OwnerId(TenantId.SYS_TENANT_ID), id -> new AtomicLong()).addAndGet(value);
            if (this.enabledPerCustomer && customerId != null && !customerId.isNullUid()) {
                statsForKey.computeIfAbsent(new OwnerId(tenantId, (EntityId)customerId), id -> new AtomicLong()).addAndGet(value);
            }
        }
    }

    public void report(TenantId tenantId, CustomerId customerId, ApiUsageRecordKey key) {
        this.report(tenantId, customerId, key, 1L);
    }

    private static class OwnerId {
        private TenantId tenantId;
        private EntityId entityId;

        public OwnerId(TenantId tenantId) {
            this.tenantId = tenantId;
        }

        public OwnerId(TenantId tenantId, EntityId entityId) {
            this.tenantId = tenantId;
            this.entityId = entityId;
        }

        public TenantId getTenantId() {
            return this.tenantId;
        }

        public EntityId getEntityId() {
            return this.entityId;
        }

        public void setTenantId(TenantId tenantId) {
            this.tenantId = tenantId;
        }

        public void setEntityId(EntityId entityId) {
            this.entityId = entityId;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof OwnerId)) {
                return false;
            }
            OwnerId other = (OwnerId)o;
            if (!other.canEqual(this)) {
                return false;
            }
            TenantId this$tenantId = this.getTenantId();
            TenantId other$tenantId = other.getTenantId();
            if (this$tenantId == null ? other$tenantId != null : !this$tenantId.equals(other$tenantId)) {
                return false;
            }
            EntityId this$entityId = this.getEntityId();
            EntityId other$entityId = other.getEntityId();
            return !(this$entityId == null ? other$entityId != null : !this$entityId.equals(other$entityId));
        }

        protected boolean canEqual(Object other) {
            return other instanceof OwnerId;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            TenantId $tenantId = this.getTenantId();
            result = result * 59 + ($tenantId == null ? 43 : $tenantId.hashCode());
            EntityId $entityId = this.getEntityId();
            result = result * 59 + ($entityId == null ? 43 : $entityId.hashCode());
            return result;
        }

        public String toString() {
            return "DefaultTbApiUsageReportClient.OwnerId(tenantId=" + this.getTenantId() + ", entityId=" + this.getEntityId() + ")";
        }
    }
}

