/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.queue.sqs;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.services.sqs.AmazonSQS;
import com.amazonaws.services.sqs.AmazonSQSClientBuilder;
import com.amazonaws.services.sqs.model.SendMessageRequest;
import com.amazonaws.services.sqs.model.SendMessageResult;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.gson.Gson;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.server.common.msg.queue.TopicPartitionInfo;
import org.thingsboard.server.queue.TbQueueAdmin;
import org.thingsboard.server.queue.TbQueueCallback;
import org.thingsboard.server.queue.TbQueueMsg;
import org.thingsboard.server.queue.TbQueueMsgMetadata;
import org.thingsboard.server.queue.TbQueueProducer;
import org.thingsboard.server.queue.common.DefaultTbQueueMsg;
import org.thingsboard.server.queue.sqs.AwsSqsTbQueueMsgMetadata;
import org.thingsboard.server.queue.sqs.TbAwsSqsSettings;

public class TbAwsSqsProducerTemplate<T extends TbQueueMsg>
implements TbQueueProducer<T> {
    private static final Logger log = LoggerFactory.getLogger(TbAwsSqsProducerTemplate.class);
    private final String defaultTopic;
    private final AmazonSQS sqsClient;
    private final Gson gson = new Gson();
    private final Map<String, String> queueUrlMap = new ConcurrentHashMap<String, String>();
    private final TbQueueAdmin admin;
    private ListeningExecutorService producerExecutor;

    public TbAwsSqsProducerTemplate(TbQueueAdmin admin, TbAwsSqsSettings sqsSettings, String defaultTopic) {
        DefaultAWSCredentialsProviderChain credentialsProvider;
        this.admin = admin;
        this.defaultTopic = defaultTopic;
        if (sqsSettings.getUseDefaultCredentialProviderChain().booleanValue()) {
            credentialsProvider = new DefaultAWSCredentialsProviderChain();
        } else {
            BasicAWSCredentials awsCredentials = new BasicAWSCredentials(sqsSettings.getAccessKeyId(), sqsSettings.getSecretAccessKey());
            credentialsProvider = new AWSStaticCredentialsProvider((AWSCredentials)awsCredentials);
        }
        this.sqsClient = (AmazonSQS)((AmazonSQSClientBuilder)((AmazonSQSClientBuilder)AmazonSQSClientBuilder.standard().withCredentials((AWSCredentialsProvider)credentialsProvider)).withRegion(sqsSettings.getRegion())).build();
        this.producerExecutor = MoreExecutors.listeningDecorator((ExecutorService)Executors.newCachedThreadPool());
    }

    public void init() {
    }

    public String getDefaultTopic() {
        return this.defaultTopic;
    }

    public void send(TopicPartitionInfo tpi, T msg, final TbQueueCallback callback) {
        SendMessageRequest sendMsgRequest = new SendMessageRequest();
        sendMsgRequest.withQueueUrl(this.getQueueUrl(tpi.getFullTopicName()));
        sendMsgRequest.withMessageBody(this.gson.toJson((Object)new DefaultTbQueueMsg((TbQueueMsg)msg)));
        String sqsMsgId = UUID.randomUUID().toString();
        sendMsgRequest.withMessageGroupId(sqsMsgId);
        sendMsgRequest.withMessageDeduplicationId(sqsMsgId);
        ListenableFuture future = this.producerExecutor.submit(() -> this.sqsClient.sendMessage(sendMsgRequest));
        Futures.addCallback((ListenableFuture)future, (FutureCallback)new FutureCallback<SendMessageResult>(){

            public void onSuccess(SendMessageResult result) {
                if (callback != null) {
                    callback.onSuccess((TbQueueMsgMetadata)new AwsSqsTbQueueMsgMetadata(result.getSdkHttpMetadata()));
                }
            }

            public void onFailure(Throwable t) {
                if (callback != null) {
                    callback.onFailure(t);
                }
            }
        }, (Executor)this.producerExecutor);
    }

    public void stop() {
        if (this.producerExecutor != null) {
            this.producerExecutor.shutdownNow();
        }
        if (this.sqsClient != null) {
            this.sqsClient.shutdown();
        }
    }

    private String getQueueUrl(String topic) {
        return this.queueUrlMap.computeIfAbsent(topic, k -> {
            this.admin.createTopicIfNotExists(topic);
            return this.sqsClient.getQueueUrl(topic.replaceAll("\\.", "_") + ".fifo").getQueueUrl();
        });
    }
}

