/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.queue.sqs;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.services.sqs.AmazonSQS;
import com.amazonaws.services.sqs.AmazonSQSClientBuilder;
import com.amazonaws.services.sqs.model.CreateQueueRequest;
import com.amazonaws.services.sqs.model.GetQueueUrlResult;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.server.queue.TbQueueAdmin;
import org.thingsboard.server.queue.sqs.TbAwsSqsSettings;

public class TbAwsSqsAdmin
implements TbQueueAdmin {
    private static final Logger log = LoggerFactory.getLogger(TbAwsSqsAdmin.class);
    private final Map<String, String> attributes;
    private final AmazonSQS sqsClient;
    private final Map<String, String> queues;

    public TbAwsSqsAdmin(TbAwsSqsSettings sqsSettings, Map<String, String> attributes) {
        DefaultAWSCredentialsProviderChain credentialsProvider;
        this.attributes = attributes;
        if (sqsSettings.getUseDefaultCredentialProviderChain().booleanValue()) {
            credentialsProvider = new DefaultAWSCredentialsProviderChain();
        } else {
            BasicAWSCredentials awsCredentials = new BasicAWSCredentials(sqsSettings.getAccessKeyId(), sqsSettings.getSecretAccessKey());
            credentialsProvider = new AWSStaticCredentialsProvider((AWSCredentials)awsCredentials);
        }
        this.sqsClient = (AmazonSQS)((AmazonSQSClientBuilder)((AmazonSQSClientBuilder)AmazonSQSClientBuilder.standard().withCredentials((AWSCredentialsProvider)credentialsProvider)).withRegion(sqsSettings.getRegion())).build();
        this.queues = this.sqsClient.listQueues().getQueueUrls().stream().map(this::getQueueNameFromUrl).collect(Collectors.toMap(this::convertTopicToQueueName, Function.identity()));
    }

    public void createTopicIfNotExists(String topic) {
        String queueName = this.convertTopicToQueueName(topic);
        if (this.queues.containsKey(queueName)) {
            return;
        }
        CreateQueueRequest createQueueRequest = new CreateQueueRequest(queueName).withAttributes(this.attributes);
        String queueUrl = this.sqsClient.createQueue(createQueueRequest).getQueueUrl();
        this.queues.put(this.getQueueNameFromUrl(queueUrl), queueUrl);
    }

    private String convertTopicToQueueName(String topic) {
        return topic.replaceAll("\\.", "_") + ".fifo";
    }

    public void deleteTopic(String topic) {
        String queueName = this.convertTopicToQueueName(topic);
        if (this.queues.containsKey(queueName)) {
            this.sqsClient.deleteQueue(this.queues.get(queueName));
        } else {
            GetQueueUrlResult queueUrl = this.sqsClient.getQueueUrl(queueName);
            if (queueUrl != null) {
                this.sqsClient.deleteQueue(queueUrl.getQueueUrl());
            } else {
                log.warn("Aws SQS queue [{}] does not exist!", (Object)queueName);
            }
        }
    }

    private String getQueueNameFromUrl(String queueUrl) {
        int delimiterIndex = queueUrl.lastIndexOf("/");
        return queueUrl.substring(delimiterIndex + 1);
    }

    public void destroy() {
        if (this.sqsClient != null) {
            this.sqsClient.shutdown();
        }
    }
}

