/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.queue.rabbitmq;

import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.gson.Gson;
import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import java.io.IOException;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.server.common.msg.queue.TopicPartitionInfo;
import org.thingsboard.server.queue.TbQueueAdmin;
import org.thingsboard.server.queue.TbQueueCallback;
import org.thingsboard.server.queue.TbQueueMsg;
import org.thingsboard.server.queue.TbQueueProducer;
import org.thingsboard.server.queue.common.DefaultTbQueueMsg;
import org.thingsboard.server.queue.rabbitmq.TbRabbitMqSettings;

public class TbRabbitMqProducerTemplate<T extends TbQueueMsg>
implements TbQueueProducer<T> {
    private static final Logger log = LoggerFactory.getLogger(TbRabbitMqProducerTemplate.class);
    private final String defaultTopic;
    private final Gson gson = new Gson();
    private final TbQueueAdmin admin;
    private final TbRabbitMqSettings rabbitMqSettings;
    private final ListeningExecutorService producerExecutor;
    private final Channel channel;
    private final Connection connection;
    private final Set<TopicPartitionInfo> topics = ConcurrentHashMap.newKeySet();

    public TbRabbitMqProducerTemplate(TbQueueAdmin admin, TbRabbitMqSettings rabbitMqSettings, String defaultTopic) {
        this.admin = admin;
        this.defaultTopic = defaultTopic;
        this.rabbitMqSettings = rabbitMqSettings;
        this.producerExecutor = MoreExecutors.listeningDecorator((ExecutorService)Executors.newCachedThreadPool());
        try {
            this.connection = rabbitMqSettings.getConnectionFactory().newConnection();
        }
        catch (IOException | TimeoutException e) {
            log.error("Failed to create connection.", (Throwable)e);
            throw new RuntimeException("Failed to create connection.", e);
        }
        try {
            this.channel = this.connection.createChannel();
        }
        catch (IOException e) {
            log.error("Failed to create chanel.", (Throwable)e);
            throw new RuntimeException("Failed to create chanel.", e);
        }
    }

    public void init() {
    }

    public String getDefaultTopic() {
        return this.defaultTopic;
    }

    public void send(TopicPartitionInfo tpi, T msg, TbQueueCallback callback) {
        block3: {
            this.createTopicIfNotExist(tpi);
            AMQP.BasicProperties properties = new AMQP.BasicProperties();
            try {
                this.channel.basicPublish(this.rabbitMqSettings.getExchangeName(), tpi.getFullTopicName(), properties, this.gson.toJson((Object)new DefaultTbQueueMsg((TbQueueMsg)msg)).getBytes());
                if (callback != null) {
                    callback.onSuccess(null);
                }
            }
            catch (IOException e) {
                log.error("Failed publish message: [{}].", msg, (Object)e);
                if (callback == null) break block3;
                callback.onFailure((Throwable)e);
            }
        }
    }

    public void stop() {
        if (this.producerExecutor != null) {
            this.producerExecutor.shutdownNow();
        }
        if (this.channel != null) {
            try {
                this.channel.close();
            }
            catch (IOException | TimeoutException e) {
                log.error("Failed to close the channel.");
            }
        }
        if (this.connection != null) {
            try {
                this.connection.close();
            }
            catch (IOException e) {
                log.error("Failed to close the connection.");
            }
        }
    }

    private void createTopicIfNotExist(TopicPartitionInfo tpi) {
        if (this.topics.contains(tpi)) {
            return;
        }
        this.admin.createTopicIfNotExists(tpi.getFullTopicName());
        this.topics.add(tpi);
    }
}

