/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.queue.pubsub;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.stereotype.Component;
import org.thingsboard.server.common.data.StringUtils;

@Component
@ConditionalOnExpression(value="'${queue.type:null}'=='pubsub'")
public class TbPubSubSubscriptionSettings {
    @Value(value="${queue.pubsub.queue-properties.core:}")
    private String coreProperties;
    @Value(value="${queue.pubsub.queue-properties.rule-engine:}")
    private String ruleEngineProperties;
    @Value(value="${queue.pubsub.queue-properties.transport-api:}")
    private String transportApiProperties;
    @Value(value="${queue.pubsub.queue-properties.notifications:}")
    private String notificationsProperties;
    @Value(value="${queue.pubsub.queue-properties.js-executor:}")
    private String jsExecutorProperties;
    @Value(value="${queue.pubsub.queue-properties.version-control:}")
    private String vcProperties;
    private Map<String, String> coreSettings;
    private Map<String, String> ruleEngineSettings;
    private Map<String, String> transportApiSettings;
    private Map<String, String> notificationsSettings;
    private Map<String, String> jsExecutorSettings;
    private Map<String, String> vcSettings;

    @PostConstruct
    private void init() {
        this.coreSettings = this.getSettings(this.coreProperties);
        this.ruleEngineSettings = this.getSettings(this.ruleEngineProperties);
        this.transportApiSettings = this.getSettings(this.transportApiProperties);
        this.notificationsSettings = this.getSettings(this.notificationsProperties);
        this.jsExecutorSettings = this.getSettings(this.jsExecutorProperties);
        this.vcSettings = this.getSettings(this.vcProperties);
    }

    private Map<String, String> getSettings(String properties) {
        HashMap<String, String> configs = new HashMap<String, String>();
        if (StringUtils.isNotEmpty((String)properties)) {
            for (String property : properties.split(";")) {
                int delimiterPosition = property.indexOf(":");
                String key = property.substring(0, delimiterPosition);
                String value = property.substring(delimiterPosition + 1);
                configs.put(key, value);
            }
        }
        return configs;
    }

    public Map<String, String> getCoreSettings() {
        return this.coreSettings;
    }

    public Map<String, String> getRuleEngineSettings() {
        return this.ruleEngineSettings;
    }

    public Map<String, String> getTransportApiSettings() {
        return this.transportApiSettings;
    }

    public Map<String, String> getNotificationsSettings() {
        return this.notificationsSettings;
    }

    public Map<String, String> getJsExecutorSettings() {
        return this.jsExecutorSettings;
    }

    public Map<String, String> getVcSettings() {
        return this.vcSettings;
    }
}

