/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.queue.pubsub;

import com.google.api.gax.rpc.AlreadyExistsException;
import com.google.cloud.pubsub.v1.SubscriptionAdminClient;
import com.google.cloud.pubsub.v1.SubscriptionAdminSettings;
import com.google.cloud.pubsub.v1.TopicAdminClient;
import com.google.cloud.pubsub.v1.TopicAdminSettings;
import com.google.protobuf.Duration;
import com.google.pubsub.v1.ListSubscriptionsRequest;
import com.google.pubsub.v1.ListTopicsRequest;
import com.google.pubsub.v1.ProjectName;
import com.google.pubsub.v1.ProjectSubscriptionName;
import com.google.pubsub.v1.Subscription;
import com.google.pubsub.v1.Topic;
import com.google.pubsub.v1.TopicName;
import java.io.IOException;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.server.queue.TbQueueAdmin;
import org.thingsboard.server.queue.pubsub.TbPubSubSettings;

public class TbPubSubAdmin
implements TbQueueAdmin {
    private static final Logger log = LoggerFactory.getLogger(TbPubSubAdmin.class);
    private static final String ACK_DEADLINE = "ackDeadlineInSec";
    private static final String MESSAGE_RETENTION = "messageRetentionInSec";
    private final TopicAdminClient topicAdminClient;
    private final SubscriptionAdminClient subscriptionAdminClient;
    private final TbPubSubSettings pubSubSettings;
    private final Set<String> topicSet = ConcurrentHashMap.newKeySet();
    private final Set<String> subscriptionSet = ConcurrentHashMap.newKeySet();
    private final Map<String, String> subscriptionProperties;

    public TbPubSubAdmin(TbPubSubSettings pubSubSettings, Map<String, String> subscriptionSettings) {
        TopicAdminClient.ListTopicsPagedResponse response;
        SubscriptionAdminSettings subscriptionAdminSettings;
        TopicAdminSettings topicAdminSettings;
        this.pubSubSettings = pubSubSettings;
        this.subscriptionProperties = subscriptionSettings;
        try {
            topicAdminSettings = ((TopicAdminSettings.Builder)TopicAdminSettings.newBuilder().setCredentialsProvider(pubSubSettings.getCredentialsProvider())).build();
        }
        catch (IOException e) {
            log.error("Failed to create TopicAdminSettings");
            throw new RuntimeException("Failed to create TopicAdminSettings.");
        }
        try {
            subscriptionAdminSettings = ((SubscriptionAdminSettings.Builder)SubscriptionAdminSettings.newBuilder().setCredentialsProvider(pubSubSettings.getCredentialsProvider())).build();
        }
        catch (IOException e) {
            log.error("Failed to create SubscriptionAdminSettings");
            throw new RuntimeException("Failed to create SubscriptionAdminSettings.");
        }
        try {
            this.topicAdminClient = TopicAdminClient.create((TopicAdminSettings)topicAdminSettings);
            ListTopicsRequest listTopicsRequest = ListTopicsRequest.newBuilder().setProject(ProjectName.format((String)pubSubSettings.getProjectId())).build();
            response = this.topicAdminClient.listTopics(listTopicsRequest);
            for (Topic topic : response.iterateAll()) {
                this.topicSet.add(topic.getName());
            }
        }
        catch (IOException e) {
            log.error("Failed to get topics.", (Throwable)e);
            throw new RuntimeException("Failed to get topics.", e);
        }
        try {
            this.subscriptionAdminClient = SubscriptionAdminClient.create((SubscriptionAdminSettings)subscriptionAdminSettings);
            ListSubscriptionsRequest listSubscriptionsRequest = ListSubscriptionsRequest.newBuilder().setProject(ProjectName.of((String)pubSubSettings.getProjectId()).toString()).build();
            response = this.subscriptionAdminClient.listSubscriptions(listSubscriptionsRequest);
            for (Subscription subscription : response.iterateAll()) {
                this.subscriptionSet.add(subscription.getName());
            }
        }
        catch (IOException e) {
            log.error("Failed to get subscriptions.", (Throwable)e);
            throw new RuntimeException("Failed to get subscriptions.", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createTopicIfNotExists(String partition) {
        TopicName topicName = TopicName.newBuilder().setTopic(partition).setProject(this.pubSubSettings.getProjectId()).build();
        if (this.topicSet.contains(topicName.toString())) {
            this.createSubscriptionIfNotExists(partition, topicName);
            return;
        }
        ListTopicsRequest listTopicsRequest = ListTopicsRequest.newBuilder().setProject(ProjectName.format((String)this.pubSubSettings.getProjectId())).build();
        TopicAdminClient.ListTopicsPagedResponse response = this.topicAdminClient.listTopics(listTopicsRequest);
        for (Topic topic : response.iterateAll()) {
            if (!topic.getName().contains(topicName.toString())) continue;
            this.topicSet.add(topic.getName());
            this.createSubscriptionIfNotExists(partition, topicName);
            return;
        }
        try {
            this.topicAdminClient.createTopic(topicName);
            log.info("Created new topic: [{}]", (Object)topicName.toString());
        }
        catch (AlreadyExistsException e) {
            log.info("[{}] Topic already exist.", (Object)topicName.toString());
        }
        finally {
            this.topicSet.add(topicName.toString());
        }
        this.createSubscriptionIfNotExists(partition, topicName);
    }

    public void deleteTopic(String topic) {
        TopicName topicName = TopicName.newBuilder().setTopic(topic).setProject(this.pubSubSettings.getProjectId()).build();
        ProjectSubscriptionName subscriptionName = ProjectSubscriptionName.of((String)this.pubSubSettings.getProjectId(), (String)topic);
        if (this.topicSet.contains(topicName.toString())) {
            this.topicAdminClient.deleteTopic(topicName);
        } else if (this.topicAdminClient.getTopic(topicName) != null) {
            this.topicAdminClient.deleteTopic(topicName);
        } else {
            log.warn("PubSub topic [{}] does not exist.", (Object)topic);
        }
        if (this.subscriptionSet.contains(subscriptionName.toString())) {
            this.subscriptionAdminClient.deleteSubscription(subscriptionName);
        } else if (this.subscriptionAdminClient.getSubscription(subscriptionName) != null) {
            this.subscriptionAdminClient.deleteSubscription(subscriptionName);
        } else {
            log.warn("PubSub subscription [{}] does not exist.", (Object)topic);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createSubscriptionIfNotExists(String partition, TopicName topicName) {
        ProjectSubscriptionName subscriptionName = ProjectSubscriptionName.of((String)this.pubSubSettings.getProjectId(), (String)partition);
        if (this.subscriptionSet.contains(subscriptionName.toString())) {
            return;
        }
        ListSubscriptionsRequest listSubscriptionsRequest = ListSubscriptionsRequest.newBuilder().setProject(ProjectName.of((String)this.pubSubSettings.getProjectId()).toString()).build();
        SubscriptionAdminClient.ListSubscriptionsPagedResponse response = this.subscriptionAdminClient.listSubscriptions(listSubscriptionsRequest);
        for (Subscription subscription : response.iterateAll()) {
            if (!subscription.getName().equals(subscriptionName.toString())) continue;
            this.subscriptionSet.add(subscription.getName());
            return;
        }
        Subscription.Builder subscriptionBuilder = Subscription.newBuilder().setName(subscriptionName.toString()).setTopic(topicName.toString());
        this.setAckDeadline(subscriptionBuilder);
        this.setMessageRetention(subscriptionBuilder);
        try {
            this.subscriptionAdminClient.createSubscription(subscriptionBuilder.build());
            log.info("Created new subscription: [{}]", (Object)subscriptionName.toString());
        }
        catch (AlreadyExistsException e) {
            log.info("[{}] Subscription already exist.", (Object)subscriptionName.toString());
        }
        finally {
            this.subscriptionSet.add(subscriptionName.toString());
        }
    }

    private void setAckDeadline(Subscription.Builder builder) {
        if (this.subscriptionProperties.containsKey(ACK_DEADLINE)) {
            builder.setAckDeadlineSeconds(Integer.parseInt(this.subscriptionProperties.get(ACK_DEADLINE)));
        }
    }

    private void setMessageRetention(Subscription.Builder builder) {
        if (this.subscriptionProperties.containsKey(MESSAGE_RETENTION)) {
            Duration duration = Duration.newBuilder().setSeconds(Long.parseLong(this.subscriptionProperties.get(MESSAGE_RETENTION))).build();
            builder.setMessageRetentionDuration(duration);
        }
    }

    public void destroy() {
        if (this.topicAdminClient != null) {
            this.topicAdminClient.close();
        }
        if (this.subscriptionAdminClient != null) {
            this.subscriptionAdminClient.close();
        }
    }
}

