/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.queue.provider;

import com.google.protobuf.Message;
import com.google.protobuf.util.JsonFormat;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.PreDestroy;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.context.annotation.Bean;
import org.springframework.stereotype.Component;
import org.thingsboard.server.common.data.queue.Queue;
import org.thingsboard.server.common.msg.queue.ServiceType;
import org.thingsboard.server.gen.js.JsInvokeProtos;
import org.thingsboard.server.gen.transport.TransportProtos;
import org.thingsboard.server.queue.TbQueueAdmin;
import org.thingsboard.server.queue.TbQueueConsumer;
import org.thingsboard.server.queue.TbQueueProducer;
import org.thingsboard.server.queue.TbQueueRequestTemplate;
import org.thingsboard.server.queue.common.DefaultTbQueueRequestTemplate;
import org.thingsboard.server.queue.common.TbProtoJsQueueMsg;
import org.thingsboard.server.queue.common.TbProtoQueueMsg;
import org.thingsboard.server.queue.discovery.NotificationsTopicService;
import org.thingsboard.server.queue.discovery.TbServiceInfoProvider;
import org.thingsboard.server.queue.kafka.TbKafkaAdmin;
import org.thingsboard.server.queue.kafka.TbKafkaConsumerStatsService;
import org.thingsboard.server.queue.kafka.TbKafkaConsumerTemplate;
import org.thingsboard.server.queue.kafka.TbKafkaProducerTemplate;
import org.thingsboard.server.queue.kafka.TbKafkaSettings;
import org.thingsboard.server.queue.kafka.TbKafkaTopicConfigs;
import org.thingsboard.server.queue.provider.TbRuleEngineQueueFactory;
import org.thingsboard.server.queue.settings.TbQueueCoreSettings;
import org.thingsboard.server.queue.settings.TbQueueRemoteJsInvokeSettings;
import org.thingsboard.server.queue.settings.TbQueueRuleEngineSettings;
import org.thingsboard.server.queue.settings.TbQueueTransportNotificationSettings;

@Component
@ConditionalOnExpression(value="'${queue.type:null}'=='kafka' && '${service.type:null}'=='tb-rule-engine'")
public class KafkaTbRuleEngineQueueFactory
implements TbRuleEngineQueueFactory {
    private final NotificationsTopicService notificationsTopicService;
    private final TbKafkaSettings kafkaSettings;
    private final TbServiceInfoProvider serviceInfoProvider;
    private final TbQueueCoreSettings coreSettings;
    private final TbQueueRuleEngineSettings ruleEngineSettings;
    private final TbQueueRemoteJsInvokeSettings jsInvokeSettings;
    private final TbKafkaConsumerStatsService consumerStatsService;
    private final TbQueueTransportNotificationSettings transportNotificationSettings;
    private final TbQueueAdmin coreAdmin;
    private final TbQueueAdmin ruleEngineAdmin;
    private final TbQueueAdmin jsExecutorRequestAdmin;
    private final TbQueueAdmin jsExecutorResponseAdmin;
    private final TbQueueAdmin notificationAdmin;
    private final TbQueueAdmin fwUpdatesAdmin;
    private final AtomicLong consumerCount = new AtomicLong();

    public KafkaTbRuleEngineQueueFactory(NotificationsTopicService notificationsTopicService, TbKafkaSettings kafkaSettings, TbServiceInfoProvider serviceInfoProvider, TbQueueCoreSettings coreSettings, TbQueueRuleEngineSettings ruleEngineSettings, TbQueueRemoteJsInvokeSettings jsInvokeSettings, TbKafkaConsumerStatsService consumerStatsService, TbQueueTransportNotificationSettings transportNotificationSettings, TbKafkaTopicConfigs kafkaTopicConfigs) {
        this.notificationsTopicService = notificationsTopicService;
        this.kafkaSettings = kafkaSettings;
        this.serviceInfoProvider = serviceInfoProvider;
        this.coreSettings = coreSettings;
        this.ruleEngineSettings = ruleEngineSettings;
        this.jsInvokeSettings = jsInvokeSettings;
        this.consumerStatsService = consumerStatsService;
        this.transportNotificationSettings = transportNotificationSettings;
        this.coreAdmin = new TbKafkaAdmin(kafkaSettings, kafkaTopicConfigs.getCoreConfigs());
        this.ruleEngineAdmin = new TbKafkaAdmin(kafkaSettings, kafkaTopicConfigs.getRuleEngineConfigs());
        this.jsExecutorRequestAdmin = new TbKafkaAdmin(kafkaSettings, kafkaTopicConfigs.getJsExecutorRequestConfigs());
        this.jsExecutorResponseAdmin = new TbKafkaAdmin(kafkaSettings, kafkaTopicConfigs.getJsExecutorResponseConfigs());
        this.notificationAdmin = new TbKafkaAdmin(kafkaSettings, kafkaTopicConfigs.getNotificationsConfigs());
        this.fwUpdatesAdmin = new TbKafkaAdmin(kafkaSettings, kafkaTopicConfigs.getFwUpdatesConfigs());
    }

    @Override
    public TbQueueProducer<TbProtoQueueMsg<TransportProtos.ToTransportMsg>> createTransportNotificationsMsgProducer() {
        TbKafkaProducerTemplate.TbKafkaProducerTemplateBuilder requestBuilder = TbKafkaProducerTemplate.builder();
        requestBuilder.settings(this.kafkaSettings);
        requestBuilder.clientId("tb-rule-engine-transport-notifications-" + this.serviceInfoProvider.getServiceId());
        requestBuilder.defaultTopic(this.transportNotificationSettings.getNotificationsTopic());
        requestBuilder.admin(this.notificationAdmin);
        return requestBuilder.build();
    }

    @Override
    public TbQueueProducer<TbProtoQueueMsg<TransportProtos.ToRuleEngineMsg>> createRuleEngineMsgProducer() {
        TbKafkaProducerTemplate.TbKafkaProducerTemplateBuilder requestBuilder = TbKafkaProducerTemplate.builder();
        requestBuilder.settings(this.kafkaSettings);
        requestBuilder.clientId("tb-rule-engine-to-rule-engine-" + this.serviceInfoProvider.getServiceId());
        requestBuilder.defaultTopic(this.ruleEngineSettings.getTopic());
        requestBuilder.admin(this.ruleEngineAdmin);
        return requestBuilder.build();
    }

    @Override
    public TbQueueProducer<TbProtoQueueMsg<TransportProtos.ToRuleEngineNotificationMsg>> createRuleEngineNotificationsMsgProducer() {
        TbKafkaProducerTemplate.TbKafkaProducerTemplateBuilder requestBuilder = TbKafkaProducerTemplate.builder();
        requestBuilder.settings(this.kafkaSettings);
        requestBuilder.clientId("tb-rule-engine-to-rule-engine-notifications-" + this.serviceInfoProvider.getServiceId());
        requestBuilder.defaultTopic(this.ruleEngineSettings.getTopic());
        requestBuilder.admin(this.notificationAdmin);
        return requestBuilder.build();
    }

    @Override
    public TbQueueProducer<TbProtoQueueMsg<TransportProtos.ToCoreMsg>> createTbCoreMsgProducer() {
        TbKafkaProducerTemplate.TbKafkaProducerTemplateBuilder requestBuilder = TbKafkaProducerTemplate.builder();
        requestBuilder.settings(this.kafkaSettings);
        requestBuilder.clientId("tb-rule-engine-to-core-" + this.serviceInfoProvider.getServiceId());
        requestBuilder.defaultTopic(this.coreSettings.getTopic());
        requestBuilder.admin(this.coreAdmin);
        return requestBuilder.build();
    }

    @Override
    public TbQueueProducer<TbProtoQueueMsg<TransportProtos.ToOtaPackageStateServiceMsg>> createToOtaPackageStateServiceMsgProducer() {
        TbKafkaProducerTemplate.TbKafkaProducerTemplateBuilder requestBuilder = TbKafkaProducerTemplate.builder();
        requestBuilder.settings(this.kafkaSettings);
        requestBuilder.clientId("tb-rule-engine-ota-producer-" + this.serviceInfoProvider.getServiceId());
        requestBuilder.defaultTopic(this.coreSettings.getOtaPackageTopic());
        requestBuilder.admin(this.fwUpdatesAdmin);
        return requestBuilder.build();
    }

    @Override
    public TbQueueProducer<TbProtoQueueMsg<TransportProtos.ToCoreNotificationMsg>> createTbCoreNotificationsMsgProducer() {
        TbKafkaProducerTemplate.TbKafkaProducerTemplateBuilder requestBuilder = TbKafkaProducerTemplate.builder();
        requestBuilder.settings(this.kafkaSettings);
        requestBuilder.clientId("tb-rule-engine-to-core-notifications-" + this.serviceInfoProvider.getServiceId());
        requestBuilder.defaultTopic(this.coreSettings.getTopic());
        requestBuilder.admin(this.notificationAdmin);
        return requestBuilder.build();
    }

    @Override
    public TbQueueConsumer<TbProtoQueueMsg<TransportProtos.ToRuleEngineMsg>> createToRuleEngineMsgConsumer(Queue configuration) {
        String queueName = configuration.getName();
        TbKafkaConsumerTemplate.TbKafkaConsumerTemplateBuilder<TbProtoQueueMsg> consumerBuilder = TbKafkaConsumerTemplate.builder();
        consumerBuilder.settings(this.kafkaSettings);
        consumerBuilder.topic(configuration.getTopic());
        consumerBuilder.clientId("re-" + queueName + "-consumer-" + this.serviceInfoProvider.getServiceId() + "-" + this.consumerCount.incrementAndGet());
        consumerBuilder.groupId("re-" + queueName + "-consumer");
        consumerBuilder.decoder(msg -> new TbProtoQueueMsg<TransportProtos.ToRuleEngineMsg>(msg.getKey(), TransportProtos.ToRuleEngineMsg.parseFrom((byte[])msg.getData()), msg.getHeaders()));
        consumerBuilder.admin(this.ruleEngineAdmin);
        consumerBuilder.statsService(this.consumerStatsService);
        return consumerBuilder.build();
    }

    @Override
    public TbQueueConsumer<TbProtoQueueMsg<TransportProtos.ToRuleEngineNotificationMsg>> createToRuleEngineNotificationsMsgConsumer() {
        TbKafkaConsumerTemplate.TbKafkaConsumerTemplateBuilder<TbProtoQueueMsg> consumerBuilder = TbKafkaConsumerTemplate.builder();
        consumerBuilder.settings(this.kafkaSettings);
        consumerBuilder.topic(this.notificationsTopicService.getNotificationsTopic(ServiceType.TB_RULE_ENGINE, this.serviceInfoProvider.getServiceId()).getFullTopicName());
        consumerBuilder.clientId("tb-rule-engine-notifications-consumer-" + this.serviceInfoProvider.getServiceId());
        consumerBuilder.groupId("tb-rule-engine-notifications-node-" + this.serviceInfoProvider.getServiceId());
        consumerBuilder.decoder(msg -> new TbProtoQueueMsg<TransportProtos.ToRuleEngineNotificationMsg>(msg.getKey(), TransportProtos.ToRuleEngineNotificationMsg.parseFrom((byte[])msg.getData()), msg.getHeaders()));
        consumerBuilder.admin(this.notificationAdmin);
        consumerBuilder.statsService(this.consumerStatsService);
        return consumerBuilder.build();
    }

    @Override
    @Bean
    public TbQueueRequestTemplate<TbProtoJsQueueMsg<JsInvokeProtos.RemoteJsRequest>, TbProtoQueueMsg<JsInvokeProtos.RemoteJsResponse>> createRemoteJsRequestTemplate() {
        TbKafkaProducerTemplate.TbKafkaProducerTemplateBuilder requestBuilder = TbKafkaProducerTemplate.builder();
        requestBuilder.settings(this.kafkaSettings);
        requestBuilder.clientId("producer-js-invoke-" + this.serviceInfoProvider.getServiceId());
        requestBuilder.defaultTopic(this.jsInvokeSettings.getRequestTopic());
        requestBuilder.admin(this.jsExecutorRequestAdmin);
        TbKafkaConsumerTemplate.TbKafkaConsumerTemplateBuilder<TbProtoQueueMsg> responseBuilder = TbKafkaConsumerTemplate.builder();
        responseBuilder.settings(this.kafkaSettings);
        responseBuilder.topic(this.jsInvokeSettings.getResponseTopic() + "." + this.serviceInfoProvider.getServiceId());
        responseBuilder.clientId("js-" + this.serviceInfoProvider.getServiceId());
        responseBuilder.groupId("rule-engine-node-" + this.serviceInfoProvider.getServiceId());
        responseBuilder.decoder(msg -> {
            JsInvokeProtos.RemoteJsResponse.Builder builder = JsInvokeProtos.RemoteJsResponse.newBuilder();
            JsonFormat.parser().ignoringUnknownFields().merge(new String(msg.getData(), StandardCharsets.UTF_8), (Message.Builder)builder);
            return new TbProtoQueueMsg<JsInvokeProtos.RemoteJsResponse>(msg.getKey(), builder.build(), msg.getHeaders());
        });
        responseBuilder.admin(this.jsExecutorResponseAdmin);
        responseBuilder.statsService(this.consumerStatsService);
        DefaultTbQueueRequestTemplate.DefaultTbQueueRequestTemplateBuilder builder = DefaultTbQueueRequestTemplate.builder();
        builder.queueAdmin(this.jsExecutorResponseAdmin);
        builder.requestTemplate(requestBuilder.build());
        builder.responseTemplate(responseBuilder.build());
        builder.maxPendingRequests(this.jsInvokeSettings.getMaxPendingRequests());
        builder.maxRequestTimeout(this.jsInvokeSettings.getMaxRequestsTimeout());
        builder.pollInterval(this.jsInvokeSettings.getResponsePollInterval());
        return builder.build();
    }

    @Override
    public TbQueueProducer<TbProtoQueueMsg<TransportProtos.ToUsageStatsServiceMsg>> createToUsageStatsServiceMsgProducer() {
        TbKafkaProducerTemplate.TbKafkaProducerTemplateBuilder requestBuilder = TbKafkaProducerTemplate.builder();
        requestBuilder.settings(this.kafkaSettings);
        requestBuilder.clientId("tb-rule-engine-us-producer-" + this.serviceInfoProvider.getServiceId());
        requestBuilder.defaultTopic(this.coreSettings.getUsageStatsTopic());
        requestBuilder.admin(this.coreAdmin);
        return requestBuilder.build();
    }

    @PreDestroy
    private void destroy() {
        if (this.coreAdmin != null) {
            this.coreAdmin.destroy();
        }
        if (this.ruleEngineAdmin != null) {
            this.ruleEngineAdmin.destroy();
        }
        if (this.jsExecutorRequestAdmin != null) {
            this.jsExecutorRequestAdmin.destroy();
        }
        if (this.jsExecutorResponseAdmin != null) {
            this.jsExecutorResponseAdmin.destroy();
        }
        if (this.notificationAdmin != null) {
            this.notificationAdmin.destroy();
        }
        if (this.fwUpdatesAdmin != null) {
            this.fwUpdatesAdmin.destroy();
        }
    }
}

