/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.queue.provider;

import javax.annotation.PreDestroy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.stereotype.Component;
import org.thingsboard.server.gen.transport.TransportProtos;
import org.thingsboard.server.queue.TbQueueAdmin;
import org.thingsboard.server.queue.TbQueueConsumer;
import org.thingsboard.server.queue.TbQueueProducer;
import org.thingsboard.server.queue.TbQueueRequestTemplate;
import org.thingsboard.server.queue.common.DefaultTbQueueRequestTemplate;
import org.thingsboard.server.queue.common.TbProtoQueueMsg;
import org.thingsboard.server.queue.discovery.TbServiceInfoProvider;
import org.thingsboard.server.queue.provider.TbTransportQueueFactory;
import org.thingsboard.server.queue.settings.TbQueueCoreSettings;
import org.thingsboard.server.queue.settings.TbQueueRuleEngineSettings;
import org.thingsboard.server.queue.settings.TbQueueTransportApiSettings;
import org.thingsboard.server.queue.settings.TbQueueTransportNotificationSettings;
import org.thingsboard.server.queue.sqs.TbAwsSqsAdmin;
import org.thingsboard.server.queue.sqs.TbAwsSqsConsumerTemplate;
import org.thingsboard.server.queue.sqs.TbAwsSqsProducerTemplate;
import org.thingsboard.server.queue.sqs.TbAwsSqsQueueAttributes;
import org.thingsboard.server.queue.sqs.TbAwsSqsSettings;

@Component
@ConditionalOnExpression(value="'${queue.type:null}'=='aws-sqs' && (('${service.type:null}'=='monolith' && '${transport.api_enabled:true}'=='true') || '${service.type:null}'=='tb-transport')")
public class AwsSqsTransportQueueFactory
implements TbTransportQueueFactory {
    private static final Logger log = LoggerFactory.getLogger(AwsSqsTransportQueueFactory.class);
    private final TbQueueTransportApiSettings transportApiSettings;
    private final TbQueueTransportNotificationSettings transportNotificationSettings;
    private final TbAwsSqsSettings sqsSettings;
    private final TbQueueCoreSettings coreSettings;
    private final TbServiceInfoProvider serviceInfoProvider;
    private final TbQueueRuleEngineSettings ruleEngineSettings;
    private final TbQueueAdmin coreAdmin;
    private final TbQueueAdmin transportApiAdmin;
    private final TbQueueAdmin notificationAdmin;
    private final TbQueueAdmin ruleEngineAdmin;

    public AwsSqsTransportQueueFactory(TbQueueTransportApiSettings transportApiSettings, TbQueueTransportNotificationSettings transportNotificationSettings, TbAwsSqsSettings sqsSettings, TbServiceInfoProvider serviceInfoProvider, TbQueueCoreSettings coreSettings, TbAwsSqsQueueAttributes sqsQueueAttributes, TbQueueRuleEngineSettings ruleEngineSettings) {
        this.transportApiSettings = transportApiSettings;
        this.transportNotificationSettings = transportNotificationSettings;
        this.sqsSettings = sqsSettings;
        this.serviceInfoProvider = serviceInfoProvider;
        this.coreSettings = coreSettings;
        this.ruleEngineSettings = ruleEngineSettings;
        this.coreAdmin = new TbAwsSqsAdmin(sqsSettings, sqsQueueAttributes.getCoreAttributes());
        this.transportApiAdmin = new TbAwsSqsAdmin(sqsSettings, sqsQueueAttributes.getTransportApiAttributes());
        this.notificationAdmin = new TbAwsSqsAdmin(sqsSettings, sqsQueueAttributes.getNotificationsAttributes());
        this.ruleEngineAdmin = new TbAwsSqsAdmin(sqsSettings, sqsQueueAttributes.getRuleEngineAttributes());
    }

    @Override
    public TbQueueRequestTemplate<TbProtoQueueMsg<TransportProtos.TransportApiRequestMsg>, TbProtoQueueMsg<TransportProtos.TransportApiResponseMsg>> createTransportApiRequestTemplate() {
        TbAwsSqsProducerTemplate producerTemplate = new TbAwsSqsProducerTemplate(this.transportApiAdmin, this.sqsSettings, this.transportApiSettings.getRequestsTopic());
        TbAwsSqsConsumerTemplate consumerTemplate = new TbAwsSqsConsumerTemplate(this.transportApiAdmin, this.sqsSettings, this.transportApiSettings.getResponsesTopic() + "_" + this.serviceInfoProvider.getServiceId(), msg -> new TbProtoQueueMsg<TransportProtos.TransportApiResponseMsg>(msg.getKey(), TransportProtos.TransportApiResponseMsg.parseFrom((byte[])msg.getData()), msg.getHeaders()));
        DefaultTbQueueRequestTemplate.DefaultTbQueueRequestTemplateBuilder templateBuilder = DefaultTbQueueRequestTemplate.builder();
        templateBuilder.queueAdmin(this.transportApiAdmin);
        templateBuilder.requestTemplate(producerTemplate);
        templateBuilder.responseTemplate(consumerTemplate);
        templateBuilder.maxPendingRequests(this.transportApiSettings.getMaxPendingRequests());
        templateBuilder.maxRequestTimeout(this.transportApiSettings.getMaxRequestsTimeout());
        templateBuilder.pollInterval(this.transportApiSettings.getResponsePollInterval());
        return templateBuilder.build();
    }

    @Override
    public TbQueueProducer<TbProtoQueueMsg<TransportProtos.ToRuleEngineMsg>> createRuleEngineMsgProducer() {
        return new TbAwsSqsProducerTemplate<TbProtoQueueMsg<TransportProtos.ToRuleEngineMsg>>(this.ruleEngineAdmin, this.sqsSettings, this.ruleEngineSettings.getTopic());
    }

    @Override
    public TbQueueProducer<TbProtoQueueMsg<TransportProtos.ToCoreMsg>> createTbCoreMsgProducer() {
        return new TbAwsSqsProducerTemplate<TbProtoQueueMsg<TransportProtos.ToCoreMsg>>(this.coreAdmin, this.sqsSettings, this.coreSettings.getTopic());
    }

    @Override
    public TbQueueConsumer<TbProtoQueueMsg<TransportProtos.ToTransportMsg>> createTransportNotificationsConsumer() {
        return new TbAwsSqsConsumerTemplate<TbProtoQueueMsg<TransportProtos.ToTransportMsg>>(this.notificationAdmin, this.sqsSettings, this.transportNotificationSettings.getNotificationsTopic() + "_" + this.serviceInfoProvider.getServiceId(), msg -> new TbProtoQueueMsg<TransportProtos.ToTransportMsg>(msg.getKey(), TransportProtos.ToTransportMsg.parseFrom((byte[])msg.getData()), msg.getHeaders()));
    }

    @Override
    public TbQueueProducer<TbProtoQueueMsg<TransportProtos.ToUsageStatsServiceMsg>> createToUsageStatsServiceMsgProducer() {
        return new TbAwsSqsProducerTemplate<TbProtoQueueMsg<TransportProtos.ToUsageStatsServiceMsg>>(this.coreAdmin, this.sqsSettings, this.coreSettings.getUsageStatsTopic());
    }

    @PreDestroy
    private void destroy() {
        if (this.coreAdmin != null) {
            this.coreAdmin.destroy();
        }
        if (this.transportApiAdmin != null) {
            this.transportApiAdmin.destroy();
        }
        if (this.notificationAdmin != null) {
            this.notificationAdmin.destroy();
        }
        if (this.ruleEngineAdmin != null) {
            this.ruleEngineAdmin.destroy();
        }
    }
}

