/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.queue.kafka;

import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.header.internals.RecordHeader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.server.common.data.StringUtils;
import org.thingsboard.server.common.msg.queue.TopicPartitionInfo;
import org.thingsboard.server.queue.TbQueueAdmin;
import org.thingsboard.server.queue.TbQueueCallback;
import org.thingsboard.server.queue.TbQueueMsg;
import org.thingsboard.server.queue.TbQueueMsgMetadata;
import org.thingsboard.server.queue.TbQueueProducer;
import org.thingsboard.server.queue.kafka.KafkaTbQueueMsgMetadata;
import org.thingsboard.server.queue.kafka.TbKafkaSettings;

public class TbKafkaProducerTemplate<T extends TbQueueMsg>
implements TbQueueProducer<T> {
    private static final Logger log = LoggerFactory.getLogger(TbKafkaProducerTemplate.class);
    private final KafkaProducer<String, byte[]> producer;
    private final String defaultTopic;
    private final TbKafkaSettings settings;
    private final TbQueueAdmin admin;
    private final Set<TopicPartitionInfo> topics;

    private TbKafkaProducerTemplate(TbKafkaSettings settings, String defaultTopic, String clientId, TbQueueAdmin admin) {
        Properties props = settings.toProducerProps();
        if (!StringUtils.isEmpty((String)clientId)) {
            props.put("client.id", clientId);
        }
        this.settings = settings;
        this.producer = new KafkaProducer(props);
        this.defaultTopic = defaultTopic;
        this.admin = admin;
        this.topics = ConcurrentHashMap.newKeySet();
    }

    public void init() {
    }

    public void send(TopicPartitionInfo tpi, T msg, TbQueueCallback callback) {
        try {
            this.createTopicIfNotExist(tpi);
            String key = msg.getKey().toString();
            byte[] data = msg.getData();
            Iterable headers = msg.getHeaders().getData().entrySet().stream().map(e -> new RecordHeader((String)e.getKey(), (byte[])e.getValue())).collect(Collectors.toList());
            ProducerRecord record = new ProducerRecord(tpi.getFullTopicName(), null, (Object)key, (Object)data, headers);
            this.producer.send(record, (metadata, exception) -> {
                if (exception == null) {
                    if (callback != null) {
                        callback.onSuccess((TbQueueMsgMetadata)new KafkaTbQueueMsgMetadata(metadata));
                    }
                } else if (callback != null) {
                    callback.onFailure((Throwable)exception);
                } else {
                    log.warn("Producer template failure: {}", (Object)exception.getMessage(), (Object)exception);
                }
            });
        }
        catch (Exception e2) {
            if (callback != null) {
                callback.onFailure((Throwable)e2);
            } else {
                log.warn("Producer template failure (send method wrapper): {}", (Object)e2.getMessage(), (Object)e2);
            }
            throw e2;
        }
    }

    private void createTopicIfNotExist(TopicPartitionInfo tpi) {
        if (this.topics.contains(tpi)) {
            return;
        }
        this.admin.createTopicIfNotExists(tpi.getFullTopicName());
        this.topics.add(tpi);
    }

    public void stop() {
        if (this.producer != null) {
            this.producer.close();
        }
    }

    public static <T extends TbQueueMsg> TbKafkaProducerTemplateBuilder<T> builder() {
        return new TbKafkaProducerTemplateBuilder();
    }

    public String getDefaultTopic() {
        return this.defaultTopic;
    }

    public TbKafkaSettings getSettings() {
        return this.settings;
    }

    public static class TbKafkaProducerTemplateBuilder<T extends TbQueueMsg> {
        private TbKafkaSettings settings;
        private String defaultTopic;
        private String clientId;
        private TbQueueAdmin admin;

        TbKafkaProducerTemplateBuilder() {
        }

        public TbKafkaProducerTemplateBuilder<T> settings(TbKafkaSettings settings) {
            this.settings = settings;
            return this;
        }

        public TbKafkaProducerTemplateBuilder<T> defaultTopic(String defaultTopic) {
            this.defaultTopic = defaultTopic;
            return this;
        }

        public TbKafkaProducerTemplateBuilder<T> clientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        public TbKafkaProducerTemplateBuilder<T> admin(TbQueueAdmin admin) {
            this.admin = admin;
            return this;
        }

        public TbKafkaProducerTemplate<T> build() {
            return new TbKafkaProducerTemplate(this.settings, this.defaultTopic, this.clientId, this.admin);
        }

        public String toString() {
            return "TbKafkaProducerTemplate.TbKafkaProducerTemplateBuilder(settings=" + this.settings + ", defaultTopic=" + this.defaultTopic + ", clientId=" + this.clientId + ", admin=" + this.admin + ")";
        }
    }
}

