/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.queue.discovery;

import java.util.UUID;
import org.thingsboard.server.common.data.id.QueueId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.queue.Queue;
import org.thingsboard.server.gen.transport.TransportProtos;

public class QueueRoutingInfo {
    private final TenantId tenantId;
    private final QueueId queueId;
    private final String queueName;
    private final String queueTopic;
    private final int partitions;

    public QueueRoutingInfo(Queue queue) {
        this.tenantId = queue.getTenantId();
        this.queueId = (QueueId)queue.getId();
        this.queueName = queue.getName();
        this.queueTopic = queue.getTopic();
        this.partitions = queue.getPartitions();
    }

    public QueueRoutingInfo(TransportProtos.GetQueueRoutingInfoResponseMsg routingInfo) {
        this.tenantId = new TenantId(new UUID(routingInfo.getTenantIdMSB(), routingInfo.getTenantIdLSB()));
        this.queueId = new QueueId(new UUID(routingInfo.getQueueIdMSB(), routingInfo.getQueueIdLSB()));
        this.queueName = routingInfo.getQueueName();
        this.queueTopic = routingInfo.getQueueTopic();
        this.partitions = routingInfo.getPartitions();
    }

    public QueueRoutingInfo(TransportProtos.QueueUpdateMsg queueUpdateMsg) {
        this.tenantId = new TenantId(new UUID(queueUpdateMsg.getTenantIdMSB(), queueUpdateMsg.getTenantIdLSB()));
        this.queueId = new QueueId(new UUID(queueUpdateMsg.getQueueIdMSB(), queueUpdateMsg.getQueueIdLSB()));
        this.queueName = queueUpdateMsg.getQueueName();
        this.queueTopic = queueUpdateMsg.getQueueTopic();
        this.partitions = queueUpdateMsg.getPartitions();
    }

    public TenantId getTenantId() {
        return this.tenantId;
    }

    public QueueId getQueueId() {
        return this.queueId;
    }

    public String getQueueName() {
        return this.queueName;
    }

    public String getQueueTopic() {
        return this.queueTopic;
    }

    public int getPartitions() {
        return this.partitions;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof QueueRoutingInfo)) {
            return false;
        }
        QueueRoutingInfo other = (QueueRoutingInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getPartitions() != other.getPartitions()) {
            return false;
        }
        TenantId this$tenantId = this.getTenantId();
        TenantId other$tenantId = other.getTenantId();
        if (this$tenantId == null ? other$tenantId != null : !this$tenantId.equals(other$tenantId)) {
            return false;
        }
        QueueId this$queueId = this.getQueueId();
        QueueId other$queueId = other.getQueueId();
        if (this$queueId == null ? other$queueId != null : !this$queueId.equals(other$queueId)) {
            return false;
        }
        String this$queueName = this.getQueueName();
        String other$queueName = other.getQueueName();
        if (this$queueName == null ? other$queueName != null : !this$queueName.equals(other$queueName)) {
            return false;
        }
        String this$queueTopic = this.getQueueTopic();
        String other$queueTopic = other.getQueueTopic();
        return !(this$queueTopic == null ? other$queueTopic != null : !this$queueTopic.equals(other$queueTopic));
    }

    protected boolean canEqual(Object other) {
        return other instanceof QueueRoutingInfo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getPartitions();
        TenantId $tenantId = this.getTenantId();
        result = result * 59 + ($tenantId == null ? 43 : $tenantId.hashCode());
        QueueId $queueId = this.getQueueId();
        result = result * 59 + ($queueId == null ? 43 : $queueId.hashCode());
        String $queueName = this.getQueueName();
        result = result * 59 + ($queueName == null ? 43 : $queueName.hashCode());
        String $queueTopic = this.getQueueTopic();
        result = result * 59 + ($queueTopic == null ? 43 : $queueTopic.hashCode());
        return result;
    }

    public String toString() {
        return "QueueRoutingInfo(tenantId=" + this.getTenantId() + ", queueId=" + this.getQueueId() + ", queueName=" + this.getQueueName() + ", queueTopic=" + this.getQueueTopic() + ", partitions=" + this.getPartitions() + ")";
    }
}

