/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.queue.discovery;

import java.util.Collections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.annotation.DependsOn;
import org.springframework.stereotype.Service;
import org.thingsboard.server.queue.discovery.DiscoveryService;
import org.thingsboard.server.queue.discovery.PartitionService;
import org.thingsboard.server.queue.discovery.TbServiceInfoProvider;
import org.thingsboard.server.queue.util.AfterStartUp;

@Service
@ConditionalOnProperty(prefix="zk", value={"enabled"}, havingValue="false", matchIfMissing=true)
@DependsOn(value={"environmentLogService"})
public class DummyDiscoveryService
implements DiscoveryService {
    private static final Logger log = LoggerFactory.getLogger(DummyDiscoveryService.class);
    private final TbServiceInfoProvider serviceInfoProvider;
    private final PartitionService partitionService;

    public DummyDiscoveryService(TbServiceInfoProvider serviceInfoProvider, PartitionService partitionService) {
        this.serviceInfoProvider = serviceInfoProvider;
        this.partitionService = partitionService;
    }

    @AfterStartUp(order=2)
    public void onApplicationEvent(ApplicationReadyEvent event) {
        this.partitionService.recalculatePartitions(this.serviceInfoProvider.getServiceInfo(), Collections.emptyList());
    }
}

