/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.queue.discovery;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;
import org.thingsboard.server.common.data.StringUtils;
import org.thingsboard.server.common.data.TbTransportService;
import org.thingsboard.server.common.msg.queue.ServiceType;
import org.thingsboard.server.gen.transport.TransportProtos;
import org.thingsboard.server.queue.discovery.TbServiceInfoProvider;
import org.thingsboard.server.queue.util.AfterContextReady;

@Component
public class DefaultTbServiceInfoProvider
implements TbServiceInfoProvider {
    private static final Logger log = LoggerFactory.getLogger(DefaultTbServiceInfoProvider.class);
    @Value(value="${service.id:#{null}}")
    private String serviceId;
    @Value(value="${service.type:monolith}")
    private String serviceType;
    @Autowired
    private ApplicationContext applicationContext;
    private List<ServiceType> serviceTypes;
    private TransportProtos.ServiceInfo serviceInfo;

    @PostConstruct
    public void init() {
        if (StringUtils.isEmpty((String)this.serviceId)) {
            try {
                this.serviceId = InetAddress.getLocalHost().getHostName();
            }
            catch (UnknownHostException e) {
                this.serviceId = StringUtils.randomAlphabetic((int)10);
            }
        }
        log.info("Current Service ID: {}", (Object)this.serviceId);
        this.serviceTypes = this.serviceType.equalsIgnoreCase("monolith") ? Collections.unmodifiableList(Arrays.asList(ServiceType.values())) : Collections.singletonList(ServiceType.of((String)this.serviceType));
        TransportProtos.ServiceInfo.Builder builder = TransportProtos.ServiceInfo.newBuilder().setServiceId(this.serviceId).addAllServiceTypes((Iterable)this.serviceTypes.stream().map(Enum::name).collect(Collectors.toList()));
        this.serviceInfo = builder.build();
    }

    @AfterContextReady
    public void setTransports() {
        this.serviceInfo = TransportProtos.ServiceInfo.newBuilder((TransportProtos.ServiceInfo)this.serviceInfo).addAllTransports((Iterable)this.getTransportServices().stream().map(TbTransportService::getName).collect(Collectors.toSet())).build();
    }

    private Collection<TbTransportService> getTransportServices() {
        return this.applicationContext.getBeansOfType(TbTransportService.class).values();
    }

    @Override
    public TransportProtos.ServiceInfo getServiceInfo() {
        return this.serviceInfo;
    }

    @Override
    public boolean isService(ServiceType serviceType) {
        return this.serviceTypes.contains(serviceType);
    }

    @Override
    public String getServiceId() {
        return this.serviceId;
    }

    @Override
    public String getServiceType() {
        return this.serviceType;
    }
}

