/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.queue.azure.servicebus;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.stereotype.Component;
import org.thingsboard.server.common.data.StringUtils;

@Component
@ConditionalOnExpression(value="'${queue.type:null}'=='service-bus'")
public class TbServiceBusQueueConfigs {
    @Value(value="${queue.service-bus.queue-properties.core:}")
    private String coreProperties;
    @Value(value="${queue.service-bus.queue-properties.rule-engine:}")
    private String ruleEngineProperties;
    @Value(value="${queue.service-bus.queue-properties.transport-api:}")
    private String transportApiProperties;
    @Value(value="${queue.service-bus.queue-properties.notifications:}")
    private String notificationsProperties;
    @Value(value="${queue.service-bus.queue-properties.js-executor:}")
    private String jsExecutorProperties;
    @Value(value="${queue.service-bus.queue-properties.version-control:}")
    private String vcProperties;
    private Map<String, String> coreConfigs;
    private Map<String, String> ruleEngineConfigs;
    private Map<String, String> transportApiConfigs;
    private Map<String, String> notificationsConfigs;
    private Map<String, String> jsExecutorConfigs;
    private Map<String, String> vcConfigs;

    @PostConstruct
    private void init() {
        this.coreConfigs = this.getConfigs(this.coreProperties);
        this.ruleEngineConfigs = this.getConfigs(this.ruleEngineProperties);
        this.transportApiConfigs = this.getConfigs(this.transportApiProperties);
        this.notificationsConfigs = this.getConfigs(this.notificationsProperties);
        this.jsExecutorConfigs = this.getConfigs(this.jsExecutorProperties);
        this.vcConfigs = this.getConfigs(this.vcProperties);
    }

    private Map<String, String> getConfigs(String properties) {
        HashMap<String, String> configs = new HashMap<String, String>();
        if (StringUtils.isNotEmpty((String)properties)) {
            for (String property : properties.split(";")) {
                int delimiterPosition = property.indexOf(":");
                String key = property.substring(0, delimiterPosition);
                String value = property.substring(delimiterPosition + 1);
                configs.put(key, value);
            }
        }
        return configs;
    }

    public Map<String, String> getCoreConfigs() {
        return this.coreConfigs;
    }

    public Map<String, String> getRuleEngineConfigs() {
        return this.ruleEngineConfigs;
    }

    public Map<String, String> getTransportApiConfigs() {
        return this.transportApiConfigs;
    }

    public Map<String, String> getNotificationsConfigs() {
        return this.notificationsConfigs;
    }

    public Map<String, String> getJsExecutorConfigs() {
        return this.jsExecutorConfigs;
    }

    public Map<String, String> getVcConfigs() {
        return this.vcConfigs;
    }
}

