/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.queue.azure.servicebus;

import com.google.gson.Gson;
import com.microsoft.azure.servicebus.IMessage;
import com.microsoft.azure.servicebus.Message;
import com.microsoft.azure.servicebus.QueueClient;
import com.microsoft.azure.servicebus.ReceiveMode;
import com.microsoft.azure.servicebus.primitives.ConnectionStringBuilder;
import com.microsoft.azure.servicebus.primitives.ServiceBusException;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.server.common.msg.queue.TopicPartitionInfo;
import org.thingsboard.server.queue.TbQueueAdmin;
import org.thingsboard.server.queue.TbQueueCallback;
import org.thingsboard.server.queue.TbQueueMsg;
import org.thingsboard.server.queue.TbQueueProducer;
import org.thingsboard.server.queue.azure.servicebus.TbServiceBusSettings;
import org.thingsboard.server.queue.common.DefaultTbQueueMsg;

public class TbServiceBusProducerTemplate<T extends TbQueueMsg>
implements TbQueueProducer<T> {
    private static final Logger log = LoggerFactory.getLogger(TbServiceBusProducerTemplate.class);
    private final String defaultTopic;
    private final Gson gson = new Gson();
    private final TbQueueAdmin admin;
    private final TbServiceBusSettings serviceBusSettings;
    private final Map<String, QueueClient> clients = new ConcurrentHashMap<String, QueueClient>();
    private final ExecutorService executorService;

    public TbServiceBusProducerTemplate(TbQueueAdmin admin, TbServiceBusSettings serviceBusSettings, String defaultTopic) {
        this.admin = admin;
        this.defaultTopic = defaultTopic;
        this.serviceBusSettings = serviceBusSettings;
        this.executorService = Executors.newCachedThreadPool();
    }

    public void init() {
    }

    public String getDefaultTopic() {
        return this.defaultTopic;
    }

    public void send(TopicPartitionInfo tpi, T msg, TbQueueCallback callback) {
        Message message = new Message(this.gson.toJson((Object)new DefaultTbQueueMsg((TbQueueMsg)msg)));
        CompletableFuture future = this.getClient(tpi.getFullTopicName()).sendAsync((IMessage)message);
        future.whenCompleteAsync((success, err) -> {
            if (err != null) {
                callback.onFailure(err);
            } else {
                callback.onSuccess(null);
            }
        }, (Executor)this.executorService);
    }

    public void stop() {
        this.clients.forEach((t, client) -> {
            try {
                client.close();
            }
            catch (ServiceBusException e) {
                log.error("Failed to close QueueClient.", (Throwable)e);
            }
        });
        if (this.executorService != null) {
            this.executorService.shutdownNow();
        }
    }

    private QueueClient getClient(String topic) {
        return this.clients.computeIfAbsent(topic, k -> {
            this.admin.createTopicIfNotExists(topic);
            ConnectionStringBuilder builder = new ConnectionStringBuilder(this.serviceBusSettings.getNamespaceName(), topic, this.serviceBusSettings.getSasKeyName(), this.serviceBusSettings.getSasKey());
            try {
                return new QueueClient(builder, ReceiveMode.PEEKLOCK);
            }
            catch (ServiceBusException | InterruptedException e) {
                log.error("Failed to create new client for the Queue: [{}]", (Object)topic, (Object)e);
                throw new RuntimeException("Failed to create new client for the Queue", e);
            }
        });
    }
}

