/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.queue.azure.servicebus;

import com.microsoft.azure.servicebus.management.ManagementClient;
import com.microsoft.azure.servicebus.management.QueueDescription;
import com.microsoft.azure.servicebus.primitives.ConnectionStringBuilder;
import com.microsoft.azure.servicebus.primitives.MessagingEntityAlreadyExistsException;
import com.microsoft.azure.servicebus.primitives.ServiceBusException;
import java.io.IOException;
import java.time.Duration;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.server.queue.TbQueueAdmin;
import org.thingsboard.server.queue.azure.servicebus.TbServiceBusSettings;

public class TbServiceBusAdmin
implements TbQueueAdmin {
    private static final Logger log = LoggerFactory.getLogger(TbServiceBusAdmin.class);
    private final String MAX_SIZE = "maxSizeInMb";
    private final String MESSAGE_TIME_TO_LIVE = "messageTimeToLiveInSec";
    private final String LOCK_DURATION = "lockDurationInSec";
    private final Map<String, String> queueConfigs;
    private final Set<String> queues = ConcurrentHashMap.newKeySet();
    private final ManagementClient client;

    public TbServiceBusAdmin(TbServiceBusSettings serviceBusSettings, Map<String, String> queueConfigs) {
        this.queueConfigs = queueConfigs;
        ConnectionStringBuilder builder = new ConnectionStringBuilder(serviceBusSettings.getNamespaceName(), "queues", serviceBusSettings.getSasKeyName(), serviceBusSettings.getSasKey());
        this.client = new ManagementClient(builder);
        try {
            this.client.getQueues().forEach(queueDescription -> this.queues.add(queueDescription.getPath()));
        }
        catch (ServiceBusException | InterruptedException e) {
            log.error("Failed to get queues.", e);
            throw new RuntimeException("Failed to get queues.", e);
        }
    }

    public void createTopicIfNotExists(String topic) {
        if (this.queues.contains(topic)) {
            return;
        }
        try {
            QueueDescription queueDescription = new QueueDescription(topic);
            queueDescription.setRequiresDuplicateDetection(false);
            this.setQueueConfigs(queueDescription);
            this.client.createQueue(queueDescription);
            this.queues.add(topic);
        }
        catch (ServiceBusException | InterruptedException e) {
            if (e instanceof MessagingEntityAlreadyExistsException) {
                this.queues.add(topic);
                log.info("[{}] queue already exists.", (Object)topic);
            }
            log.error("Failed to create queue: [{}]", (Object)topic, (Object)e);
        }
    }

    public void deleteTopic(String topic) {
        if (this.queues.contains(topic)) {
            this.doDelete(topic);
        } else {
            try {
                if (this.client.getQueue(topic) != null) {
                    this.doDelete(topic);
                } else {
                    log.warn("Azure Service Bus Queue [{}] is not exist.", (Object)topic);
                }
            }
            catch (ServiceBusException | InterruptedException e) {
                log.error("Failed to delete Azure Service Bus queue [{}]", (Object)topic, (Object)e);
            }
        }
    }

    private void doDelete(String topic) {
        try {
            this.client.deleteTopic(topic);
        }
        catch (ServiceBusException | InterruptedException e) {
            log.error("Failed to delete Azure Service Bus queue [{}]", (Object)topic, (Object)e);
        }
    }

    private void setQueueConfigs(QueueDescription queueDescription) {
        this.queueConfigs.forEach((confKey, confValue) -> {
            switch (confKey) {
                case "maxSizeInMb": {
                    queueDescription.setMaxSizeInMB(Long.parseLong(confValue));
                    break;
                }
                case "messageTimeToLiveInSec": {
                    queueDescription.setDefaultMessageTimeToLive(Duration.ofSeconds(Long.parseLong(confValue)));
                    break;
                }
                case "lockDurationInSec": {
                    queueDescription.setLockDuration(Duration.ofSeconds(Long.parseLong(confValue)));
                    break;
                }
                default: {
                    log.error("Unknown config: [{}]", confKey);
                }
            }
        });
    }

    public void destroy() {
        try {
            this.client.close();
        }
        catch (IOException e) {
            log.error("Failed to close ManagementClient.");
        }
    }
}

