/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.queue;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.thingsboard.server.queue.TbQueueAdmin;
import org.thingsboard.server.queue.azure.servicebus.TbServiceBusAdmin;
import org.thingsboard.server.queue.azure.servicebus.TbServiceBusQueueConfigs;
import org.thingsboard.server.queue.azure.servicebus.TbServiceBusSettings;
import org.thingsboard.server.queue.kafka.TbKafkaAdmin;
import org.thingsboard.server.queue.kafka.TbKafkaSettings;
import org.thingsboard.server.queue.kafka.TbKafkaTopicConfigs;
import org.thingsboard.server.queue.pubsub.TbPubSubAdmin;
import org.thingsboard.server.queue.pubsub.TbPubSubSettings;
import org.thingsboard.server.queue.pubsub.TbPubSubSubscriptionSettings;
import org.thingsboard.server.queue.rabbitmq.TbRabbitMqAdmin;
import org.thingsboard.server.queue.rabbitmq.TbRabbitMqQueueArguments;
import org.thingsboard.server.queue.rabbitmq.TbRabbitMqSettings;
import org.thingsboard.server.queue.sqs.TbAwsSqsAdmin;
import org.thingsboard.server.queue.sqs.TbAwsSqsQueueAttributes;
import org.thingsboard.server.queue.sqs.TbAwsSqsSettings;

@Configuration
public class RuleEngineTbQueueAdminFactory {
    @Autowired(required=false)
    private TbKafkaTopicConfigs kafkaTopicConfigs;
    @Autowired(required=false)
    private TbKafkaSettings kafkaSettings;
    @Autowired(required=false)
    private TbAwsSqsQueueAttributes awsSqsQueueAttributes;
    @Autowired(required=false)
    private TbAwsSqsSettings awsSqsSettings;
    @Autowired(required=false)
    private TbPubSubSubscriptionSettings pubSubSubscriptionSettings;
    @Autowired(required=false)
    private TbPubSubSettings pubSubSettings;
    @Autowired(required=false)
    private TbRabbitMqQueueArguments rabbitMqQueueArguments;
    @Autowired(required=false)
    private TbRabbitMqSettings rabbitMqSettings;
    @Autowired(required=false)
    private TbServiceBusQueueConfigs serviceBusQueueConfigs;
    @Autowired(required=false)
    private TbServiceBusSettings serviceBusSettings;

    @ConditionalOnExpression(value="'${queue.type:null}'=='kafka'")
    @Bean
    public TbQueueAdmin createKafkaAdmin() {
        return new TbKafkaAdmin(this.kafkaSettings, this.kafkaTopicConfigs.getRuleEngineConfigs());
    }

    @ConditionalOnExpression(value="'${queue.type:null}'=='aws-sqs'")
    @Bean
    public TbQueueAdmin createAwsSqsAdmin() {
        return new TbAwsSqsAdmin(this.awsSqsSettings, this.awsSqsQueueAttributes.getRuleEngineAttributes());
    }

    @ConditionalOnExpression(value="'${queue.type:null}'=='pubsub'")
    @Bean
    public TbQueueAdmin createPubSubAdmin() {
        return new TbPubSubAdmin(this.pubSubSettings, this.pubSubSubscriptionSettings.getRuleEngineSettings());
    }

    @ConditionalOnExpression(value="'${queue.type:null}'=='rabbitmq'")
    @Bean
    public TbQueueAdmin createRabbitMqAdmin() {
        return new TbRabbitMqAdmin(this.rabbitMqSettings, this.rabbitMqQueueArguments.getRuleEngineArgs());
    }

    @ConditionalOnExpression(value="'${queue.type:null}'=='service-bus'")
    @Bean
    public TbQueueAdmin createServiceBusAdmin() {
        return new TbServiceBusAdmin(this.serviceBusSettings, this.serviceBusQueueConfigs.getRuleEngineConfigs());
    }

    @ConditionalOnExpression(value="'${queue.type:null}'=='in-memory'")
    @Bean
    public TbQueueAdmin createInMemoryAdmin() {
        return new TbQueueAdmin(){

            public void createTopicIfNotExists(String topic) {
            }

            public void deleteTopic(String topic) {
            }

            public void destroy() {
            }
        };
    }
}

