/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.kafka;

import java.net.InetAddress;
import java.net.UnknownHostException;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.RandomStringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class TbNodeIdProvider {
    private static final Logger log = LoggerFactory.getLogger(TbNodeIdProvider.class);
    @Value(value="${cluster.node_id:#{null}}")
    private String nodeId;

    @PostConstruct
    public void init() {
        if (StringUtils.isEmpty((Object)this.nodeId)) {
            try {
                this.nodeId = InetAddress.getLocalHost().getHostName();
            }
            catch (UnknownHostException e) {
                this.nodeId = RandomStringUtils.randomAlphabetic((int)10);
            }
        }
        log.info("Current NodeId: {}", (Object)this.nodeId);
    }

    public String getNodeId() {
        return this.nodeId;
    }
}

