/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.kafka;

import java.util.List;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;
import org.thingsboard.server.kafka.TbKafkaProperty;

@ConditionalOnProperty(prefix="kafka", value={"enabled"}, havingValue="true", matchIfMissing=false)
@Component
public class TbKafkaSettings {
    private static final Logger log = LoggerFactory.getLogger(TbKafkaSettings.class);
    static final String REQUEST_ID_HEADER = "requestId";
    static final String RESPONSE_TOPIC_HEADER = "responseTopic";
    @Value(value="${kafka.bootstrap.servers}")
    private String servers;
    @Value(value="${kafka.acks}")
    private String acks;
    @Value(value="${kafka.retries}")
    private int retries;
    @Value(value="${kafka.batch.size}")
    private int batchSize;
    @Value(value="${kafka.linger.ms}")
    private long lingerMs;
    @Value(value="${kafka.buffer.memory}")
    private long bufferMemory;
    @Value(value="${kafka.other:#{null}}")
    private List<TbKafkaProperty> other;

    public Properties toProps() {
        Properties props = new Properties();
        props.put("bootstrap.servers", this.servers);
        props.put("acks", this.acks);
        props.put("retries", (Object)this.retries);
        props.put("batch.size", (Object)this.batchSize);
        props.put("linger.ms", (Object)this.lingerMs);
        props.put("buffer.memory", (Object)this.bufferMemory);
        if (this.other != null) {
            this.other.forEach(kv -> props.put(kv.getKey(), kv.getValue()));
        }
        return props;
    }
}

