/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.kafka;

import java.io.IOException;
import java.time.Duration;
import java.util.Collections;
import java.util.Properties;
import java.util.UUID;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.thingsboard.server.kafka.TbKafkaDecoder;
import org.thingsboard.server.kafka.TbKafkaRequestIdExtractor;
import org.thingsboard.server.kafka.TbKafkaSettings;

public class TBKafkaConsumerTemplate<T> {
    private final KafkaConsumer<String, byte[]> consumer;
    private final TbKafkaDecoder<T> decoder;
    private TbKafkaRequestIdExtractor<T> requestIdExtractor = response -> null;
    private final String topic;

    private TBKafkaConsumerTemplate(TbKafkaSettings settings, TbKafkaDecoder<T> decoder, TbKafkaRequestIdExtractor<T> requestIdExtractor, String clientId, String groupId, String topic, boolean autoCommit, int autoCommitIntervalMs, int maxPollRecords) {
        Properties props = settings.toProps();
        props.put("client.id", clientId);
        if (groupId != null) {
            props.put("group.id", groupId);
        }
        props.put("enable.auto.commit", (Object)autoCommit);
        props.put("auto.commit.interval.ms", (Object)autoCommitIntervalMs);
        props.put("key.deserializer", "org.apache.kafka.common.serialization.StringDeserializer");
        props.put("value.deserializer", "org.apache.kafka.common.serialization.ByteArrayDeserializer");
        if (maxPollRecords > 0) {
            props.put("max.poll.records", (Object)maxPollRecords);
        }
        this.consumer = new KafkaConsumer(props);
        this.decoder = decoder;
        this.requestIdExtractor = requestIdExtractor;
        this.topic = topic;
    }

    public void subscribe() {
        this.consumer.subscribe(Collections.singletonList(this.topic));
    }

    public void unsubscribe() {
        this.consumer.unsubscribe();
    }

    public ConsumerRecords<String, byte[]> poll(Duration duration) {
        return this.consumer.poll(duration);
    }

    public T decode(ConsumerRecord<String, byte[]> record) throws IOException {
        return this.decoder.decode((byte[])record.value());
    }

    public UUID extractRequestId(T value) {
        return this.requestIdExtractor.extractRequestId(value);
    }

    public static <T> TBKafkaConsumerTemplateBuilder<T> builder() {
        return new TBKafkaConsumerTemplateBuilder();
    }

    public String getTopic() {
        return this.topic;
    }

    public static class TBKafkaConsumerTemplateBuilder<T> {
        private TbKafkaSettings settings;
        private TbKafkaDecoder<T> decoder;
        private TbKafkaRequestIdExtractor<T> requestIdExtractor;
        private String clientId;
        private String groupId;
        private String topic;
        private boolean autoCommit;
        private int autoCommitIntervalMs;
        private int maxPollRecords;

        TBKafkaConsumerTemplateBuilder() {
        }

        public TBKafkaConsumerTemplateBuilder<T> settings(TbKafkaSettings settings) {
            this.settings = settings;
            return this;
        }

        public TBKafkaConsumerTemplateBuilder<T> decoder(TbKafkaDecoder<T> decoder) {
            this.decoder = decoder;
            return this;
        }

        public TBKafkaConsumerTemplateBuilder<T> requestIdExtractor(TbKafkaRequestIdExtractor<T> requestIdExtractor) {
            this.requestIdExtractor = requestIdExtractor;
            return this;
        }

        public TBKafkaConsumerTemplateBuilder<T> clientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        public TBKafkaConsumerTemplateBuilder<T> groupId(String groupId) {
            this.groupId = groupId;
            return this;
        }

        public TBKafkaConsumerTemplateBuilder<T> topic(String topic) {
            this.topic = topic;
            return this;
        }

        public TBKafkaConsumerTemplateBuilder<T> autoCommit(boolean autoCommit) {
            this.autoCommit = autoCommit;
            return this;
        }

        public TBKafkaConsumerTemplateBuilder<T> autoCommitIntervalMs(int autoCommitIntervalMs) {
            this.autoCommitIntervalMs = autoCommitIntervalMs;
            return this;
        }

        public TBKafkaConsumerTemplateBuilder<T> maxPollRecords(int maxPollRecords) {
            this.maxPollRecords = maxPollRecords;
            return this;
        }

        public TBKafkaConsumerTemplate<T> build() {
            return new TBKafkaConsumerTemplate(this.settings, this.decoder, this.requestIdExtractor, this.clientId, this.groupId, this.topic, this.autoCommit, this.autoCommitIntervalMs, this.maxPollRecords);
        }

        public String toString() {
            return "TBKafkaConsumerTemplate.TBKafkaConsumerTemplateBuilder(settings=" + this.settings + ", decoder=" + this.decoder + ", requestIdExtractor=" + this.requestIdExtractor + ", clientId=" + this.clientId + ", groupId=" + this.groupId + ", topic=" + this.topic + ", autoCommit=" + this.autoCommit + ", autoCommitIntervalMs=" + this.autoCommitIntervalMs + ", maxPollRecords=" + this.maxPollRecords + ")";
        }
    }
}

