/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.kafka;

import java.util.Collections;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.CreateTopicsResult;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.common.KafkaFuture;
import org.thingsboard.server.kafka.TbKafkaSettings;

public class TBKafkaAdmin {
    AdminClient client;

    public TBKafkaAdmin(TbKafkaSettings settings) {
        this.client = AdminClient.create((Properties)settings.toProps());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForTopic(String topic, long timeout, TimeUnit timeoutUnit) throws InterruptedException, TimeoutException {
        TBKafkaAdmin tBKafkaAdmin = this;
        synchronized (tBKafkaAdmin) {
            long timeoutExpiredMs = System.currentTimeMillis() + timeoutUnit.toMillis(timeout);
            while (!this.topicExists(topic)) {
                long waitMs = timeoutExpiredMs - System.currentTimeMillis();
                if (waitMs <= 0L) {
                    throw new TimeoutException("Timeout occurred while waiting for topic [" + topic + "] to be available!");
                }
                this.wait(1000L);
            }
        }
    }

    public CreateTopicsResult createTopic(NewTopic topic) {
        return this.client.createTopics(Collections.singletonList(topic));
    }

    private boolean topicExists(String topic) throws InterruptedException {
        KafkaFuture topicDescriptionFuture = (KafkaFuture)this.client.describeTopics(Collections.singleton(topic)).values().get(topic);
        try {
            topicDescriptionFuture.get();
            return true;
        }
        catch (ExecutionException e) {
            return false;
        }
    }
}

