/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.adaptor;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Consumer;
import org.apache.commons.lang3.math.NumberUtils;
import org.thingsboard.server.common.data.StringUtils;
import org.thingsboard.server.common.data.id.DeviceId;
import org.thingsboard.server.common.data.kv.AttributeKvEntry;
import org.thingsboard.server.common.data.kv.BaseAttributeKvEntry;
import org.thingsboard.server.common.data.kv.BooleanDataEntry;
import org.thingsboard.server.common.data.kv.DoubleDataEntry;
import org.thingsboard.server.common.data.kv.JsonDataEntry;
import org.thingsboard.server.common.data.kv.KvEntry;
import org.thingsboard.server.common.data.kv.LongDataEntry;
import org.thingsboard.server.common.data.kv.StringDataEntry;
import org.thingsboard.server.common.data.util.TbPair;
import org.thingsboard.server.common.msg.gateway.metrics.GatewayMetadata;
import org.thingsboard.server.gen.transport.TransportProtos;

public class JsonConverter {
    private static final Gson GSON = new Gson();
    private static final String CAN_T_PARSE_VALUE = "Can't parse value: ";
    private static final String DEVICE_PROPERTY = "device";
    private static boolean isTypeCastEnabled = true;
    private static int maxStringValueLength = 0;

    public static TransportProtos.PostTelemetryMsg convertToTelemetryProto(JsonElement jsonElement, long ts) throws JsonSyntaxException {
        TransportProtos.PostTelemetryMsg.Builder builder = TransportProtos.PostTelemetryMsg.newBuilder();
        JsonConverter.convertToTelemetry(jsonElement, ts, null, builder);
        return builder.build();
    }

    public static TransportProtos.PostTelemetryMsg convertToTelemetryProto(JsonElement jsonElement) throws JsonSyntaxException {
        return JsonConverter.convertToTelemetryProto(jsonElement, System.currentTimeMillis());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static TbPair<TransportProtos.PostTelemetryMsg, List<GatewayMetadata>> convertToGatewayTelemetry(JsonElement jsonElement, long systemTs) {
        ArrayList<GatewayMetadata> metadataResult = null;
        TransportProtos.PostTelemetryMsg.Builder builder = TransportProtos.PostTelemetryMsg.newBuilder();
        if (!jsonElement.isJsonArray()) throw new JsonSyntaxException(CAN_T_PARSE_VALUE + String.valueOf(jsonElement));
        JsonArray ja = jsonElement.getAsJsonArray();
        for (int i = 0; i < ja.size(); ++i) {
            JsonElement je = ja.get(i);
            if (!je.isJsonObject()) throw new JsonSyntaxException(CAN_T_PARSE_VALUE + String.valueOf(je));
            JsonObject jo = je.getAsJsonObject();
            JsonElement metadataElem = jo.remove("metadata");
            if (metadataElem != null) {
                if (metadataResult == null) {
                    metadataResult = new ArrayList<GatewayMetadata>();
                }
                if (!metadataElem.isJsonObject()) throw new JsonSyntaxException("Can't parse gateway metadata: " + String.valueOf(metadataElem));
                JsonObject metadataObj = metadataElem.getAsJsonObject();
                String connector = JsonConverter.getAndValidateMetadataElement(metadataObj, "connector").getAsString();
                long receivedTs = JsonConverter.getAndValidateMetadataElement(metadataObj, "receivedTs").getAsLong();
                long publishedTs = JsonConverter.getAndValidateMetadataElement(metadataObj, "publishedTs").getAsLong();
                metadataResult.add(new GatewayMetadata(connector, receivedTs, publishedTs));
            }
            JsonConverter.parseObject(systemTs, null, builder, jo);
        }
        return TbPair.of((Object)builder.build(), metadataResult);
    }

    private static JsonElement getAndValidateMetadataElement(JsonObject metadata, String elementName) {
        JsonElement element = metadata.get(elementName);
        if (element == null || element.isJsonNull()) {
            throw new JsonSyntaxException(String.format("Can't parse gateway element in metadata: [%s][%s]", metadata, elementName));
        }
        return element;
    }

    private static void convertToTelemetry(JsonElement jsonElement, long systemTs, Map<Long, List<KvEntry>> result, TransportProtos.PostTelemetryMsg.Builder builder) {
        if (jsonElement.isJsonObject()) {
            JsonConverter.parseObject(systemTs, result, builder, jsonElement.getAsJsonObject());
        } else if (jsonElement.isJsonArray()) {
            jsonElement.getAsJsonArray().forEach(je -> {
                if (!je.isJsonObject()) {
                    throw new JsonSyntaxException(CAN_T_PARSE_VALUE + String.valueOf(je));
                }
                JsonConverter.parseObject(systemTs, result, builder, je.getAsJsonObject());
            });
        } else {
            throw new JsonSyntaxException(CAN_T_PARSE_VALUE + String.valueOf(jsonElement));
        }
    }

    private static void parseObject(long systemTs, Map<Long, List<KvEntry>> result, TransportProtos.PostTelemetryMsg.Builder builder, JsonObject jo) {
        try {
            if (result != null) {
                JsonConverter.parseObject(result, systemTs, jo);
            } else {
                JsonConverter.parseObject(builder, systemTs, jo);
            }
        }
        catch (Exception e) {
            throw new JsonSyntaxException(CAN_T_PARSE_VALUE + String.valueOf(jo));
        }
    }

    public static TransportProtos.ClaimDeviceMsg convertToClaimDeviceProto(DeviceId deviceId, String json) {
        long durationMs = 0L;
        if (json != null && !json.isEmpty()) {
            return JsonConverter.convertToClaimDeviceProto(deviceId, JsonParser.parseString((String)json));
        }
        return JsonConverter.buildClaimDeviceMsg(deviceId, "", durationMs);
    }

    public static TransportProtos.ClaimDeviceMsg convertToClaimDeviceProto(DeviceId deviceId, JsonElement jsonElement) {
        String secretKey = "";
        long durationMs = 0L;
        if (jsonElement.isJsonObject()) {
            JsonObject jo = jsonElement.getAsJsonObject();
            if (jo.has("secretKey")) {
                secretKey = jo.get("secretKey").getAsString();
            }
            if (jo.has("durationMs")) {
                durationMs = jo.get("durationMs").getAsLong();
            }
        } else {
            throw new JsonSyntaxException(CAN_T_PARSE_VALUE + String.valueOf(jsonElement));
        }
        return JsonConverter.buildClaimDeviceMsg(deviceId, secretKey, durationMs);
    }

    private static TransportProtos.ClaimDeviceMsg buildClaimDeviceMsg(DeviceId deviceId, String secretKey, long durationMs) {
        TransportProtos.ClaimDeviceMsg.Builder result = TransportProtos.ClaimDeviceMsg.newBuilder();
        return result.setDeviceIdMSB(deviceId.getId().getMostSignificantBits()).setDeviceIdLSB(deviceId.getId().getLeastSignificantBits()).setSecretKey(secretKey).setDurationMs(durationMs).build();
    }

    public static TransportProtos.PostAttributeMsg convertToAttributesProto(JsonElement jsonObject) throws JsonSyntaxException {
        if (jsonObject.isJsonObject()) {
            TransportProtos.PostAttributeMsg.Builder result = TransportProtos.PostAttributeMsg.newBuilder();
            List<TransportProtos.KeyValueProto> keyValueList = JsonConverter.parseProtoValues(jsonObject.getAsJsonObject());
            result.addAllKv(keyValueList);
            return result.build();
        }
        throw new JsonSyntaxException(CAN_T_PARSE_VALUE + String.valueOf(jsonObject));
    }

    public static JsonElement toJson(TransportProtos.ToDeviceRpcRequestMsg msg, boolean includeRequestId) {
        JsonObject result = new JsonObject();
        if (includeRequestId) {
            result.addProperty("id", (Number)msg.getRequestId());
        }
        result.addProperty("method", msg.getMethodName());
        result.add("params", JsonParser.parseString((String)msg.getParams()));
        return result;
    }

    private static void parseObject(TransportProtos.PostTelemetryMsg.Builder builder, long systemTs, JsonObject jo) {
        if (jo.has("ts") && jo.has("values")) {
            JsonConverter.parseWithTs(builder, jo);
        } else {
            JsonConverter.parseWithoutTs(builder, systemTs, jo);
        }
    }

    private static void parseWithoutTs(TransportProtos.PostTelemetryMsg.Builder request, long systemTs, JsonObject jo) {
        TransportProtos.TsKvListProto.Builder builder = TransportProtos.TsKvListProto.newBuilder();
        builder.setTs(systemTs);
        builder.addAllKv(JsonConverter.parseProtoValues(jo));
        request.addTsKvList(builder.build());
    }

    private static void parseWithTs(TransportProtos.PostTelemetryMsg.Builder request, JsonObject jo) {
        JsonElement tsJsonElement = jo.get("ts");
        if (tsJsonElement.isJsonNull()) {
            throw new JsonSyntaxException("Can't parse value: ts is null!");
        }
        if (tsJsonElement.isJsonArray()) {
            throw new JsonSyntaxException("Can't parse value: ts is array!");
        }
        TransportProtos.TsKvListProto.Builder builder = TransportProtos.TsKvListProto.newBuilder();
        builder.setTs(tsJsonElement.getAsLong());
        builder.addAllKv(JsonConverter.parseProtoValues(jo.get("values").getAsJsonObject()));
        request.addTsKvList(builder.build());
    }

    private static List<TransportProtos.KeyValueProto> parseProtoValues(JsonObject valuesObject) {
        ArrayList<TransportProtos.KeyValueProto> result = new ArrayList<TransportProtos.KeyValueProto>();
        for (Map.Entry valueEntry : valuesObject.entrySet()) {
            JsonElement element = (JsonElement)valueEntry.getValue();
            if (element.isJsonPrimitive()) {
                JsonPrimitive value = element.getAsJsonPrimitive();
                if (value.isString()) {
                    if (maxStringValueLength > 0 && value.getAsString().length() > maxStringValueLength) {
                        String message = String.format("String value length [%d] for key [%s] is greater than maximum allowed [%d]", value.getAsString().length(), valueEntry.getKey(), maxStringValueLength);
                        throw new JsonSyntaxException(message);
                    }
                    if (isTypeCastEnabled && NumberUtils.isParsable((String)value.getAsString())) {
                        try {
                            result.add(JsonConverter.buildNumericKeyValueProto(value, (String)valueEntry.getKey()));
                        }
                        catch (RuntimeException th) {
                            result.add(TransportProtos.KeyValueProto.newBuilder().setKey((String)valueEntry.getKey()).setType(TransportProtos.KeyValueType.STRING_V).setStringV(value.getAsString()).build());
                        }
                        continue;
                    }
                    result.add(TransportProtos.KeyValueProto.newBuilder().setKey((String)valueEntry.getKey()).setType(TransportProtos.KeyValueType.STRING_V).setStringV(value.getAsString()).build());
                    continue;
                }
                if (value.isBoolean()) {
                    result.add(TransportProtos.KeyValueProto.newBuilder().setKey((String)valueEntry.getKey()).setType(TransportProtos.KeyValueType.BOOLEAN_V).setBoolV(value.getAsBoolean()).build());
                    continue;
                }
                if (value.isNumber()) {
                    result.add(JsonConverter.buildNumericKeyValueProto(value, (String)valueEntry.getKey()));
                    continue;
                }
                if (value.isJsonNull()) continue;
                throw new JsonSyntaxException(CAN_T_PARSE_VALUE + String.valueOf(value));
            }
            if (element.isJsonObject() || element.isJsonArray()) {
                result.add(TransportProtos.KeyValueProto.newBuilder().setKey((String)valueEntry.getKey()).setType(TransportProtos.KeyValueType.JSON_V).setJsonV(element.toString()).build());
                continue;
            }
            if (element.isJsonNull()) continue;
            throw new JsonSyntaxException(CAN_T_PARSE_VALUE + String.valueOf(element));
        }
        return result;
    }

    private static TransportProtos.KeyValueProto buildNumericKeyValueProto(JsonPrimitive value, String key) {
        String valueAsString = value.getAsString();
        TransportProtos.KeyValueProto.Builder builder = TransportProtos.KeyValueProto.newBuilder().setKey(key);
        BigDecimal bd = new BigDecimal(valueAsString);
        if (bd.stripTrailingZeros().scale() <= 0 && !JsonConverter.isSimpleDouble(valueAsString)) {
            try {
                return builder.setType(TransportProtos.KeyValueType.LONG_V).setLongV(bd.longValueExact()).build();
            }
            catch (ArithmeticException e) {
                if (!value.isNumber() || isTypeCastEnabled) {
                    return builder.setType(TransportProtos.KeyValueType.STRING_V).setStringV(bd.toPlainString()).build();
                }
                throw new JsonSyntaxException("Big integer values are not supported!");
            }
        }
        if (bd.scale() <= 16) {
            return builder.setType(TransportProtos.KeyValueType.DOUBLE_V).setDoubleV(bd.doubleValue()).build();
        }
        if (!value.isNumber() || isTypeCastEnabled) {
            return builder.setType(TransportProtos.KeyValueType.STRING_V).setStringV(bd.toPlainString()).build();
        }
        throw new JsonSyntaxException("Big integer values are not supported!");
    }

    private static boolean isSimpleDouble(String valueAsString) {
        return valueAsString.contains(".") && !valueAsString.contains("E") && !valueAsString.contains("e");
    }

    public static TransportProtos.ToServerRpcRequestMsg convertToServerRpcRequest(JsonElement json, int requestId) throws JsonSyntaxException {
        JsonObject object = json.getAsJsonObject();
        return TransportProtos.ToServerRpcRequestMsg.newBuilder().setRequestId(requestId).setMethodName(object.get("method").getAsString()).setParams(GSON.toJson(object.get("params"))).build();
    }

    private static void parseNumericValue(List<KvEntry> result, Map.Entry<String, JsonElement> valueEntry, JsonPrimitive value) {
        String valueAsString = value.getAsString();
        String key = valueEntry.getKey();
        BigDecimal bd = new BigDecimal(valueAsString);
        if (bd.stripTrailingZeros().scale() <= 0 && !JsonConverter.isSimpleDouble(valueAsString)) {
            try {
                result.add((KvEntry)new LongDataEntry(key, Long.valueOf(bd.longValueExact())));
            }
            catch (ArithmeticException e) {
                if (!value.isNumber() || isTypeCastEnabled) {
                    result.add((KvEntry)new StringDataEntry(key, bd.toPlainString()));
                }
                throw new JsonSyntaxException("Big integer values are not supported!");
            }
        } else if (bd.scale() <= 16) {
            result.add((KvEntry)new DoubleDataEntry(key, Double.valueOf(bd.doubleValue())));
        } else if (!value.isNumber() || isTypeCastEnabled) {
            result.add((KvEntry)new StringDataEntry(key, bd.toPlainString()));
        } else {
            throw new JsonSyntaxException("Big integer values are not supported!");
        }
    }

    public static JsonObject toJson(TransportProtos.GetAttributeResponseMsg payload) {
        JsonObject attrObject;
        JsonObject result = new JsonObject();
        if (payload.getClientAttributeListCount() > 0) {
            attrObject = new JsonObject();
            payload.getClientAttributeListList().forEach(JsonConverter.addToObjectFromProto(attrObject));
            result.add("client", (JsonElement)attrObject);
        }
        if (payload.getSharedAttributeListCount() > 0) {
            attrObject = new JsonObject();
            payload.getSharedAttributeListList().forEach(JsonConverter.addToObjectFromProto(attrObject));
            result.add("shared", (JsonElement)attrObject);
        }
        return result;
    }

    public static JsonObject toJson(TransportProtos.AttributeUpdateNotificationMsg payload) {
        JsonObject result = new JsonObject();
        if (payload.getSharedUpdatedCount() > 0) {
            payload.getSharedUpdatedList().forEach(JsonConverter.addToObjectFromProto(result));
        }
        if (payload.getSharedDeletedCount() > 0) {
            JsonArray attrObject = new JsonArray();
            payload.getSharedDeletedList().forEach(arg_0 -> ((JsonArray)attrObject).add(arg_0));
            result.add("deleted", (JsonElement)attrObject);
        }
        return result;
    }

    public static JsonObject getJsonObjectForGateway(String deviceName, TransportProtos.GetAttributeResponseMsg responseMsg) {
        JsonObject result = new JsonObject();
        result.addProperty("id", (Number)responseMsg.getRequestId());
        result.addProperty(DEVICE_PROPERTY, deviceName);
        if (responseMsg.getClientAttributeListCount() > 0) {
            JsonConverter.addValues(result, responseMsg.getClientAttributeListList(), responseMsg.getIsMultipleAttributesRequest());
        }
        if (responseMsg.getSharedAttributeListCount() > 0) {
            JsonConverter.addValues(result, responseMsg.getSharedAttributeListList(), responseMsg.getIsMultipleAttributesRequest());
        }
        return result;
    }

    public static JsonObject getJsonObjectForGateway(String deviceName, TransportProtos.AttributeUpdateNotificationMsg notificationMsg) {
        JsonObject result = new JsonObject();
        result.addProperty(DEVICE_PROPERTY, deviceName);
        result.add("data", (JsonElement)JsonConverter.toJson(notificationMsg));
        return result;
    }

    private static void addValues(JsonObject result, List<TransportProtos.TsKvProto> kvList, boolean multipleAttrKeysRequested) {
        if (kvList.size() == 1 && !multipleAttrKeysRequested) {
            JsonConverter.addValueToJson(result, "value", kvList.get(0).getKv());
        } else {
            JsonObject values;
            if (result.has("values")) {
                values = result.get("values").getAsJsonObject();
            } else {
                values = new JsonObject();
                result.add("values", (JsonElement)values);
            }
            kvList.forEach(value -> JsonConverter.addValueToJson(values, value.getKv().getKey(), value.getKv()));
        }
    }

    private static void addValueToJson(JsonObject json, String name, TransportProtos.KeyValueProto entry) {
        switch (entry.getType()) {
            case BOOLEAN_V: {
                json.addProperty(name, Boolean.valueOf(entry.getBoolV()));
                break;
            }
            case STRING_V: {
                json.addProperty(name, entry.getStringV());
                break;
            }
            case DOUBLE_V: {
                json.addProperty(name, (Number)entry.getDoubleV());
                break;
            }
            case LONG_V: {
                json.addProperty(name, (Number)entry.getLongV());
                break;
            }
            case JSON_V: {
                json.add(name, JsonParser.parseString((String)entry.getJsonV()));
            }
        }
    }

    private static Consumer<TransportProtos.TsKvProto> addToObjectFromProto(JsonObject result) {
        return de -> {
            switch (de.getKv().getType()) {
                case BOOLEAN_V: {
                    result.add(de.getKv().getKey(), (JsonElement)new JsonPrimitive(Boolean.valueOf(de.getKv().getBoolV())));
                    break;
                }
                case DOUBLE_V: {
                    result.add(de.getKv().getKey(), (JsonElement)new JsonPrimitive((Number)de.getKv().getDoubleV()));
                    break;
                }
                case LONG_V: {
                    result.add(de.getKv().getKey(), (JsonElement)new JsonPrimitive((Number)de.getKv().getLongV()));
                    break;
                }
                case STRING_V: {
                    result.add(de.getKv().getKey(), (JsonElement)new JsonPrimitive(de.getKv().getStringV()));
                    break;
                }
                case JSON_V: {
                    result.add(de.getKv().getKey(), JsonParser.parseString((String)de.getKv().getJsonV()));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported data type: " + String.valueOf((Object)de.getKv().getType()));
                }
            }
        };
    }

    private static Consumer<AttributeKvEntry> addToObject(JsonObject result) {
        return de -> {
            switch (de.getDataType()) {
                case BOOLEAN: {
                    result.add(de.getKey(), (JsonElement)new JsonPrimitive((Boolean)de.getBooleanValue().get()));
                    break;
                }
                case DOUBLE: {
                    result.add(de.getKey(), (JsonElement)new JsonPrimitive((Number)de.getDoubleValue().get()));
                    break;
                }
                case LONG: {
                    result.add(de.getKey(), (JsonElement)new JsonPrimitive((Number)de.getLongValue().get()));
                    break;
                }
                case STRING: {
                    result.add(de.getKey(), (JsonElement)new JsonPrimitive((String)de.getStrValue().get()));
                    break;
                }
                case JSON: {
                    result.add(de.getKey(), JsonParser.parseString((String)((String)de.getJsonValue().get())));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported data type: " + String.valueOf(de.getDataType()));
                }
            }
        };
    }

    public static JsonElement toJson(TransportProtos.ToServerRpcResponseMsg msg) {
        if (StringUtils.isEmpty((String)msg.getError())) {
            return JsonParser.parseString((String)msg.getPayload());
        }
        JsonObject errorMsg = new JsonObject();
        errorMsg.addProperty("error", msg.getError());
        return errorMsg;
    }

    public static JsonObject toJson(TransportProtos.ProvisionDeviceResponseMsg payload) {
        return JsonConverter.toJson(payload, false, 0);
    }

    public static JsonObject toJson(TransportProtos.ProvisionDeviceResponseMsg payload, int requestId) {
        return JsonConverter.toJson(payload, true, requestId);
    }

    private static JsonObject toJson(TransportProtos.ProvisionDeviceResponseMsg payload, boolean toGateway, int requestId) {
        JsonObject result = new JsonObject();
        if (payload.getStatus() == TransportProtos.ResponseStatus.NOT_FOUND) {
            result.addProperty("errorMsg", "Provision data was not found!");
            result.addProperty("status", TransportProtos.ResponseStatus.NOT_FOUND.name());
        } else if (payload.getStatus() == TransportProtos.ResponseStatus.FAILURE) {
            result.addProperty("errorMsg", "Failed to provision device!");
            result.addProperty("status", TransportProtos.ResponseStatus.FAILURE.name());
        } else {
            if (toGateway) {
                result.addProperty("id", (Number)requestId);
            }
            switch (payload.getCredentialsType()) {
                case ACCESS_TOKEN: 
                case X509_CERTIFICATE: {
                    result.addProperty("credentialsValue", payload.getCredentialsValue());
                    break;
                }
                case MQTT_BASIC: {
                    result.add("credentialsValue", (JsonElement)JsonParser.parseString((String)payload.getCredentialsValue()).getAsJsonObject());
                    break;
                }
            }
            result.addProperty("credentialsType", payload.getCredentialsType().name());
            result.addProperty("status", TransportProtos.ResponseStatus.SUCCESS.name());
        }
        return result;
    }

    public static JsonObject toGatewayDeviceDisconnectJson(String deviceName, int reasonCode) {
        JsonObject result = new JsonObject();
        result.addProperty(DEVICE_PROPERTY, deviceName);
        result.addProperty("reason", (Number)reasonCode);
        return result;
    }

    public static JsonElement toErrorJson(String errorMsg) {
        JsonObject error = new JsonObject();
        error.addProperty("error", errorMsg);
        return error;
    }

    public static JsonElement toGatewayJson(String deviceName, TransportProtos.ToDeviceRpcRequestMsg rpcRequest) {
        JsonObject result = new JsonObject();
        result.addProperty(DEVICE_PROPERTY, deviceName);
        result.add("data", JsonConverter.toJson(rpcRequest, true));
        return result;
    }

    public static JsonElement toGatewayJson(String deviceName, TransportProtos.ProvisionDeviceResponseMsg responseRequest) {
        JsonObject result = new JsonObject();
        result.addProperty(DEVICE_PROPERTY, deviceName);
        result.add("data", (JsonElement)JsonConverter.toJson(responseRequest));
        return result;
    }

    public static List<AttributeKvEntry> convertToAttributes(JsonElement element) {
        long ts = System.currentTimeMillis();
        return JsonConverter.convertToAttributes(element, ts);
    }

    public static List<AttributeKvEntry> convertToAttributes(JsonElement element, long ts) {
        return JsonConverter.parseValues(element.getAsJsonObject()).stream().map(kv -> new BaseAttributeKvEntry(kv, ts)).toList();
    }

    private static List<KvEntry> parseValues(JsonObject valuesObject) {
        ArrayList<KvEntry> result = new ArrayList<KvEntry>();
        for (Map.Entry valueEntry : valuesObject.entrySet()) {
            JsonElement element = (JsonElement)valueEntry.getValue();
            if (element.isJsonPrimitive()) {
                JsonPrimitive value = element.getAsJsonPrimitive();
                if (value.isString()) {
                    if (maxStringValueLength > 0 && value.getAsString().length() > maxStringValueLength) {
                        String message = String.format("String value length [%d] for key [%s] is greater than maximum allowed [%d]", value.getAsString().length(), valueEntry.getKey(), maxStringValueLength);
                        throw new JsonSyntaxException(message);
                    }
                    if (isTypeCastEnabled && NumberUtils.isParsable((String)value.getAsString())) {
                        try {
                            JsonConverter.parseNumericValue(result, valueEntry, value);
                        }
                        catch (RuntimeException th) {
                            result.add((KvEntry)new StringDataEntry((String)valueEntry.getKey(), value.getAsString()));
                        }
                        continue;
                    }
                    result.add((KvEntry)new StringDataEntry((String)valueEntry.getKey(), value.getAsString()));
                    continue;
                }
                if (value.isBoolean()) {
                    result.add((KvEntry)new BooleanDataEntry((String)valueEntry.getKey(), Boolean.valueOf(value.getAsBoolean())));
                    continue;
                }
                if (value.isNumber()) {
                    JsonConverter.parseNumericValue(result, valueEntry, value);
                    continue;
                }
                throw new JsonSyntaxException(CAN_T_PARSE_VALUE + String.valueOf(value));
            }
            if (element.isJsonObject() || element.isJsonArray()) {
                result.add((KvEntry)new JsonDataEntry((String)valueEntry.getKey(), element.toString()));
                continue;
            }
            throw new JsonSyntaxException(CAN_T_PARSE_VALUE + String.valueOf(element));
        }
        return result;
    }

    public static Map<Long, List<KvEntry>> convertToTelemetry(JsonElement jsonElement, long systemTs) throws JsonSyntaxException {
        return JsonConverter.convertToTelemetry(jsonElement, systemTs, false);
    }

    public static Map<Long, List<KvEntry>> convertToSortedTelemetry(JsonElement jsonElement, long systemTs) throws JsonSyntaxException {
        return JsonConverter.convertToTelemetry(jsonElement, systemTs, true);
    }

    public static Map<Long, List<KvEntry>> convertToTelemetry(JsonElement jsonElement, long systemTs, boolean sorted) throws JsonSyntaxException {
        TreeMap<Long, List<KvEntry>> result = sorted ? new TreeMap() : new HashMap();
        JsonConverter.convertToTelemetry(jsonElement, systemTs, result, null);
        return result;
    }

    private static void parseObject(Map<Long, List<KvEntry>> result, long systemTs, JsonObject jo) {
        if (jo.has("ts") && jo.has("values")) {
            JsonConverter.parseWithTs(result, jo);
        } else {
            JsonConverter.parseWithoutTs(result, systemTs, jo);
        }
    }

    private static void parseWithoutTs(Map<Long, List<KvEntry>> result, long systemTs, JsonObject jo) {
        for (KvEntry entry : JsonConverter.parseValues(jo)) {
            result.computeIfAbsent(systemTs, tmp -> new ArrayList()).add(entry);
        }
    }

    public static void parseWithTs(Map<Long, List<KvEntry>> result, JsonObject jo) {
        JsonElement tsJsonElement = jo.get("ts");
        if (tsJsonElement.isJsonNull()) {
            throw new JsonSyntaxException("Can't parse value: ts is null!");
        }
        if (tsJsonElement.isJsonArray()) {
            throw new JsonSyntaxException("Can't parse value: ts is array!");
        }
        long ts = tsJsonElement.getAsLong();
        JsonObject valuesObject = jo.get("values").getAsJsonObject();
        for (KvEntry entry : JsonConverter.parseValues(valuesObject)) {
            result.computeIfAbsent(ts, tmp -> new ArrayList()).add(entry);
        }
    }

    public static JsonElement parse(String json) {
        return JsonParser.parseString((String)json);
    }

    public static <T> T parse(String json, Class<T> clazz) {
        return JsonConverter.fromJson(JsonConverter.parse(json), clazz);
    }

    public static String toJson(JsonElement element) {
        return GSON.toJson(element);
    }

    public static JsonObject toJsonObject(Object o) {
        return (JsonObject)GSON.toJsonTree(o);
    }

    public static <T> T fromJson(JsonElement element, Class<T> type) {
        return (T)GSON.fromJson(element, type);
    }

    static void setTypeCastEnabled(boolean enabled) {
        isTypeCastEnabled = enabled;
    }

    static void setMaxStringValueLength(int length) {
        maxStringValueLength = length;
    }

    public static TransportProtos.ProvisionDeviceRequestMsg convertToProvisionRequestMsg(String json) {
        JsonElement jsonElement = JsonParser.parseString((String)json);
        if (jsonElement.isJsonObject()) {
            return JsonConverter.buildProvisionRequestMsg(jsonElement.getAsJsonObject());
        }
        throw new JsonSyntaxException(CAN_T_PARSE_VALUE + String.valueOf(jsonElement));
    }

    public static TransportProtos.ProvisionDeviceRequestMsg convertToProvisionRequestMsg(JsonObject jo) {
        return JsonConverter.buildProvisionRequestMsg(jo);
    }

    private static TransportProtos.ProvisionDeviceRequestMsg buildProvisionRequestMsg(JsonObject jo) {
        return TransportProtos.ProvisionDeviceRequestMsg.newBuilder().setDeviceName(JsonConverter.getStrValue(jo, "deviceName", false)).setCredentialsType(jo.get("credentialsType") != null ? TransportProtos.CredentialsType.valueOf(JsonConverter.getStrValue(jo, "credentialsType", false)) : TransportProtos.CredentialsType.ACCESS_TOKEN).setCredentialsDataProto(TransportProtos.CredentialsDataProto.newBuilder().setValidateDeviceTokenRequestMsg(TransportProtos.ValidateDeviceTokenRequestMsg.newBuilder().setToken(JsonConverter.getStrValue(jo, "token", false)).build()).setValidateBasicMqttCredRequestMsg(TransportProtos.ValidateBasicMqttCredRequestMsg.newBuilder().setClientId(JsonConverter.getStrValue(jo, "clientId", false)).setUserName(JsonConverter.getStrValue(jo, "username", false)).setPassword(JsonConverter.getStrValue(jo, "password", false)).build()).setValidateDeviceX509CertRequestMsg(TransportProtos.ValidateDeviceX509CertRequestMsg.newBuilder().setHash(JsonConverter.getStrValue(jo, "hash", false)).build()).build()).setProvisionDeviceCredentialsMsg(JsonConverter.buildProvisionDeviceCredentialsMsg(JsonConverter.getStrValue(jo, "provisionDeviceKey", true), JsonConverter.getStrValue(jo, "provisionDeviceSecret", true))).setGateway(jo.has("gateway") && jo.get("gateway").getAsBoolean()).build();
    }

    private static TransportProtos.ProvisionDeviceCredentialsMsg buildProvisionDeviceCredentialsMsg(String provisionKey, String provisionSecret) {
        return TransportProtos.ProvisionDeviceCredentialsMsg.newBuilder().setProvisionDeviceKey(provisionKey).setProvisionDeviceSecret(provisionSecret).build();
    }

    private static String getStrValue(JsonObject jo, String field, boolean requiredField) {
        if (jo.has(field)) {
            return jo.get(field).getAsString();
        }
        if (requiredField) {
            throw new RuntimeException("Failed to find the field " + field + " in JSON body " + String.valueOf(jo) + "!");
        }
        return "";
    }
}

