/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.util;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.server.common.data.ApiUsageRecordKey;
import org.thingsboard.server.common.data.ApiUsageState;
import org.thingsboard.server.common.data.ApiUsageStateValue;
import org.thingsboard.server.common.data.Device;
import org.thingsboard.server.common.data.DeviceProfile;
import org.thingsboard.server.common.data.DeviceProfileProvisionType;
import org.thingsboard.server.common.data.DeviceProfileType;
import org.thingsboard.server.common.data.DeviceTransportType;
import org.thingsboard.server.common.data.EdgeUtils;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.ResourceSubType;
import org.thingsboard.server.common.data.ResourceType;
import org.thingsboard.server.common.data.StringUtils;
import org.thingsboard.server.common.data.TbResource;
import org.thingsboard.server.common.data.Tenant;
import org.thingsboard.server.common.data.TenantProfile;
import org.thingsboard.server.common.data.device.data.CoapDeviceTransportConfiguration;
import org.thingsboard.server.common.data.device.data.Lwm2mDeviceTransportConfiguration;
import org.thingsboard.server.common.data.device.data.PowerMode;
import org.thingsboard.server.common.data.edge.EdgeEvent;
import org.thingsboard.server.common.data.edge.EdgeEventActionType;
import org.thingsboard.server.common.data.edge.EdgeEventType;
import org.thingsboard.server.common.data.id.ApiUsageStateId;
import org.thingsboard.server.common.data.id.CustomerId;
import org.thingsboard.server.common.data.id.DashboardId;
import org.thingsboard.server.common.data.id.DeviceCredentialsId;
import org.thingsboard.server.common.data.id.DeviceId;
import org.thingsboard.server.common.data.id.DeviceProfileId;
import org.thingsboard.server.common.data.id.EdgeId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.EntityIdFactory;
import org.thingsboard.server.common.data.id.OtaPackageId;
import org.thingsboard.server.common.data.id.RuleChainId;
import org.thingsboard.server.common.data.id.TbResourceId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.id.TenantProfileId;
import org.thingsboard.server.common.data.kv.AttributeKey;
import org.thingsboard.server.common.data.kv.AttributeKvEntry;
import org.thingsboard.server.common.data.kv.BaseAttributeKvEntry;
import org.thingsboard.server.common.data.kv.BasicKvEntry;
import org.thingsboard.server.common.data.kv.BasicTsKvEntry;
import org.thingsboard.server.common.data.kv.BooleanDataEntry;
import org.thingsboard.server.common.data.kv.DataType;
import org.thingsboard.server.common.data.kv.DoubleDataEntry;
import org.thingsboard.server.common.data.kv.JsonDataEntry;
import org.thingsboard.server.common.data.kv.KvEntry;
import org.thingsboard.server.common.data.kv.LongDataEntry;
import org.thingsboard.server.common.data.kv.StringDataEntry;
import org.thingsboard.server.common.data.kv.TsKvEntry;
import org.thingsboard.server.common.data.plugin.ComponentLifecycleEvent;
import org.thingsboard.server.common.data.rpc.RpcError;
import org.thingsboard.server.common.data.rpc.ToDeviceRpcRequestBody;
import org.thingsboard.server.common.data.security.DeviceCredentials;
import org.thingsboard.server.common.data.security.DeviceCredentialsType;
import org.thingsboard.server.common.data.sync.vc.RepositoryAuthMethod;
import org.thingsboard.server.common.data.sync.vc.RepositorySettings;
import org.thingsboard.server.common.msg.TbMsg;
import org.thingsboard.server.common.msg.ToDeviceActorNotificationMsg;
import org.thingsboard.server.common.msg.edge.EdgeEventUpdateMsg;
import org.thingsboard.server.common.msg.edge.EdgeHighPriorityMsg;
import org.thingsboard.server.common.msg.edge.FromEdgeSyncResponse;
import org.thingsboard.server.common.msg.edge.ToEdgeSyncRequest;
import org.thingsboard.server.common.msg.gen.MsgProtos;
import org.thingsboard.server.common.msg.plugin.ComponentLifecycleMsg;
import org.thingsboard.server.common.msg.queue.TbMsgCallback;
import org.thingsboard.server.common.msg.rpc.FromDeviceRpcResponse;
import org.thingsboard.server.common.msg.rpc.FromDeviceRpcResponseActorMsg;
import org.thingsboard.server.common.msg.rpc.RemoveRpcActorMsg;
import org.thingsboard.server.common.msg.rpc.ToDeviceRpcRequest;
import org.thingsboard.server.common.msg.rpc.ToDeviceRpcRequestActorMsg;
import org.thingsboard.server.common.msg.rule.engine.DeviceAttributesEventNotificationMsg;
import org.thingsboard.server.common.msg.rule.engine.DeviceCredentialsUpdateNotificationMsg;
import org.thingsboard.server.common.msg.rule.engine.DeviceDeleteMsg;
import org.thingsboard.server.common.msg.rule.engine.DeviceEdgeUpdateMsg;
import org.thingsboard.server.common.msg.rule.engine.DeviceNameOrTypeUpdateMsg;
import org.thingsboard.server.gen.transport.TransportProtos;

public class ProtoUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ProtoUtils.class);

    public static TransportProtos.ComponentLifecycleMsgProto toProto(ComponentLifecycleMsg msg) {
        TransportProtos.ComponentLifecycleMsgProto.Builder builder = TransportProtos.ComponentLifecycleMsgProto.newBuilder().setTenantIdMSB(msg.getTenantId().getId().getMostSignificantBits()).setTenantIdLSB(msg.getTenantId().getId().getLeastSignificantBits()).setEntityType(ProtoUtils.toProto(msg.getEntityId().getEntityType())).setEntityIdMSB(msg.getEntityId().getId().getMostSignificantBits()).setEntityIdLSB(msg.getEntityId().getId().getLeastSignificantBits()).setEvent(ProtoUtils.toProto(msg.getEvent()));
        if (msg.getProfileId() != null) {
            builder.setProfileIdMSB(msg.getProfileId().getId().getMostSignificantBits());
            builder.setProfileIdLSB(msg.getProfileId().getId().getLeastSignificantBits());
        }
        if (msg.getOldProfileId() != null) {
            builder.setOldProfileIdMSB(msg.getOldProfileId().getId().getMostSignificantBits());
            builder.setOldProfileIdLSB(msg.getOldProfileId().getId().getLeastSignificantBits());
        }
        if (msg.getName() != null) {
            builder.setName(msg.getName());
        }
        if (msg.getOldName() != null) {
            builder.setOldName(msg.getOldName());
        }
        if (msg.getInfo() != null) {
            builder.setInfo(JacksonUtil.toString((Object)msg.getInfo()));
        }
        return builder.build();
    }

    public static TransportProtos.EntityTypeProto toProto(EntityType entityType) {
        return TransportProtos.EntityTypeProto.forNumber(entityType.getProtoNumber());
    }

    public static ComponentLifecycleMsg fromProto(TransportProtos.ComponentLifecycleMsgProto proto) {
        EntityType profileType;
        EntityId entityId = EntityIdFactory.getByTypeAndUuid((EntityType)ProtoUtils.fromProto(proto.getEntityType()), (UUID)new UUID(proto.getEntityIdMSB(), proto.getEntityIdLSB()));
        ComponentLifecycleMsg.ComponentLifecycleMsgBuilder builder = ComponentLifecycleMsg.builder().tenantId(TenantId.fromUUID((UUID)new UUID(proto.getTenantIdMSB(), proto.getTenantIdLSB()))).entityId(entityId).event(ProtoUtils.fromProto(proto.getEvent()));
        if (!StringUtils.isEmpty((String)proto.getName())) {
            builder.name(proto.getName());
        }
        if (!StringUtils.isEmpty((String)proto.getOldName())) {
            builder.oldName(proto.getOldName());
        }
        if (proto.getProfileIdMSB() != 0L || proto.getProfileIdLSB() != 0L) {
            profileType = EntityType.DEVICE.equals((Object)entityId.getEntityType()) ? EntityType.DEVICE_PROFILE : EntityType.ASSET_PROFILE;
            builder.profileId(EntityIdFactory.getByTypeAndUuid((EntityType)profileType, (UUID)new UUID(proto.getProfileIdMSB(), proto.getProfileIdLSB())));
        }
        if (proto.getOldProfileIdMSB() != 0L || proto.getOldProfileIdLSB() != 0L) {
            profileType = EntityType.DEVICE.equals((Object)entityId.getEntityType()) ? EntityType.DEVICE_PROFILE : EntityType.ASSET_PROFILE;
            builder.oldProfileId(EntityIdFactory.getByTypeAndUuid((EntityType)profileType, (UUID)new UUID(proto.getOldProfileIdMSB(), proto.getOldProfileIdLSB())));
        }
        if (proto.hasInfo()) {
            builder.info(JacksonUtil.toJsonNode((String)proto.getInfo()));
        }
        return builder.build();
    }

    public static EntityType fromProto(TransportProtos.EntityTypeProto entityType) {
        return EntityType.forProtoNumber((int)entityType.getNumber());
    }

    public static TransportProtos.ComponentLifecycleEvent toProto(ComponentLifecycleEvent event) {
        return TransportProtos.ComponentLifecycleEvent.forNumber(event.getProtoNumber());
    }

    public static ComponentLifecycleEvent fromProto(TransportProtos.ComponentLifecycleEvent eventProto) {
        return ComponentLifecycleEvent.forProtoNumber((int)eventProto.getNumber());
    }

    public static TransportProtos.ToEdgeSyncRequestMsgProto toProto(ToEdgeSyncRequest request) {
        return TransportProtos.ToEdgeSyncRequestMsgProto.newBuilder().setTenantIdMSB(request.getTenantId().getId().getMostSignificantBits()).setTenantIdLSB(request.getTenantId().getId().getLeastSignificantBits()).setRequestIdMSB(request.getId().getMostSignificantBits()).setRequestIdLSB(request.getId().getLeastSignificantBits()).setEdgeIdMSB(request.getEdgeId().getId().getMostSignificantBits()).setEdgeIdLSB(request.getEdgeId().getId().getLeastSignificantBits()).setServiceId(request.getServiceId()).build();
    }

    public static ToEdgeSyncRequest fromProto(TransportProtos.ToEdgeSyncRequestMsgProto proto) {
        return new ToEdgeSyncRequest(new UUID(proto.getRequestIdMSB(), proto.getRequestIdLSB()), TenantId.fromUUID((UUID)new UUID(proto.getTenantIdMSB(), proto.getTenantIdLSB())), EdgeId.fromUUID((UUID)new UUID(proto.getEdgeIdMSB(), proto.getEdgeIdLSB())), proto.getServiceId());
    }

    public static TransportProtos.FromEdgeSyncResponseMsgProto toProto(FromEdgeSyncResponse response) {
        return TransportProtos.FromEdgeSyncResponseMsgProto.newBuilder().setTenantIdMSB(response.getTenantId().getId().getMostSignificantBits()).setTenantIdLSB(response.getTenantId().getId().getLeastSignificantBits()).setResponseIdMSB(response.getId().getMostSignificantBits()).setResponseIdLSB(response.getId().getLeastSignificantBits()).setEdgeIdMSB(response.getEdgeId().getId().getMostSignificantBits()).setEdgeIdLSB(response.getEdgeId().getId().getLeastSignificantBits()).setSuccess(response.isSuccess()).setError(response.getError()).build();
    }

    public static FromEdgeSyncResponse fromProto(TransportProtos.FromEdgeSyncResponseMsgProto proto) {
        return new FromEdgeSyncResponse(new UUID(proto.getResponseIdMSB(), proto.getResponseIdLSB()), TenantId.fromUUID((UUID)new UUID(proto.getTenantIdMSB(), proto.getTenantIdLSB())), EdgeId.fromUUID((UUID)new UUID(proto.getEdgeIdMSB(), proto.getEdgeIdLSB())), proto.getSuccess(), proto.getError());
    }

    public static TransportProtos.EdgeEventMsgProto toProto(EdgeEvent edgeEvent) {
        TransportProtos.EdgeEventMsgProto.Builder builder = TransportProtos.EdgeEventMsgProto.newBuilder();
        builder.setTenantIdMSB(edgeEvent.getTenantId().getId().getMostSignificantBits());
        builder.setTenantIdLSB(edgeEvent.getTenantId().getId().getLeastSignificantBits());
        builder.setEntityType(edgeEvent.getType().name());
        builder.setAction(edgeEvent.getAction().name());
        if (edgeEvent.getEdgeId() != null) {
            builder.setEdgeIdMSB(edgeEvent.getEdgeId().getId().getMostSignificantBits());
            builder.setEdgeIdLSB(edgeEvent.getEdgeId().getId().getLeastSignificantBits());
        }
        if (edgeEvent.getEntityId() != null) {
            builder.setEntityIdMSB(edgeEvent.getEntityId().getMostSignificantBits());
            builder.setEntityIdLSB(edgeEvent.getEntityId().getLeastSignificantBits());
        }
        if (edgeEvent.getBody() != null) {
            builder.setBody(JacksonUtil.toString((Object)edgeEvent.getBody()));
        }
        return builder.build();
    }

    public static EdgeEvent fromProto(TransportProtos.EdgeEventMsgProto proto) {
        EdgeEvent edgeEvent = new EdgeEvent();
        TenantId tenantId = TenantId.fromUUID((UUID)new UUID(proto.getTenantIdMSB(), proto.getTenantIdLSB()));
        edgeEvent.setTenantId(tenantId);
        edgeEvent.setType(EdgeEventType.valueOf((String)proto.getEntityType()));
        edgeEvent.setAction(EdgeEventActionType.valueOf((String)proto.getAction()));
        if (proto.hasEdgeIdMSB() && proto.hasEdgeIdLSB()) {
            edgeEvent.setEdgeId(new EdgeId(new UUID(proto.getEdgeIdMSB(), proto.getEdgeIdLSB())));
        }
        if (proto.hasEntityIdMSB() && proto.hasEntityIdLSB()) {
            edgeEvent.setEntityId(new UUID(proto.getEntityIdMSB(), proto.getEntityIdLSB()));
        }
        if (proto.hasBody()) {
            edgeEvent.setBody(JacksonUtil.toJsonNode((String)proto.getBody()));
        }
        return edgeEvent;
    }

    public static TransportProtos.EdgeHighPriorityMsgProto toProto(EdgeHighPriorityMsg msg) {
        TransportProtos.EdgeHighPriorityMsgProto.Builder builder = TransportProtos.EdgeHighPriorityMsgProto.newBuilder().setTenantIdMSB(msg.getTenantId().getId().getMostSignificantBits()).setTenantIdLSB(msg.getTenantId().getId().getLeastSignificantBits()).setType(msg.getEdgeEvent().getType().name()).setAction(msg.getEdgeEvent().getAction().name());
        if (msg.getEdgeEvent().getEntityId() != null) {
            builder.setEntityIdMSB(msg.getEdgeEvent().getEntityId().getMostSignificantBits());
            builder.setEntityIdLSB(msg.getEdgeEvent().getEntityId().getLeastSignificantBits());
        }
        if (msg.getEdgeEvent().getEdgeId() != null) {
            builder.setEdgeIdMSB(msg.getEdgeEvent().getEdgeId().getId().getMostSignificantBits());
            builder.setEdgeIdLSB(msg.getEdgeEvent().getEdgeId().getId().getLeastSignificantBits());
        }
        if (msg.getEdgeEvent().getBody() != null) {
            builder.setBody(JacksonUtil.toString((Object)msg.getEdgeEvent().getBody()));
        }
        return builder.build();
    }

    public static EdgeHighPriorityMsg fromProto(TransportProtos.EdgeHighPriorityMsgProto proto) {
        EdgeEventType type = EdgeEventType.valueOf((String)proto.getType());
        EdgeEventActionType actionType = EdgeEventActionType.valueOf((String)proto.getAction());
        JsonNode body = proto.hasBody() ? JacksonUtil.toJsonNode((String)proto.getBody()) : null;
        EdgeId edgeId = null;
        if (proto.hasEdgeIdMSB() && proto.hasEdgeIdLSB()) {
            edgeId = EdgeId.fromUUID((UUID)new UUID(proto.getEdgeIdMSB(), proto.getEdgeIdLSB()));
        }
        EntityId entityId = null;
        if (proto.hasEntityIdMSB() && proto.hasEntityIdLSB()) {
            entityId = EntityIdFactory.getByEdgeEventTypeAndUuid((EdgeEventType)type, (UUID)new UUID(proto.getEntityIdMSB(), proto.getEntityIdLSB()));
        }
        return new EdgeHighPriorityMsg(TenantId.fromUUID((UUID)new UUID(proto.getTenantIdMSB(), proto.getTenantIdLSB())), EdgeUtils.constructEdgeEvent((TenantId)TenantId.fromUUID((UUID)new UUID(proto.getTenantIdMSB(), proto.getTenantIdLSB())), (EdgeId)edgeId, (EdgeEventType)type, (EdgeEventActionType)actionType, (EntityId)entityId, (JsonNode)body));
    }

    public static TransportProtos.EdgeEventUpdateMsgProto toProto(EdgeEventUpdateMsg msg) {
        return TransportProtos.EdgeEventUpdateMsgProto.newBuilder().setTenantIdMSB(msg.getTenantId().getId().getMostSignificantBits()).setTenantIdLSB(msg.getTenantId().getId().getLeastSignificantBits()).setEdgeIdMSB(msg.getEdgeId().getId().getMostSignificantBits()).setEdgeIdLSB(msg.getEdgeId().getId().getLeastSignificantBits()).build();
    }

    public static EdgeEventUpdateMsg fromProto(TransportProtos.EdgeEventUpdateMsgProto proto) {
        return new EdgeEventUpdateMsg(TenantId.fromUUID((UUID)new UUID(proto.getTenantIdMSB(), proto.getTenantIdLSB())), EdgeId.fromUUID((UUID)new UUID(proto.getEdgeIdMSB(), proto.getEdgeIdLSB())));
    }

    private static TransportProtos.DeviceEdgeUpdateMsgProto toProto(DeviceEdgeUpdateMsg msg) {
        TransportProtos.DeviceEdgeUpdateMsgProto.Builder builder = TransportProtos.DeviceEdgeUpdateMsgProto.newBuilder().setTenantIdMSB(msg.getTenantId().getId().getMostSignificantBits()).setTenantIdLSB(msg.getTenantId().getId().getLeastSignificantBits()).setDeviceIdMSB(msg.getDeviceId().getId().getMostSignificantBits()).setDeviceIdLSB(msg.getDeviceId().getId().getLeastSignificantBits());
        if (msg.getEdgeId() != null) {
            builder.setEdgeIdMSB(msg.getEdgeId().getId().getMostSignificantBits()).setEdgeIdLSB(msg.getEdgeId().getId().getLeastSignificantBits());
        }
        return builder.build();
    }

    private static DeviceEdgeUpdateMsg fromProto(TransportProtos.DeviceEdgeUpdateMsgProto proto) {
        EdgeId edgeId = null;
        if (proto.hasEdgeIdMSB() && proto.hasEdgeIdLSB()) {
            edgeId = EdgeId.fromUUID((UUID)new UUID(proto.getEdgeIdMSB(), proto.getEdgeIdLSB()));
        }
        return new DeviceEdgeUpdateMsg(TenantId.fromUUID((UUID)new UUID(proto.getTenantIdMSB(), proto.getTenantIdLSB())), new DeviceId(new UUID(proto.getDeviceIdMSB(), proto.getDeviceIdLSB())), edgeId);
    }

    private static TransportProtos.DeviceNameOrTypeUpdateMsgProto toProto(DeviceNameOrTypeUpdateMsg msg) {
        return TransportProtos.DeviceNameOrTypeUpdateMsgProto.newBuilder().setTenantIdMSB(msg.getTenantId().getId().getMostSignificantBits()).setTenantIdLSB(msg.getTenantId().getId().getLeastSignificantBits()).setDeviceIdMSB(msg.getDeviceId().getId().getMostSignificantBits()).setDeviceIdLSB(msg.getDeviceId().getId().getLeastSignificantBits()).setDeviceName(msg.getDeviceName()).setDeviceType(msg.getDeviceType()).build();
    }

    private static DeviceNameOrTypeUpdateMsg fromProto(TransportProtos.DeviceNameOrTypeUpdateMsgProto proto) {
        return new DeviceNameOrTypeUpdateMsg(TenantId.fromUUID((UUID)new UUID(proto.getTenantIdMSB(), proto.getTenantIdLSB())), new DeviceId(new UUID(proto.getDeviceIdMSB(), proto.getDeviceIdLSB())), proto.getDeviceName(), proto.getDeviceType());
    }

    private static TransportProtos.DeviceAttributesEventMsgProto toProto(DeviceAttributesEventNotificationMsg msg) {
        TransportProtos.DeviceAttributesEventMsgProto.Builder builder = TransportProtos.DeviceAttributesEventMsgProto.newBuilder();
        builder.setTenantIdMSB(msg.getTenantId().getId().getMostSignificantBits()).setTenantIdLSB(msg.getTenantId().getId().getLeastSignificantBits()).setDeviceIdMSB(msg.getDeviceId().getId().getMostSignificantBits()).setDeviceIdLSB(msg.getDeviceId().getId().getLeastSignificantBits()).setDeleted(msg.isDeleted());
        if (msg.getScope() != null) {
            builder.setScope(TransportProtos.AttributeScopeProto.valueOf(msg.getScope()));
        }
        if (msg.getDeletedKeys() != null) {
            for (AttributeKey key : msg.getDeletedKeys()) {
                builder.addDeletedKeys(TransportProtos.AttributeKey.newBuilder().setScope(TransportProtos.AttributeScopeProto.valueOf(key.getScope())).setAttributeKey(key.getAttributeKey()).build());
            }
        }
        if (msg.getValues() != null) {
            for (AttributeKvEntry attributeKvEntry : msg.getValues()) {
                builder.addValues(ProtoUtils.toProto(attributeKvEntry));
            }
        }
        return builder.build();
    }

    public static TransportProtos.AttributeValueProto toProto(AttributeKvEntry attributeKvEntry) {
        TransportProtos.AttributeValueProto.Builder builder = TransportProtos.AttributeValueProto.newBuilder().setLastUpdateTs(attributeKvEntry.getLastUpdateTs()).setKey(attributeKvEntry.getKey());
        switch (attributeKvEntry.getDataType()) {
            case BOOLEAN: {
                attributeKvEntry.getBooleanValue().ifPresent(builder::setBoolV);
                builder.setHasV(attributeKvEntry.getBooleanValue().isPresent());
                builder.setType(TransportProtos.KeyValueType.BOOLEAN_V);
                break;
            }
            case STRING: {
                attributeKvEntry.getStrValue().ifPresent(builder::setStringV);
                builder.setHasV(attributeKvEntry.getStrValue().isPresent());
                builder.setType(TransportProtos.KeyValueType.STRING_V);
                break;
            }
            case DOUBLE: {
                attributeKvEntry.getDoubleValue().ifPresent(builder::setDoubleV);
                builder.setHasV(attributeKvEntry.getDoubleValue().isPresent());
                builder.setType(TransportProtos.KeyValueType.DOUBLE_V);
                break;
            }
            case LONG: {
                attributeKvEntry.getLongValue().ifPresent(builder::setLongV);
                builder.setHasV(attributeKvEntry.getLongValue().isPresent());
                builder.setType(TransportProtos.KeyValueType.LONG_V);
                break;
            }
            case JSON: {
                attributeKvEntry.getJsonValue().ifPresent(builder::setJsonV);
                builder.setHasV(attributeKvEntry.getJsonValue().isPresent());
                builder.setType(TransportProtos.KeyValueType.JSON_V);
            }
        }
        if (attributeKvEntry.getVersion() != null) {
            builder.setVersion(attributeKvEntry.getVersion());
        }
        return builder.build();
    }

    public static TransportProtos.ApiUsageRecordKeyProto toProto(ApiUsageRecordKey apiUsageRecordKey) {
        return switch (apiUsageRecordKey) {
            default -> throw new IncompatibleClassChangeError();
            case ApiUsageRecordKey.TRANSPORT_MSG_COUNT -> TransportProtos.ApiUsageRecordKeyProto.TRANSPORT_MSG_COUNT;
            case ApiUsageRecordKey.TRANSPORT_DP_COUNT -> TransportProtos.ApiUsageRecordKeyProto.TRANSPORT_DP_COUNT;
            case ApiUsageRecordKey.STORAGE_DP_COUNT -> TransportProtos.ApiUsageRecordKeyProto.STORAGE_DP_COUNT;
            case ApiUsageRecordKey.RE_EXEC_COUNT -> TransportProtos.ApiUsageRecordKeyProto.RE_EXEC_COUNT;
            case ApiUsageRecordKey.JS_EXEC_COUNT -> TransportProtos.ApiUsageRecordKeyProto.JS_EXEC_COUNT;
            case ApiUsageRecordKey.TBEL_EXEC_COUNT -> TransportProtos.ApiUsageRecordKeyProto.TBEL_EXEC_COUNT;
            case ApiUsageRecordKey.EMAIL_EXEC_COUNT -> TransportProtos.ApiUsageRecordKeyProto.EMAIL_EXEC_COUNT;
            case ApiUsageRecordKey.SMS_EXEC_COUNT -> TransportProtos.ApiUsageRecordKeyProto.SMS_EXEC_COUNT;
            case ApiUsageRecordKey.CREATED_ALARMS_COUNT -> TransportProtos.ApiUsageRecordKeyProto.CREATED_ALARMS_COUNT;
            case ApiUsageRecordKey.ACTIVE_DEVICES -> TransportProtos.ApiUsageRecordKeyProto.ACTIVE_DEVICES;
            case ApiUsageRecordKey.INACTIVE_DEVICES -> TransportProtos.ApiUsageRecordKeyProto.INACTIVE_DEVICES;
        };
    }

    public static ApiUsageRecordKey fromProto(TransportProtos.ApiUsageRecordKeyProto proto) {
        return switch (proto) {
            default -> throw new IncompatibleClassChangeError();
            case TransportProtos.ApiUsageRecordKeyProto.UNRECOGNIZED -> null;
            case TransportProtos.ApiUsageRecordKeyProto.TRANSPORT_MSG_COUNT -> ApiUsageRecordKey.TRANSPORT_MSG_COUNT;
            case TransportProtos.ApiUsageRecordKeyProto.TRANSPORT_DP_COUNT -> ApiUsageRecordKey.TRANSPORT_DP_COUNT;
            case TransportProtos.ApiUsageRecordKeyProto.STORAGE_DP_COUNT -> ApiUsageRecordKey.STORAGE_DP_COUNT;
            case TransportProtos.ApiUsageRecordKeyProto.RE_EXEC_COUNT -> ApiUsageRecordKey.RE_EXEC_COUNT;
            case TransportProtos.ApiUsageRecordKeyProto.JS_EXEC_COUNT -> ApiUsageRecordKey.JS_EXEC_COUNT;
            case TransportProtos.ApiUsageRecordKeyProto.TBEL_EXEC_COUNT -> ApiUsageRecordKey.TBEL_EXEC_COUNT;
            case TransportProtos.ApiUsageRecordKeyProto.EMAIL_EXEC_COUNT -> ApiUsageRecordKey.EMAIL_EXEC_COUNT;
            case TransportProtos.ApiUsageRecordKeyProto.SMS_EXEC_COUNT -> ApiUsageRecordKey.SMS_EXEC_COUNT;
            case TransportProtos.ApiUsageRecordKeyProto.CREATED_ALARMS_COUNT -> ApiUsageRecordKey.CREATED_ALARMS_COUNT;
            case TransportProtos.ApiUsageRecordKeyProto.ACTIVE_DEVICES -> ApiUsageRecordKey.ACTIVE_DEVICES;
            case TransportProtos.ApiUsageRecordKeyProto.INACTIVE_DEVICES -> ApiUsageRecordKey.INACTIVE_DEVICES;
        };
    }

    private static ToDeviceActorNotificationMsg fromProto(TransportProtos.DeviceAttributesEventMsgProto proto) {
        return new DeviceAttributesEventNotificationMsg(TenantId.fromUUID((UUID)new UUID(proto.getTenantIdMSB(), proto.getTenantIdLSB())), new DeviceId(new UUID(proto.getDeviceIdMSB(), proto.getDeviceIdLSB())), ProtoUtils.getAttributeKeySetFromProto(proto.getDeletedKeysList()), proto.hasScope() ? proto.getScope().name() : null, ProtoUtils.getAttributesKvEntryFromProto(proto.getValuesList()), proto.getDeleted());
    }

    private static TransportProtos.DeviceCredentialsUpdateMsgProto toProto(DeviceCredentialsUpdateNotificationMsg msg) {
        TransportProtos.DeviceCredentialsProto.Builder protoBuilder = TransportProtos.DeviceCredentialsProto.newBuilder().setDeviceIdMSB(msg.getDeviceCredentials().getDeviceId().getId().getMostSignificantBits()).setDeviceIdLSB(msg.getDeviceCredentials().getDeviceId().getId().getLeastSignificantBits()).setCredentialsId(msg.getDeviceCredentials().getCredentialsId()).setCredentialsType(TransportProtos.CredentialsType.valueOf(msg.getDeviceCredentials().getCredentialsType().name()));
        if (msg.getDeviceCredentials().getCredentialsValue() != null) {
            protoBuilder.setCredentialsValue(msg.getDeviceCredentials().getCredentialsValue());
        }
        return TransportProtos.DeviceCredentialsUpdateMsgProto.newBuilder().setTenantIdMSB(msg.getTenantId().getId().getMostSignificantBits()).setTenantIdLSB(msg.getTenantId().getId().getLeastSignificantBits()).setDeviceIdMSB(msg.getDeviceId().getId().getMostSignificantBits()).setDeviceIdLSB(msg.getDeviceId().getId().getLeastSignificantBits()).setDeviceCredentials(protoBuilder.build()).build();
    }

    private static ToDeviceActorNotificationMsg fromProto(TransportProtos.DeviceCredentialsUpdateMsgProto proto) {
        DeviceCredentials deviceCredentials = new DeviceCredentials();
        deviceCredentials.setDeviceId(new DeviceId(new UUID(proto.getDeviceCredentials().getDeviceIdMSB(), proto.getDeviceCredentials().getDeviceIdLSB())));
        deviceCredentials.setCredentialsId(proto.getDeviceCredentials().getCredentialsId());
        deviceCredentials.setCredentialsValue(proto.getDeviceCredentials().hasCredentialsValue() ? proto.getDeviceCredentials().getCredentialsValue() : null);
        deviceCredentials.setCredentialsType(DeviceCredentialsType.valueOf((String)proto.getDeviceCredentials().getCredentialsType().name()));
        return new DeviceCredentialsUpdateNotificationMsg(TenantId.fromUUID((UUID)new UUID(proto.getTenantIdMSB(), proto.getTenantIdLSB())), new DeviceId(new UUID(proto.getDeviceIdMSB(), proto.getDeviceIdLSB())), deviceCredentials);
    }

    private static TransportProtos.ToDeviceRpcRequestActorMsgProto toProto(ToDeviceRpcRequestActorMsg msg) {
        TransportProtos.ToDeviceRpcRequestMsg.Builder builder = TransportProtos.ToDeviceRpcRequestMsg.newBuilder().setMethodName(msg.getMsg().getBody().getMethod()).setParams(msg.getMsg().getBody().getParams()).setExpirationTime(msg.getMsg().getExpirationTime()).setRequestIdMSB(msg.getMsg().getId().getMostSignificantBits()).setRequestIdLSB(msg.getMsg().getId().getLeastSignificantBits()).setOneway(msg.getMsg().isOneway()).setPersisted(msg.getMsg().isPersisted());
        if (msg.getMsg().getAdditionalInfo() != null) {
            builder.setAdditionalInfo(msg.getMsg().getAdditionalInfo());
        }
        if (msg.getMsg().getRetries() != null) {
            builder.setRetries(msg.getMsg().getRetries());
        }
        TransportProtos.ToDeviceRpcRequestMsg proto = builder.build();
        return TransportProtos.ToDeviceRpcRequestActorMsgProto.newBuilder().setTenantIdMSB(msg.getTenantId().getId().getMostSignificantBits()).setTenantIdLSB(msg.getTenantId().getId().getLeastSignificantBits()).setDeviceIdMSB(msg.getDeviceId().getId().getMostSignificantBits()).setDeviceIdLSB(msg.getDeviceId().getId().getLeastSignificantBits()).setServiceId(msg.getServiceId()).setToDeviceRpcRequestMsg(proto).build();
    }

    private static ToDeviceActorNotificationMsg fromProto(TransportProtos.ToDeviceRpcRequestActorMsgProto proto) {
        TransportProtos.ToDeviceRpcRequestMsg toDeviceRpcRequestMsg = proto.getToDeviceRpcRequestMsg();
        ToDeviceRpcRequest toDeviceRpcRequest = new ToDeviceRpcRequest(new UUID(toDeviceRpcRequestMsg.getRequestIdMSB(), toDeviceRpcRequestMsg.getRequestIdLSB()), TenantId.fromUUID((UUID)new UUID(proto.getTenantIdMSB(), proto.getTenantIdLSB())), new DeviceId(new UUID(proto.getDeviceIdMSB(), proto.getDeviceIdLSB())), toDeviceRpcRequestMsg.getOneway(), toDeviceRpcRequestMsg.getExpirationTime(), new ToDeviceRpcRequestBody(toDeviceRpcRequestMsg.getMethodName(), toDeviceRpcRequestMsg.getParams()), toDeviceRpcRequestMsg.getPersisted(), toDeviceRpcRequestMsg.hasRetries() ? Integer.valueOf(toDeviceRpcRequestMsg.getRetries()) : null, toDeviceRpcRequestMsg.hasAdditionalInfo() ? toDeviceRpcRequestMsg.getAdditionalInfo() : null);
        return new ToDeviceRpcRequestActorMsg(proto.getServiceId(), toDeviceRpcRequest);
    }

    private static TransportProtos.FromDeviceRpcResponseActorMsgProto toProto(FromDeviceRpcResponseActorMsg msg) {
        TransportProtos.FromDeviceRPCResponseProto.Builder builder = TransportProtos.FromDeviceRPCResponseProto.newBuilder().setRequestIdMSB(msg.getMsg().getId().getMostSignificantBits()).setRequestIdLSB(msg.getMsg().getId().getLeastSignificantBits()).setError(msg.getMsg().getError().isPresent() ? ((RpcError)msg.getMsg().getError().get()).ordinal() : -1);
        if (msg.getMsg().getResponse().isPresent()) {
            builder.setResponse((String)msg.getMsg().getResponse().get());
        }
        return TransportProtos.FromDeviceRpcResponseActorMsgProto.newBuilder().setRequestId(msg.getRequestId()).setTenantIdMSB(msg.getTenantId().getId().getMostSignificantBits()).setTenantIdLSB(msg.getTenantId().getId().getLeastSignificantBits()).setDeviceIdMSB(msg.getDeviceId().getId().getMostSignificantBits()).setDeviceIdLSB(msg.getDeviceId().getId().getLeastSignificantBits()).setRpcResponse(builder.build()).build();
    }

    private static ToDeviceActorNotificationMsg fromProto(TransportProtos.FromDeviceRpcResponseActorMsgProto proto) {
        FromDeviceRpcResponse fromDeviceRpcResponse = new FromDeviceRpcResponse(new UUID(proto.getRpcResponse().getRequestIdMSB(), proto.getRpcResponse().getRequestIdLSB()), proto.getRpcResponse().getResponse(), proto.getRpcResponse().getError() >= 0 ? RpcError.values()[proto.getRpcResponse().getError()] : null);
        return new FromDeviceRpcResponseActorMsg(Integer.valueOf(proto.getRequestId()), TenantId.fromUUID((UUID)new UUID(proto.getTenantIdMSB(), proto.getTenantIdLSB())), new DeviceId(new UUID(proto.getDeviceIdMSB(), proto.getDeviceIdLSB())), fromDeviceRpcResponse);
    }

    private static TransportProtos.RemoveRpcActorMsgProto toProto(RemoveRpcActorMsg msg) {
        return TransportProtos.RemoveRpcActorMsgProto.newBuilder().setTenantIdMSB(msg.getTenantId().getId().getMostSignificantBits()).setTenantIdLSB(msg.getTenantId().getId().getLeastSignificantBits()).setDeviceIdMSB(msg.getDeviceId().getId().getMostSignificantBits()).setDeviceIdLSB(msg.getDeviceId().getId().getLeastSignificantBits()).setRequestIdMSB(msg.getRequestId().getMostSignificantBits()).setRequestIdLSB(msg.getRequestId().getLeastSignificantBits()).build();
    }

    private static ToDeviceActorNotificationMsg fromProto(TransportProtos.RemoveRpcActorMsgProto proto) {
        return new RemoveRpcActorMsg(TenantId.fromUUID((UUID)new UUID(proto.getTenantIdMSB(), proto.getTenantIdLSB())), new DeviceId(new UUID(proto.getDeviceIdMSB(), proto.getDeviceIdLSB())), new UUID(proto.getRequestIdMSB(), proto.getRequestIdLSB()));
    }

    private static TransportProtos.DeviceDeleteMsgProto toProto(DeviceDeleteMsg msg) {
        return TransportProtos.DeviceDeleteMsgProto.newBuilder().setTenantIdMSB(msg.getTenantId().getId().getMostSignificantBits()).setTenantIdLSB(msg.getTenantId().getId().getLeastSignificantBits()).setDeviceIdMSB(msg.getDeviceId().getId().getMostSignificantBits()).setDeviceIdLSB(msg.getDeviceId().getId().getLeastSignificantBits()).build();
    }

    private static DeviceDeleteMsg fromProto(TransportProtos.DeviceDeleteMsgProto proto) {
        return new DeviceDeleteMsg(TenantId.fromUUID((UUID)new UUID(proto.getTenantIdMSB(), proto.getTenantIdLSB())), new DeviceId(new UUID(proto.getDeviceIdMSB(), proto.getDeviceIdLSB())));
    }

    public static TransportProtos.ToDeviceActorNotificationMsgProto toProto(ToDeviceActorNotificationMsg msg) {
        if (msg instanceof DeviceEdgeUpdateMsg) {
            DeviceEdgeUpdateMsg updateMsg = (DeviceEdgeUpdateMsg)msg;
            TransportProtos.DeviceEdgeUpdateMsgProto proto = ProtoUtils.toProto(updateMsg);
            return TransportProtos.ToDeviceActorNotificationMsgProto.newBuilder().setDeviceEdgeUpdateMsg(proto).build();
        }
        if (msg instanceof DeviceNameOrTypeUpdateMsg) {
            DeviceNameOrTypeUpdateMsg updateMsg = (DeviceNameOrTypeUpdateMsg)msg;
            TransportProtos.DeviceNameOrTypeUpdateMsgProto proto = ProtoUtils.toProto(updateMsg);
            return TransportProtos.ToDeviceActorNotificationMsgProto.newBuilder().setDeviceNameOrTypeMsg(proto).build();
        }
        if (msg instanceof DeviceAttributesEventNotificationMsg) {
            DeviceAttributesEventNotificationMsg updateMsg = (DeviceAttributesEventNotificationMsg)msg;
            TransportProtos.DeviceAttributesEventMsgProto proto = ProtoUtils.toProto(updateMsg);
            return TransportProtos.ToDeviceActorNotificationMsgProto.newBuilder().setDeviceAttributesEventMsg(proto).build();
        }
        if (msg instanceof DeviceCredentialsUpdateNotificationMsg) {
            DeviceCredentialsUpdateNotificationMsg updateMsg = (DeviceCredentialsUpdateNotificationMsg)msg;
            TransportProtos.DeviceCredentialsUpdateMsgProto proto = ProtoUtils.toProto(updateMsg);
            return TransportProtos.ToDeviceActorNotificationMsgProto.newBuilder().setDeviceCredentialsUpdateMsg(proto).build();
        }
        if (msg instanceof ToDeviceRpcRequestActorMsg) {
            ToDeviceRpcRequestActorMsg updateMsg = (ToDeviceRpcRequestActorMsg)msg;
            TransportProtos.ToDeviceRpcRequestActorMsgProto proto = ProtoUtils.toProto(updateMsg);
            return TransportProtos.ToDeviceActorNotificationMsgProto.newBuilder().setToDeviceRpcRequestMsg(proto).build();
        }
        if (msg instanceof FromDeviceRpcResponseActorMsg) {
            FromDeviceRpcResponseActorMsg updateMsg = (FromDeviceRpcResponseActorMsg)msg;
            TransportProtos.FromDeviceRpcResponseActorMsgProto proto = ProtoUtils.toProto(updateMsg);
            return TransportProtos.ToDeviceActorNotificationMsgProto.newBuilder().setFromDeviceRpcResponseMsg(proto).build();
        }
        if (msg instanceof RemoveRpcActorMsg) {
            RemoveRpcActorMsg updateMsg = (RemoveRpcActorMsg)msg;
            TransportProtos.RemoveRpcActorMsgProto proto = ProtoUtils.toProto(updateMsg);
            return TransportProtos.ToDeviceActorNotificationMsgProto.newBuilder().setRemoveRpcActorMsg(proto).build();
        }
        if (msg instanceof DeviceDeleteMsg) {
            DeviceDeleteMsg updateMsg = (DeviceDeleteMsg)msg;
            TransportProtos.DeviceDeleteMsgProto proto = ProtoUtils.toProto(updateMsg);
            return TransportProtos.ToDeviceActorNotificationMsgProto.newBuilder().setDeviceDeleteMsg(proto).build();
        }
        return null;
    }

    public static ToDeviceActorNotificationMsg fromProto(TransportProtos.ToDeviceActorNotificationMsgProto proto) {
        if (proto.hasDeviceEdgeUpdateMsg()) {
            return ProtoUtils.fromProto(proto.getDeviceEdgeUpdateMsg());
        }
        if (proto.hasDeviceNameOrTypeMsg()) {
            return ProtoUtils.fromProto(proto.getDeviceNameOrTypeMsg());
        }
        if (proto.hasDeviceAttributesEventMsg()) {
            return ProtoUtils.fromProto(proto.getDeviceAttributesEventMsg());
        }
        if (proto.hasDeviceCredentialsUpdateMsg()) {
            return ProtoUtils.fromProto(proto.getDeviceCredentialsUpdateMsg());
        }
        if (proto.hasToDeviceRpcRequestMsg()) {
            return ProtoUtils.fromProto(proto.getToDeviceRpcRequestMsg());
        }
        if (proto.hasFromDeviceRpcResponseMsg()) {
            return ProtoUtils.fromProto(proto.getFromDeviceRpcResponseMsg());
        }
        if (proto.hasRemoveRpcActorMsg()) {
            return ProtoUtils.fromProto(proto.getRemoveRpcActorMsg());
        }
        if (proto.hasDeviceDeleteMsg()) {
            return ProtoUtils.fromProto(proto.getDeviceDeleteMsg());
        }
        return null;
    }

    private static Set<AttributeKey> getAttributeKeySetFromProto(List<TransportProtos.AttributeKey> deletedKeysList) {
        if (deletedKeysList.isEmpty()) {
            return null;
        }
        return deletedKeysList.stream().map(attributeKey -> new AttributeKey(attributeKey.getScope().name(), attributeKey.getAttributeKey())).collect(Collectors.toSet());
    }

    private static List<AttributeKvEntry> getAttributesKvEntryFromProto(List<TransportProtos.AttributeValueProto> valuesList) {
        if (valuesList.isEmpty()) {
            return null;
        }
        ArrayList<AttributeKvEntry> result = new ArrayList<AttributeKvEntry>();
        for (TransportProtos.AttributeValueProto kvEntry : valuesList) {
            result.add(ProtoUtils.fromProto(kvEntry));
        }
        return result;
    }

    public static AttributeKvEntry fromProto(TransportProtos.AttributeValueProto proto) {
        boolean hasValue = proto.getHasV();
        String key = proto.getKey();
        BooleanDataEntry entry = switch (proto.getType()) {
            case TransportProtos.KeyValueType.BOOLEAN_V -> new BooleanDataEntry(key, hasValue ? Boolean.valueOf(proto.getBoolV()) : null);
            case TransportProtos.KeyValueType.LONG_V -> new LongDataEntry(key, hasValue ? Long.valueOf(proto.getLongV()) : null);
            case TransportProtos.KeyValueType.DOUBLE_V -> new DoubleDataEntry(key, hasValue ? Double.valueOf(proto.getDoubleV()) : null);
            case TransportProtos.KeyValueType.STRING_V -> new StringDataEntry(key, hasValue ? proto.getStringV() : null);
            case TransportProtos.KeyValueType.JSON_V -> new JsonDataEntry(key, hasValue ? proto.getJsonV() : null);
            default -> null;
        };
        return new BaseAttributeKvEntry((KvEntry)entry, proto.getLastUpdateTs(), proto.hasVersion() ? Long.valueOf(proto.getVersion()) : null);
    }

    public static BasicKvEntry basicKvEntryFromProto(TransportProtos.AttributeValueProto proto) {
        boolean hasValue = proto.getHasV();
        String key = proto.getKey();
        return switch (proto.getType()) {
            case TransportProtos.KeyValueType.BOOLEAN_V -> new BooleanDataEntry(key, hasValue ? Boolean.valueOf(proto.getBoolV()) : null);
            case TransportProtos.KeyValueType.LONG_V -> new LongDataEntry(key, hasValue ? Long.valueOf(proto.getLongV()) : null);
            case TransportProtos.KeyValueType.DOUBLE_V -> new DoubleDataEntry(key, hasValue ? Double.valueOf(proto.getDoubleV()) : null);
            case TransportProtos.KeyValueType.STRING_V -> new StringDataEntry(key, hasValue ? proto.getStringV() : null);
            case TransportProtos.KeyValueType.JSON_V -> new JsonDataEntry(key, hasValue ? proto.getJsonV() : null);
            default -> null;
        };
    }

    public static BasicKvEntry fromProto(TransportProtos.KeyValueProto proto) {
        String key = proto.getKey();
        return switch (proto.getType()) {
            case TransportProtos.KeyValueType.BOOLEAN_V -> new BooleanDataEntry(key, Boolean.valueOf(proto.getBoolV()));
            case TransportProtos.KeyValueType.LONG_V -> new LongDataEntry(key, Long.valueOf(proto.getLongV()));
            case TransportProtos.KeyValueType.DOUBLE_V -> new DoubleDataEntry(key, Double.valueOf(proto.getDoubleV()));
            case TransportProtos.KeyValueType.STRING_V -> new StringDataEntry(key, proto.getStringV());
            case TransportProtos.KeyValueType.JSON_V -> new JsonDataEntry(key, proto.getJsonV());
            default -> null;
        };
    }

    public static BasicKvEntry basicKvEntryFromKvEntry(KvEntry kvEntry) {
        String key = kvEntry.getKey();
        return switch (kvEntry.getDataType()) {
            default -> throw new IncompatibleClassChangeError();
            case DataType.BOOLEAN -> new BooleanDataEntry(key, (Boolean)kvEntry.getBooleanValue().orElse(null));
            case DataType.LONG -> new LongDataEntry(key, (Long)kvEntry.getLongValue().orElse(null));
            case DataType.DOUBLE -> new DoubleDataEntry(key, (Double)kvEntry.getDoubleValue().orElse(null));
            case DataType.STRING -> new StringDataEntry(key, (String)kvEntry.getStrValue().orElse(null));
            case DataType.JSON -> new JsonDataEntry(key, (String)kvEntry.getJsonValue().orElse(null));
        };
    }

    public static TsKvEntry fromProto(TransportProtos.TsKvProto proto) {
        TransportProtos.KeyValueProto kvProto = proto.getKv();
        String key = kvProto.getKey();
        BooleanDataEntry entry = switch (kvProto.getType()) {
            case TransportProtos.KeyValueType.BOOLEAN_V -> new BooleanDataEntry(key, Boolean.valueOf(kvProto.getBoolV()));
            case TransportProtos.KeyValueType.LONG_V -> new LongDataEntry(key, Long.valueOf(kvProto.getLongV()));
            case TransportProtos.KeyValueType.DOUBLE_V -> new DoubleDataEntry(key, Double.valueOf(kvProto.getDoubleV()));
            case TransportProtos.KeyValueType.STRING_V -> new StringDataEntry(key, kvProto.getStringV());
            case TransportProtos.KeyValueType.JSON_V -> new JsonDataEntry(key, kvProto.getJsonV());
            default -> null;
        };
        return new BasicTsKvEntry(proto.getTs(), (KvEntry)entry, proto.hasVersion() ? Long.valueOf(proto.getVersion()) : null);
    }

    public static TransportProtos.TsKvProto toTsKvProto(TsKvEntry tsKvEntry) {
        TransportProtos.TsKvProto.Builder builder = TransportProtos.TsKvProto.newBuilder().setTs(tsKvEntry.getTs()).setKv(ProtoUtils.toKeyValueProto((KvEntry)tsKvEntry));
        if (tsKvEntry.getVersion() != null) {
            builder.setVersion(tsKvEntry.getVersion());
        }
        return builder.build();
    }

    public static TransportProtos.KeyValueProto toKeyValueProto(KvEntry kvEntry) {
        TransportProtos.KeyValueProto.Builder builder = TransportProtos.KeyValueProto.newBuilder();
        builder.setKey(kvEntry.getKey());
        switch (kvEntry.getDataType()) {
            case BOOLEAN: {
                builder.setType(TransportProtos.KeyValueType.BOOLEAN_V).setBoolV(kvEntry.getBooleanValue().orElse(false));
                break;
            }
            case LONG: {
                builder.setType(TransportProtos.KeyValueType.LONG_V).setLongV(kvEntry.getLongValue().orElse(0L));
                break;
            }
            case DOUBLE: {
                builder.setType(TransportProtos.KeyValueType.DOUBLE_V).setDoubleV(kvEntry.getDoubleValue().orElse(0.0));
                break;
            }
            case STRING: {
                builder.setType(TransportProtos.KeyValueType.STRING_V).setStringV(kvEntry.getStrValue().orElse(""));
                break;
            }
            case JSON: {
                builder.setType(TransportProtos.KeyValueType.JSON_V).setJsonV(kvEntry.getJsonValue().orElse("{}"));
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported KvEntry data type: " + String.valueOf(kvEntry.getDataType()));
            }
        }
        return builder.build();
    }

    public static TransportProtos.DeviceProto toProto(Device device) {
        TransportProtos.DeviceProto.Builder builder = TransportProtos.DeviceProto.newBuilder().setTenantIdMSB(device.getTenantId().getId().getMostSignificantBits()).setTenantIdLSB(device.getTenantId().getId().getLeastSignificantBits()).setDeviceIdMSB(device.getId().getId().getMostSignificantBits()).setDeviceIdLSB(device.getId().getId().getLeastSignificantBits()).setCreatedTime(device.getCreatedTime()).setDeviceName(device.getName()).setDeviceType(device.getType()).setDeviceProfileIdMSB(device.getDeviceProfileId().getId().getMostSignificantBits()).setDeviceProfileIdLSB(device.getDeviceProfileId().getId().getLeastSignificantBits());
        if (ProtoUtils.isNotNull(device.getCustomerId())) {
            builder.setCustomerIdMSB(ProtoUtils.getMsb((EntityId)device.getCustomerId())).setCustomerIdLSB(ProtoUtils.getLsb((EntityId)device.getCustomerId()));
        }
        if (ProtoUtils.isNotNull(device.getLabel())) {
            builder.setDeviceLabel(device.getLabel());
        }
        if (ProtoUtils.isNotNull(device.getAdditionalInfo())) {
            builder.setAdditionalInfo(JacksonUtil.toString((Object)device.getAdditionalInfo()));
        }
        if (ProtoUtils.isNotNull(device.getFirmwareId())) {
            builder.setFirmwareIdMSB(ProtoUtils.getMsb((EntityId)device.getFirmwareId())).setFirmwareIdLSB(ProtoUtils.getLsb((EntityId)device.getFirmwareId()));
        }
        if (ProtoUtils.isNotNull(device.getSoftwareId())) {
            builder.setSoftwareIdMSB(ProtoUtils.getMsb((EntityId)device.getSoftwareId())).setSoftwareIdLSB(ProtoUtils.getLsb((EntityId)device.getSoftwareId()));
        }
        if (ProtoUtils.isNotNull(device.getExternalId())) {
            builder.setExternalIdMSB(ProtoUtils.getMsb((EntityId)device.getExternalId())).setExternalIdLSB(ProtoUtils.getLsb((EntityId)device.getExternalId()));
        }
        if (ProtoUtils.isNotNull(device.getDeviceDataBytes())) {
            builder.setDeviceData(ByteString.copyFrom((byte[])device.getDeviceDataBytes()));
        }
        if (ProtoUtils.isNotNull(device.getVersion())) {
            builder.setVersion(device.getVersion());
        }
        return builder.build();
    }

    public static Device fromProto(TransportProtos.DeviceProto proto) {
        Device device = new Device(ProtoUtils.getEntityId(proto.getDeviceIdMSB(), proto.getDeviceIdLSB(), DeviceId::new));
        device.setCreatedTime(proto.getCreatedTime());
        device.setTenantId(ProtoUtils.getEntityId(proto.getTenantIdMSB(), proto.getTenantIdLSB(), TenantId::fromUUID));
        device.setName(proto.getDeviceName());
        device.setType(proto.getDeviceType());
        device.setDeviceProfileId(ProtoUtils.getEntityId(proto.getDeviceProfileIdMSB(), proto.getDeviceProfileIdLSB(), DeviceProfileId::new));
        if (proto.hasCustomerIdMSB() && proto.hasCustomerIdLSB()) {
            device.setCustomerId(ProtoUtils.getEntityId(proto.getCustomerIdMSB(), proto.getCustomerIdLSB(), CustomerId::new));
        }
        if (proto.hasDeviceLabel()) {
            device.setLabel(proto.getDeviceLabel());
        }
        if (proto.hasAdditionalInfo()) {
            device.setAdditionalInfo(JacksonUtil.toJsonNode((String)proto.getAdditionalInfo()));
        }
        if (proto.hasFirmwareIdMSB() && proto.hasFirmwareIdLSB()) {
            device.setFirmwareId(ProtoUtils.getEntityId(proto.getFirmwareIdMSB(), proto.getFirmwareIdLSB(), OtaPackageId::new));
        }
        if (proto.hasSoftwareIdMSB() && proto.hasSoftwareIdLSB()) {
            device.setSoftwareId(ProtoUtils.getEntityId(proto.getSoftwareIdMSB(), proto.getSoftwareIdLSB(), OtaPackageId::new));
        }
        if (proto.hasExternalIdMSB() && proto.hasExternalIdLSB()) {
            device.setExternalId(ProtoUtils.getEntityId(proto.getExternalIdMSB(), proto.getExternalIdLSB(), DeviceId::new));
        }
        if (proto.hasDeviceData()) {
            device.setDeviceDataBytes(proto.getDeviceData().toByteArray());
        }
        if (proto.hasVersion()) {
            device.setVersion(Long.valueOf(proto.getVersion()));
        }
        return device;
    }

    public static TransportProtos.DeviceProfileProto toProto(DeviceProfile deviceProfile) {
        TransportProtos.DeviceProfileProto.Builder builder = TransportProtos.DeviceProfileProto.newBuilder().setTenantIdMSB(ProtoUtils.getMsb((EntityId)deviceProfile.getTenantId())).setTenantIdLSB(ProtoUtils.getLsb((EntityId)deviceProfile.getTenantId())).setDeviceProfileIdMSB(ProtoUtils.getMsb((EntityId)deviceProfile.getId())).setDeviceProfileIdLSB(ProtoUtils.getLsb((EntityId)deviceProfile.getId())).setCreatedTime(deviceProfile.getCreatedTime()).setName(deviceProfile.getName()).setIsDefault(deviceProfile.isDefault()).setType(deviceProfile.getType().name()).setTransportType(deviceProfile.getTransportType().name()).setProvisionType(deviceProfile.getProvisionType().name());
        if (ProtoUtils.isNotNull(deviceProfile.getProfileDataBytes())) {
            builder.setDeviceProfileData(ByteString.copyFrom((byte[])deviceProfile.getProfileDataBytes()));
        }
        if (ProtoUtils.isNotNull(deviceProfile.getDescription())) {
            builder.setDescription(deviceProfile.getDescription());
        }
        if (ProtoUtils.isNotNull(deviceProfile.getImage())) {
            builder.setImage(deviceProfile.getImage());
        }
        if (ProtoUtils.isNotNull(deviceProfile.getDefaultRuleChainId())) {
            builder.setDefaultRuleChainIdMSB(ProtoUtils.getMsb((EntityId)deviceProfile.getDefaultRuleChainId())).setDefaultRuleChainIdLSB(ProtoUtils.getLsb((EntityId)deviceProfile.getDefaultRuleChainId()));
        }
        if (ProtoUtils.isNotNull(deviceProfile.getDefaultDashboardId())) {
            builder.setDefaultDashboardIdMSB(ProtoUtils.getMsb((EntityId)deviceProfile.getDefaultDashboardId())).setDefaultDashboardIdLSB(ProtoUtils.getLsb((EntityId)deviceProfile.getDefaultDashboardId()));
        }
        if (ProtoUtils.isNotNull(deviceProfile.getDefaultQueueName())) {
            builder.setDefaultQueueName(deviceProfile.getDefaultQueueName());
        }
        if (ProtoUtils.isNotNull(deviceProfile.getProvisionDeviceKey())) {
            builder.setProvisionDeviceKey(deviceProfile.getProvisionDeviceKey());
        }
        if (ProtoUtils.isNotNull(deviceProfile.getFirmwareId())) {
            builder.setFirmwareIdMSB(ProtoUtils.getMsb((EntityId)deviceProfile.getFirmwareId())).setFirmwareIdLSB(ProtoUtils.getLsb((EntityId)deviceProfile.getFirmwareId()));
        }
        if (ProtoUtils.isNotNull(deviceProfile.getSoftwareId())) {
            builder.setSoftwareIdMSB(ProtoUtils.getMsb((EntityId)deviceProfile.getSoftwareId())).setSoftwareIdLSB(ProtoUtils.getLsb((EntityId)deviceProfile.getSoftwareId()));
        }
        if (ProtoUtils.isNotNull(deviceProfile.getExternalId())) {
            builder.setExternalIdMSB(ProtoUtils.getMsb((EntityId)deviceProfile.getExternalId())).setExternalIdLSB(ProtoUtils.getLsb((EntityId)deviceProfile.getExternalId()));
        }
        if (ProtoUtils.isNotNull(deviceProfile.getDefaultEdgeRuleChainId())) {
            builder.setDefaultEdgeRuleChainIdMSB(ProtoUtils.getMsb((EntityId)deviceProfile.getDefaultEdgeRuleChainId())).setDefaultEdgeRuleChainIdLSB(ProtoUtils.getLsb((EntityId)deviceProfile.getDefaultEdgeRuleChainId()));
        }
        if (ProtoUtils.isNotNull(deviceProfile.getVersion())) {
            builder.setVersion(deviceProfile.getVersion());
        }
        return builder.build();
    }

    public static DeviceProfile fromProto(TransportProtos.DeviceProfileProto proto) {
        DeviceProfile deviceProfile = new DeviceProfile(ProtoUtils.getEntityId(proto.getDeviceProfileIdMSB(), proto.getDeviceProfileIdLSB(), DeviceProfileId::new));
        deviceProfile.setCreatedTime(proto.getCreatedTime());
        deviceProfile.setTenantId(ProtoUtils.getEntityId(proto.getTenantIdMSB(), proto.getTenantIdLSB(), TenantId::fromUUID));
        deviceProfile.setName(proto.getName());
        deviceProfile.setDefault(proto.getIsDefault());
        deviceProfile.setType(DeviceProfileType.valueOf((String)proto.getType()));
        deviceProfile.setTransportType(DeviceTransportType.valueOf((String)proto.getTransportType()));
        deviceProfile.setProvisionType(DeviceProfileProvisionType.valueOf((String)proto.getProvisionType()));
        if (proto.hasDeviceProfileData()) {
            deviceProfile.setProfileDataBytes(proto.getDeviceProfileData().toByteArray());
        }
        if (proto.hasDescription()) {
            deviceProfile.setDescription(proto.getDescription());
        }
        if (proto.hasImage()) {
            deviceProfile.setImage(proto.getImage());
        }
        if (proto.hasDefaultRuleChainIdMSB() && proto.hasDefaultRuleChainIdLSB()) {
            deviceProfile.setDefaultRuleChainId(ProtoUtils.getEntityId(proto.getDefaultRuleChainIdMSB(), proto.getDefaultRuleChainIdLSB(), RuleChainId::new));
        }
        if (proto.hasDefaultDashboardIdMSB() && proto.hasDefaultDashboardIdLSB()) {
            deviceProfile.setDefaultDashboardId(ProtoUtils.getEntityId(proto.getDefaultDashboardIdMSB(), proto.getDefaultDashboardIdLSB(), DashboardId::new));
        }
        if (proto.hasDefaultQueueName()) {
            deviceProfile.setDefaultQueueName(proto.getDefaultQueueName());
        }
        if (proto.hasProvisionDeviceKey()) {
            deviceProfile.setProvisionDeviceKey(proto.getProvisionDeviceKey());
        }
        if (proto.hasFirmwareIdMSB() && proto.hasFirmwareIdLSB()) {
            deviceProfile.setFirmwareId(ProtoUtils.getEntityId(proto.getFirmwareIdMSB(), proto.getFirmwareIdLSB(), OtaPackageId::new));
        }
        if (proto.hasSoftwareIdMSB() && proto.hasSoftwareIdLSB()) {
            deviceProfile.setSoftwareId(ProtoUtils.getEntityId(proto.getSoftwareIdMSB(), proto.getSoftwareIdLSB(), OtaPackageId::new));
        }
        if (proto.hasExternalIdMSB() && proto.hasExternalIdLSB()) {
            deviceProfile.setExternalId(ProtoUtils.getEntityId(proto.getExternalIdMSB(), proto.getExternalIdLSB(), DeviceProfileId::new));
        }
        if (proto.hasDefaultEdgeRuleChainIdMSB() && proto.hasDefaultEdgeRuleChainIdLSB()) {
            deviceProfile.setDefaultEdgeRuleChainId(ProtoUtils.getEntityId(proto.getDefaultEdgeRuleChainIdMSB(), proto.getDefaultEdgeRuleChainIdLSB(), RuleChainId::new));
        }
        if (proto.hasVersion()) {
            deviceProfile.setVersion(Long.valueOf(proto.getVersion()));
        }
        return deviceProfile;
    }

    public static TransportProtos.TenantProto toProto(Tenant tenant) {
        TransportProtos.TenantProto.Builder builder = TransportProtos.TenantProto.newBuilder().setTenantIdMSB(ProtoUtils.getMsb((EntityId)tenant.getTenantId())).setTenantIdLSB(ProtoUtils.getLsb((EntityId)tenant.getTenantId())).setCreatedTime(tenant.getCreatedTime()).setTenantProfileIdMSB(ProtoUtils.getMsb((EntityId)tenant.getTenantProfileId())).setTenantProfileIdLSB(ProtoUtils.getLsb((EntityId)tenant.getTenantProfileId())).setTitle(tenant.getTitle());
        if (ProtoUtils.isNotNull(tenant.getRegion())) {
            builder.setRegion(tenant.getRegion());
        }
        if (ProtoUtils.isNotNull(tenant.getCountry())) {
            builder.setCountry(tenant.getCountry());
        }
        if (ProtoUtils.isNotNull(tenant.getState())) {
            builder.setState(tenant.getState());
        }
        if (ProtoUtils.isNotNull(tenant.getCity())) {
            builder.setCity(tenant.getCity());
        }
        if (ProtoUtils.isNotNull(tenant.getAddress())) {
            builder.setAddress(tenant.getAddress());
        }
        if (ProtoUtils.isNotNull(tenant.getAddress2())) {
            builder.setAddress2(tenant.getAddress2());
        }
        if (ProtoUtils.isNotNull(tenant.getZip())) {
            builder.setZip(tenant.getZip());
        }
        if (ProtoUtils.isNotNull(tenant.getPhone())) {
            builder.setPhone(tenant.getPhone());
        }
        if (ProtoUtils.isNotNull(tenant.getEmail())) {
            builder.setEmail(tenant.getEmail());
        }
        if (ProtoUtils.isNotNull(tenant.getAdditionalInfo())) {
            builder.setAdditionalInfo(JacksonUtil.toString((Object)tenant.getAdditionalInfo()));
        }
        if (ProtoUtils.isNotNull(tenant.getVersion())) {
            builder.setVersion(tenant.getVersion());
        }
        return builder.build();
    }

    public static Tenant fromProto(TransportProtos.TenantProto proto) {
        Tenant tenant = new Tenant(ProtoUtils.getEntityId(proto.getTenantIdMSB(), proto.getTenantIdLSB(), TenantId::fromUUID));
        tenant.setCreatedTime(proto.getCreatedTime());
        tenant.setTenantProfileId(ProtoUtils.getEntityId(proto.getTenantProfileIdMSB(), proto.getTenantProfileIdLSB(), TenantProfileId::new));
        tenant.setTitle(proto.getTitle());
        if (proto.hasRegion()) {
            tenant.setRegion(proto.getRegion());
        }
        if (proto.hasCountry()) {
            tenant.setCountry(proto.getCountry());
        }
        if (proto.hasState()) {
            tenant.setState(proto.getState());
        }
        if (proto.hasCity()) {
            tenant.setCity(proto.getCity());
        }
        if (proto.hasAddress()) {
            tenant.setAddress(proto.getAddress());
        }
        if (proto.hasAddress2()) {
            tenant.setAddress2(proto.getAddress2());
        }
        if (proto.hasZip()) {
            tenant.setZip(proto.getZip());
        }
        if (proto.hasPhone()) {
            tenant.setPhone(proto.getPhone());
        }
        if (proto.hasEmail()) {
            tenant.setEmail(proto.getEmail());
        }
        if (proto.hasAdditionalInfo()) {
            tenant.setAdditionalInfo(JacksonUtil.toJsonNode((String)proto.getAdditionalInfo()));
        }
        if (proto.hasVersion()) {
            tenant.setVersion(Long.valueOf(proto.getVersion()));
        }
        return tenant;
    }

    public static TransportProtos.TenantProfileProto toProto(TenantProfile tenantProfile) {
        TransportProtos.TenantProfileProto.Builder builder = TransportProtos.TenantProfileProto.newBuilder().setTenantProfileIdMSB(ProtoUtils.getMsb((EntityId)tenantProfile.getId())).setTenantProfileIdLSB(ProtoUtils.getLsb((EntityId)tenantProfile.getId())).setCreatedTime(tenantProfile.getCreatedTime()).setName(tenantProfile.getName()).setIsDefault(tenantProfile.isDefault()).setIsolatedTbRuleEngine(tenantProfile.isIsolatedTbRuleEngine());
        if (ProtoUtils.isNotNull(tenantProfile.getDescription())) {
            builder.setDescription(tenantProfile.getDescription());
        }
        if (ProtoUtils.isNotNull(tenantProfile.getProfileDataBytes())) {
            builder.setProfileData(ByteString.copyFrom((byte[])tenantProfile.getProfileDataBytes()));
        }
        return builder.build();
    }

    public static TenantProfile fromProto(TransportProtos.TenantProfileProto proto) {
        TenantProfile tenantProfile = new TenantProfile(ProtoUtils.getEntityId(proto.getTenantProfileIdMSB(), proto.getTenantProfileIdLSB(), TenantProfileId::new));
        tenantProfile.setCreatedTime(proto.getCreatedTime());
        tenantProfile.setName(proto.getName());
        tenantProfile.setDefault(proto.getIsDefault());
        tenantProfile.setIsolatedTbRuleEngine(proto.getIsolatedTbRuleEngine());
        if (proto.hasDescription()) {
            tenantProfile.setDescription(proto.getDescription());
        }
        if (proto.hasProfileData()) {
            tenantProfile.setProfileDataBytes(proto.getProfileData().toByteArray());
        }
        return tenantProfile;
    }

    public static TransportProtos.TbResourceProto toProto(TbResource resource) {
        TransportProtos.TbResourceProto.Builder builder = TransportProtos.TbResourceProto.newBuilder().setTenantIdMSB(ProtoUtils.getMsb((EntityId)resource.getTenantId())).setTenantIdLSB(ProtoUtils.getLsb((EntityId)resource.getTenantId())).setResourceIdMSB(ProtoUtils.getMsb((EntityId)resource.getId())).setResourceIdLSB(ProtoUtils.getLsb((EntityId)resource.getId())).setCreatedTime(resource.getCreatedTime()).setTitle(resource.getTitle()).setResourceType(resource.getResourceType().name()).setResourceKey(resource.getResourceKey()).setIsPublic(resource.isPublic()).setSearchText(resource.getSearchText()).setFileName(resource.getFileName());
        if (ProtoUtils.isNotNull(resource.getPublicResourceKey())) {
            builder.setPublicResourceKey(resource.getPublicResourceKey());
        }
        if (ProtoUtils.isNotNull(resource.getEtag())) {
            builder.setEtag(resource.getEtag());
        }
        if (ProtoUtils.isNotNull(resource.getDescriptor())) {
            builder.setResourceDescriptor(JacksonUtil.toString((Object)resource.getDescriptor()));
        }
        if (ProtoUtils.isNotNull(resource.getExternalId())) {
            builder.setExternalIdMSB(ProtoUtils.getMsb((EntityId)resource.getExternalId())).setExternalIdLSB(ProtoUtils.getLsb((EntityId)resource.getExternalId()));
        }
        if (ProtoUtils.isNotNull(resource.getData())) {
            builder.setData(ByteString.copyFrom((byte[])resource.getData()));
        }
        if (ProtoUtils.isNotNull(resource.getPreview())) {
            builder.setPreview(ByteString.copyFrom((byte[])resource.getPreview()));
        }
        if (ProtoUtils.isNotNull(resource.getResourceSubType())) {
            builder.setResourceSubType(resource.getResourceSubType().name());
        }
        return builder.build();
    }

    public static TbResource fromProto(TransportProtos.TbResourceProto proto) {
        TbResource resource = new TbResource(ProtoUtils.getEntityId(proto.getResourceIdMSB(), proto.getResourceIdLSB(), TbResourceId::new));
        resource.setTenantId(ProtoUtils.getEntityId(proto.getTenantIdMSB(), proto.getTenantIdLSB(), TenantId::fromUUID));
        resource.setCreatedTime(proto.getCreatedTime());
        resource.setTitle(proto.getTitle());
        resource.setResourceType(ResourceType.valueOf((String)proto.getResourceType()));
        resource.setResourceKey(proto.getResourceKey());
        resource.setPublic(proto.getIsPublic());
        resource.setSearchText(proto.getSearchText());
        resource.setFileName(proto.getFileName());
        if (proto.hasPublicResourceKey()) {
            resource.setPublicResourceKey(proto.getPublicResourceKey());
        }
        if (proto.hasEtag()) {
            resource.setEtag(proto.getEtag());
        }
        if (proto.hasResourceDescriptor()) {
            resource.setDescriptor(JacksonUtil.toJsonNode((String)proto.getResourceDescriptor()));
        }
        if (proto.hasExternalIdMSB() && proto.hasExternalIdLSB()) {
            resource.setExternalId(ProtoUtils.getEntityId(proto.getExternalIdMSB(), proto.getExternalIdLSB(), TbResourceId::new));
        }
        if (proto.hasData()) {
            resource.setData(proto.getData().toByteArray());
        }
        if (proto.hasPreview()) {
            resource.setPreview(proto.getPreview().toByteArray());
        }
        if (proto.hasResourceSubType()) {
            resource.setResourceSubType(ResourceSubType.valueOf((String)proto.getResourceSubType()));
        }
        return resource;
    }

    public static TransportProtos.ApiUsageStateProto toProto(ApiUsageState apiUsageState) {
        return TransportProtos.ApiUsageStateProto.newBuilder().setTenantProfileIdMSB(ProtoUtils.getMsb((EntityId)apiUsageState.getTenantId())).setTenantProfileIdLSB(ProtoUtils.getLsb((EntityId)apiUsageState.getTenantId())).setApiUsageStateIdMSB(ProtoUtils.getMsb((EntityId)apiUsageState.getId())).setApiUsageStateIdLSB(ProtoUtils.getLsb((EntityId)apiUsageState.getId())).setCreatedTime(apiUsageState.getCreatedTime()).setEntityType(ProtoUtils.toProto(apiUsageState.getEntityId().getEntityType())).setEntityIdMSB(ProtoUtils.getMsb(apiUsageState.getEntityId())).setEntityIdLSB(ProtoUtils.getLsb(apiUsageState.getEntityId())).setTransportState(apiUsageState.getTransportState().name()).setDbStorageState(apiUsageState.getDbStorageState().name()).setReExecState(apiUsageState.getReExecState().name()).setJsExecState(apiUsageState.getJsExecState().name()).setTbelExecState(apiUsageState.getTbelExecState().name()).setEmailExecState(apiUsageState.getEmailExecState().name()).setSmsExecState(apiUsageState.getSmsExecState().name()).setAlarmExecState(apiUsageState.getAlarmExecState().name()).setVersion(apiUsageState.getVersion()).build();
    }

    public static ApiUsageState fromProto(TransportProtos.ApiUsageStateProto proto) {
        ApiUsageState apiUsageState = new ApiUsageState(ProtoUtils.getEntityId(proto.getApiUsageStateIdMSB(), proto.getApiUsageStateIdLSB(), ApiUsageStateId::new));
        apiUsageState.setTenantId(ProtoUtils.getEntityId(proto.getTenantProfileIdMSB(), proto.getTenantProfileIdLSB(), TenantId::fromUUID));
        apiUsageState.setCreatedTime(proto.getCreatedTime());
        apiUsageState.setEntityId(EntityIdFactory.getByTypeAndUuid((EntityType)ProtoUtils.fromProto(proto.getEntityType()), (UUID)new UUID(proto.getEntityIdMSB(), proto.getEntityIdLSB())));
        apiUsageState.setTransportState(ApiUsageStateValue.valueOf((String)proto.getTransportState()));
        apiUsageState.setDbStorageState(ApiUsageStateValue.valueOf((String)proto.getDbStorageState()));
        apiUsageState.setReExecState(ApiUsageStateValue.valueOf((String)proto.getReExecState()));
        apiUsageState.setJsExecState(ApiUsageStateValue.valueOf((String)proto.getJsExecState()));
        apiUsageState.setTbelExecState(ApiUsageStateValue.valueOf((String)proto.getTbelExecState()));
        apiUsageState.setEmailExecState(ApiUsageStateValue.valueOf((String)proto.getEmailExecState()));
        apiUsageState.setSmsExecState(ApiUsageStateValue.valueOf((String)proto.getSmsExecState()));
        apiUsageState.setAlarmExecState(ApiUsageStateValue.valueOf((String)proto.getAlarmExecState()));
        apiUsageState.setVersion(Long.valueOf(proto.getVersion()));
        return apiUsageState;
    }

    public static TransportProtos.RepositorySettingsProto toProto(RepositorySettings repositorySettings) {
        TransportProtos.RepositorySettingsProto.Builder builder = TransportProtos.RepositorySettingsProto.newBuilder().setRepositoryUri(repositorySettings.getRepositoryUri()).setAuthMethod(repositorySettings.getAuthMethod().name()).setReadOnly(repositorySettings.isReadOnly()).setShowMergeCommits(repositorySettings.isShowMergeCommits()).setLocalOnly(repositorySettings.isLocalOnly());
        if (ProtoUtils.isNotNull(repositorySettings.getUsername())) {
            builder.setUsername(repositorySettings.getUsername());
        }
        if (ProtoUtils.isNotNull(repositorySettings.getPassword())) {
            builder.setPassword(repositorySettings.getPassword());
        }
        if (ProtoUtils.isNotNull(repositorySettings.getPrivateKeyFileName())) {
            builder.setPrivateKeyFileName(repositorySettings.getPrivateKeyFileName());
        }
        if (ProtoUtils.isNotNull(repositorySettings.getPrivateKey())) {
            builder.setPrivateKey(repositorySettings.getPrivateKey());
        }
        if (ProtoUtils.isNotNull(repositorySettings.getPrivateKeyPassword())) {
            builder.setPrivateKeyPassword(repositorySettings.getPrivateKeyPassword());
        }
        if (ProtoUtils.isNotNull(repositorySettings.getDefaultBranch())) {
            builder.setDefaultBranch(repositorySettings.getDefaultBranch());
        }
        return builder.build();
    }

    public static RepositorySettings fromProto(TransportProtos.RepositorySettingsProto proto) {
        RepositorySettings repositorySettings = new RepositorySettings();
        repositorySettings.setRepositoryUri(proto.getRepositoryUri());
        repositorySettings.setAuthMethod(RepositoryAuthMethod.valueOf((String)proto.getAuthMethod()));
        repositorySettings.setReadOnly(proto.getReadOnly());
        repositorySettings.setShowMergeCommits(proto.getShowMergeCommits());
        repositorySettings.setLocalOnly(proto.getLocalOnly());
        if (proto.hasUsername()) {
            repositorySettings.setUsername(proto.getUsername());
        }
        if (proto.hasPassword()) {
            repositorySettings.setPassword(proto.getPassword());
        }
        if (proto.hasPrivateKeyFileName()) {
            repositorySettings.setPrivateKeyFileName(proto.getPrivateKeyFileName());
        }
        if (proto.hasPrivateKey()) {
            repositorySettings.setPrivateKey(proto.getPrivateKey());
        }
        if (proto.hasPrivateKeyPassword()) {
            repositorySettings.setPrivateKeyPassword(proto.getPrivateKeyPassword());
        }
        if (proto.hasDefaultBranch()) {
            repositorySettings.setDefaultBranch(proto.getDefaultBranch());
        }
        return repositorySettings;
    }

    public static TransportProtos.DeviceCredentialsProto toProto(DeviceCredentials deviceCredentials) {
        TransportProtos.DeviceCredentialsProto.Builder builder = TransportProtos.DeviceCredentialsProto.newBuilder().setCredentialsIdMSB(deviceCredentials.getId().getId().getMostSignificantBits()).setCredentialsIdLSB(deviceCredentials.getId().getId().getLeastSignificantBits()).setCreatedTime(deviceCredentials.getCreatedTime()).setDeviceIdMSB(ProtoUtils.getMsb((EntityId)deviceCredentials.getDeviceId())).setDeviceIdLSB(ProtoUtils.getLsb((EntityId)deviceCredentials.getDeviceId())).setCredentialsId(deviceCredentials.getCredentialsId()).setCredentialsType(TransportProtos.CredentialsType.valueOf(deviceCredentials.getCredentialsType().name()));
        if (deviceCredentials.getCredentialsValue() != null) {
            builder.setCredentialsValue(deviceCredentials.getCredentialsValue());
        }
        if (deviceCredentials.getVersion() != null) {
            builder.setVersion(deviceCredentials.getVersion());
        }
        return builder.build();
    }

    public static DeviceCredentials fromProto(TransportProtos.DeviceCredentialsProto proto) {
        DeviceCredentials deviceCredentials = new DeviceCredentials(new DeviceCredentialsId(new UUID(proto.getCredentialsIdMSB(), proto.getCredentialsIdLSB())));
        deviceCredentials.setCreatedTime(proto.getCreatedTime());
        deviceCredentials.setDeviceId(ProtoUtils.getEntityId(proto.getDeviceIdMSB(), proto.getDeviceIdLSB(), DeviceId::new));
        deviceCredentials.setCredentialsId(proto.getCredentialsId());
        deviceCredentials.setCredentialsType(DeviceCredentialsType.valueOf((String)proto.getCredentialsType().name()));
        deviceCredentials.setCredentialsValue(proto.hasCredentialsValue() ? proto.getCredentialsValue() : null);
        deviceCredentials.setVersion(proto.hasVersion() ? Long.valueOf(proto.getVersion()) : null);
        return deviceCredentials;
    }

    public static <T> TransportProtos.EntityUpdateMsg toEntityUpdateProto(T entity) {
        TransportProtos.EntityUpdateMsg.Builder builder = TransportProtos.EntityUpdateMsg.newBuilder();
        if (entity instanceof Device) {
            builder.setDevice(ProtoUtils.toProto((Device)entity));
        } else if (entity instanceof DeviceProfile) {
            builder.setDeviceProfile(ProtoUtils.toProto((DeviceProfile)entity));
        } else if (entity instanceof Tenant) {
            builder.setTenant(ProtoUtils.toProto((Tenant)entity));
        } else if (entity instanceof TenantProfile) {
            builder.setTenantProfile(ProtoUtils.toProto((TenantProfile)entity));
        } else if (entity instanceof ApiUsageState) {
            builder.setApiUsageState(ProtoUtils.toProto((ApiUsageState)entity));
        } else {
            log.warn("[{}] entity does not support toProto serialization .", (Object)entity.getClass().getSimpleName());
        }
        return builder.build();
    }

    public static TransportProtos.DeviceInfoProto toDeviceInfoProto(Device device) throws JsonProcessingException {
        PowerMode powerMode;
        Lwm2mDeviceTransportConfiguration psmConfiguration;
        TransportProtos.DeviceInfoProto.Builder builder = TransportProtos.DeviceInfoProto.newBuilder().setTenantIdMSB(device.getTenantId().getId().getMostSignificantBits()).setTenantIdLSB(device.getTenantId().getId().getLeastSignificantBits()).setCustomerIdMSB(ProtoUtils.getMsb((EntityId)device.getCustomerId())).setCustomerIdLSB(ProtoUtils.getLsb((EntityId)device.getCustomerId())).setDeviceIdMSB(device.getId().getId().getMostSignificantBits()).setDeviceIdLSB(device.getId().getId().getLeastSignificantBits()).setDeviceName(device.getName()).setDeviceType(device.getType()).setDeviceProfileIdMSB(device.getDeviceProfileId().getId().getMostSignificantBits()).setDeviceProfileIdLSB(device.getDeviceProfileId().getId().getLeastSignificantBits()).setAdditionalInfo(JacksonUtil.toString((Object)device.getAdditionalInfo()));
        if (device.getAdditionalInfo().has("gateway")) {
            builder.setIsGateway(device.getAdditionalInfo().get("gateway").booleanValue());
        }
        switch (device.getDeviceData().getTransportConfiguration().getType()) {
            case LWM2M: {
                Lwm2mDeviceTransportConfiguration lwm2mDeviceTransportConfiguration = (Lwm2mDeviceTransportConfiguration)device.getDeviceData().getTransportConfiguration();
                break;
            }
            case COAP: {
                Lwm2mDeviceTransportConfiguration lwm2mDeviceTransportConfiguration = (CoapDeviceTransportConfiguration)device.getDeviceData().getTransportConfiguration();
                break;
            }
            default: {
                Lwm2mDeviceTransportConfiguration lwm2mDeviceTransportConfiguration = psmConfiguration = null;
            }
        }
        if (psmConfiguration != null && (powerMode = psmConfiguration.getPowerMode()) != null) {
            builder.setPowerMode(powerMode.name());
            if (powerMode.equals((Object)PowerMode.PSM)) {
                builder.setPsmActivityTimer(ProtoUtils.checkLong(psmConfiguration.getPsmActivityTimer()));
            } else if (powerMode.equals((Object)PowerMode.E_DRX)) {
                builder.setEdrxCycle(ProtoUtils.checkLong(psmConfiguration.getEdrxCycle()));
                builder.setPagingTransmissionWindow(ProtoUtils.checkLong(psmConfiguration.getPagingTransmissionWindow()));
            }
        }
        return builder.build();
    }

    @Deprecated(forRemoval=true, since="4.1")
    public static MsgProtos.TbMsgProto getTbMsgProto(TransportProtos.ToRuleEngineMsg ruleEngineMsg) throws InvalidProtocolBufferException {
        if (ruleEngineMsg.getTbMsg().isEmpty()) {
            return ruleEngineMsg.getTbMsgProto();
        }
        return MsgProtos.TbMsgProto.parseFrom((ByteString)ruleEngineMsg.getTbMsg());
    }

    @Deprecated(forRemoval=true, since="4.1")
    public static TbMsg fromTbMsgProto(String queueName, TransportProtos.ToRuleEngineMsg ruleEngineMsg, TbMsgCallback callback) {
        return TbMsg.fromProto((String)queueName, (MsgProtos.TbMsgProto)ProtoUtils.getTbMsgProto(ruleEngineMsg), (TbMsgCallback)callback);
    }

    private static boolean isNotNull(Object obj) {
        return obj != null;
    }

    private static <T extends EntityId> T getEntityId(long msb, long lsb, Function<UUID, T> entityId) {
        return (T)((EntityId)entityId.apply(new UUID(msb, lsb)));
    }

    private static Long getMsb(EntityId entityId) {
        if (ProtoUtils.isNotNull(entityId)) {
            return entityId.getId().getMostSignificantBits();
        }
        return 0L;
    }

    private static Long getLsb(EntityId entityId) {
        if (ProtoUtils.isNotNull(entityId)) {
            return entityId.getId().getLeastSignificantBits();
        }
        return 0L;
    }

    private static Long checkLong(Long l) {
        return ProtoUtils.isNotNull(l) ? l : 0L;
    }
}

