/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.thingsboard.server.common.data.kv.AttributeKvEntry;
import org.thingsboard.server.common.data.kv.BaseAttributeKvEntry;
import org.thingsboard.server.common.data.kv.BasicTsKvEntry;
import org.thingsboard.server.common.data.kv.BooleanDataEntry;
import org.thingsboard.server.common.data.kv.DataType;
import org.thingsboard.server.common.data.kv.DoubleDataEntry;
import org.thingsboard.server.common.data.kv.JsonDataEntry;
import org.thingsboard.server.common.data.kv.KvEntry;
import org.thingsboard.server.common.data.kv.LongDataEntry;
import org.thingsboard.server.common.data.kv.StringDataEntry;
import org.thingsboard.server.common.data.kv.TsKvEntry;
import org.thingsboard.server.gen.transport.TransportProtos;

public class KvProtoUtil {
    private static final DataType[] dataTypeByProtoNumber;

    public static List<AttributeKvEntry> toAttributeKvList(List<TransportProtos.TsKvProto> dataList) {
        ArrayList<AttributeKvEntry> result = new ArrayList<AttributeKvEntry>(dataList.size());
        dataList.forEach(proto -> result.add((AttributeKvEntry)new BaseAttributeKvEntry(KvProtoUtil.fromTsKvProto(proto.getKv()), proto.getTs())));
        return result;
    }

    public static List<TransportProtos.TsKvProto> attrToTsKvProtos(List<AttributeKvEntry> result) {
        List<TransportProtos.TsKvProto> clientAttributes;
        if (result == null || result.isEmpty()) {
            clientAttributes = Collections.emptyList();
        } else {
            clientAttributes = new ArrayList<TransportProtos.TsKvProto>(result.size());
            for (AttributeKvEntry attrEntry : result) {
                clientAttributes.add(KvProtoUtil.toTsKvProto(attrEntry.getLastUpdateTs(), (KvEntry)attrEntry));
            }
        }
        return clientAttributes;
    }

    public static List<TransportProtos.TsKvProto> toTsKvProtoList(List<TsKvEntry> result) {
        List<TransportProtos.TsKvProto> ts;
        if (result == null || result.isEmpty()) {
            ts = Collections.emptyList();
        } else {
            ts = new ArrayList<TransportProtos.TsKvProto>(result.size());
            for (TsKvEntry attrEntry : result) {
                ts.add(KvProtoUtil.toTsKvProto(attrEntry.getTs(), (KvEntry)attrEntry));
            }
        }
        return ts;
    }

    public static List<TsKvEntry> fromTsKvProtoList(List<TransportProtos.TsKvProto> dataList) {
        ArrayList<TsKvEntry> result = new ArrayList<TsKvEntry>(dataList.size());
        dataList.forEach(proto -> result.add((TsKvEntry)new BasicTsKvEntry(proto.getTs(), KvProtoUtil.fromTsKvProto(proto.getKv()))));
        return result;
    }

    public static TransportProtos.TsKvProto toTsKvProto(long ts, KvEntry kvEntry) {
        return TransportProtos.TsKvProto.newBuilder().setTs(ts).setKv(KvProtoUtil.toKeyValueTypeProto(kvEntry)).build();
    }

    public static TransportProtos.TsKvProto toTsKvProto(long ts, KvEntry kvEntry, Long version) {
        TransportProtos.TsKvProto.Builder builder = TransportProtos.TsKvProto.newBuilder().setTs(ts).setKv(KvProtoUtil.toKeyValueTypeProto(kvEntry));
        if (version != null) {
            builder.setVersion(version);
        }
        return builder.build();
    }

    public static TsKvEntry fromTsKvProto(TransportProtos.TsKvProto proto) {
        return new BasicTsKvEntry(proto.getTs(), KvProtoUtil.fromTsKvProto(proto.getKv()), proto.hasVersion() ? Long.valueOf(proto.getVersion()) : null);
    }

    public static TransportProtos.KeyValueProto toKeyValueTypeProto(KvEntry kvEntry) {
        TransportProtos.KeyValueProto.Builder builder = TransportProtos.KeyValueProto.newBuilder();
        builder.setKey(kvEntry.getKey());
        builder.setType(KvProtoUtil.toKeyValueTypeProto(kvEntry.getDataType()));
        switch (kvEntry.getDataType()) {
            case BOOLEAN: {
                kvEntry.getBooleanValue().ifPresent(builder::setBoolV);
                break;
            }
            case LONG: {
                kvEntry.getLongValue().ifPresent(builder::setLongV);
                break;
            }
            case DOUBLE: {
                kvEntry.getDoubleValue().ifPresent(builder::setDoubleV);
                break;
            }
            case JSON: {
                kvEntry.getJsonValue().ifPresent(builder::setJsonV);
                break;
            }
            case STRING: {
                kvEntry.getStrValue().ifPresent(builder::setStringV);
            }
        }
        return builder.build();
    }

    public static KvEntry fromTsKvProto(TransportProtos.KeyValueProto proto) {
        return switch (KvProtoUtil.fromKeyValueTypeProto(proto.getType())) {
            default -> throw new IncompatibleClassChangeError();
            case DataType.BOOLEAN -> new BooleanDataEntry(proto.getKey(), Boolean.valueOf(proto.getBoolV()));
            case DataType.LONG -> new LongDataEntry(proto.getKey(), Long.valueOf(proto.getLongV()));
            case DataType.DOUBLE -> new DoubleDataEntry(proto.getKey(), Double.valueOf(proto.getDoubleV()));
            case DataType.STRING -> new StringDataEntry(proto.getKey(), proto.getStringV());
            case DataType.JSON -> new JsonDataEntry(proto.getKey(), proto.getJsonV());
        };
    }

    public static TransportProtos.TsKvProto.Builder toTsKvProtoBuilder(long ts, KvEntry kvEntry) {
        return TransportProtos.TsKvProto.newBuilder().setTs(ts).setKv(KvProtoUtil.toKeyValueTypeProto(kvEntry));
    }

    public static List<TsKvEntry> fromTsValueProtoList(String key, List<TransportProtos.TsValueProto> dataList) {
        ArrayList<TsKvEntry> result = new ArrayList<TsKvEntry>(dataList.size());
        dataList.forEach(proto -> result.add((TsKvEntry)new BasicTsKvEntry(proto.getTs(), KvProtoUtil.fromTsValueProto(key, proto))));
        return result;
    }

    public static TransportProtos.TsValueProto toTsValueProto(long ts, KvEntry attr) {
        TransportProtos.TsValueProto.Builder dataBuilder = TransportProtos.TsValueProto.newBuilder();
        dataBuilder.setTs(ts);
        dataBuilder.setType(KvProtoUtil.toKeyValueTypeProto(attr.getDataType()));
        switch (attr.getDataType()) {
            case BOOLEAN: {
                attr.getBooleanValue().ifPresent(dataBuilder::setBoolV);
                break;
            }
            case LONG: {
                attr.getLongValue().ifPresent(dataBuilder::setLongV);
                break;
            }
            case DOUBLE: {
                attr.getDoubleValue().ifPresent(dataBuilder::setDoubleV);
                break;
            }
            case JSON: {
                attr.getJsonValue().ifPresent(dataBuilder::setJsonV);
                break;
            }
            case STRING: {
                attr.getStrValue().ifPresent(dataBuilder::setStringV);
            }
        }
        return dataBuilder.build();
    }

    public static KvEntry fromTsValueProto(String key, TransportProtos.TsValueProto proto) {
        return switch (KvProtoUtil.fromKeyValueTypeProto(proto.getType())) {
            default -> throw new IncompatibleClassChangeError();
            case DataType.BOOLEAN -> new BooleanDataEntry(key, Boolean.valueOf(proto.getBoolV()));
            case DataType.LONG -> new LongDataEntry(key, Long.valueOf(proto.getLongV()));
            case DataType.DOUBLE -> new DoubleDataEntry(key, Double.valueOf(proto.getDoubleV()));
            case DataType.STRING -> new StringDataEntry(key, proto.getStringV());
            case DataType.JSON -> new JsonDataEntry(key, proto.getJsonV());
        };
    }

    public static TransportProtos.KeyValueType toKeyValueTypeProto(DataType dataType) {
        return TransportProtos.KeyValueType.forNumber(dataType.getProtoNumber());
    }

    public static DataType fromKeyValueTypeProto(TransportProtos.KeyValueType keyValueType) {
        return dataTypeByProtoNumber[keyValueType.getNumber()];
    }

    static {
        int arraySize = Arrays.stream(DataType.values()).mapToInt(DataType::getProtoNumber).max().orElse(0);
        dataTypeByProtoNumber = new DataType[arraySize + 1];
        Arrays.stream(DataType.values()).forEach(dataType -> {
            KvProtoUtil.dataTypeByProtoNumber[dataType.getProtoNumber()] = dataType;
        });
    }
}

