/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.msg.tools;

import io.github.bucket4j.Bandwidth;
import io.github.bucket4j.BandwidthBuilder;
import io.github.bucket4j.Bucket;
import io.github.bucket4j.local.LocalBucket;
import io.github.bucket4j.local.LocalBucketBuilder;
import java.time.Duration;
import java.util.List;
import lombok.Generated;
import org.thingsboard.server.common.data.limit.RateLimitEntry;
import org.thingsboard.server.common.data.limit.RateLimitUtil;

public class TbRateLimits {
    private final LocalBucket bucket;
    private final String configuration;

    public TbRateLimits(String limitsConfiguration) {
        this(limitsConfiguration, false);
    }

    public TbRateLimits(String limitsConfiguration, boolean refillIntervally) {
        List limitedApiEntries = RateLimitUtil.parseConfig((String)limitsConfiguration);
        if (limitedApiEntries.isEmpty()) {
            throw new IllegalArgumentException("Failed to parse rate limits configuration: " + limitsConfiguration);
        }
        LocalBucketBuilder localBucket = Bucket.builder();
        for (RateLimitEntry entry : limitedApiEntries) {
            BandwidthBuilder.BandwidthBuilderRefillStage bandwidthBuilder = Bandwidth.builder().capacity(entry.capacity());
            Bandwidth bandwidth = refillIntervally ? bandwidthBuilder.refillIntervally(entry.capacity(), Duration.ofSeconds(entry.durationSeconds())).build() : bandwidthBuilder.refillGreedy(entry.capacity(), Duration.ofSeconds(entry.durationSeconds())).build();
            localBucket.addLimit(bandwidth);
        }
        this.bucket = localBucket.build();
        this.configuration = limitsConfiguration;
    }

    public boolean tryConsume() {
        return this.bucket.tryConsume(1L);
    }

    public boolean tryConsume(long number) {
        return this.bucket.tryConsume(number);
    }

    @Generated
    public String getConfiguration() {
        return this.configuration;
    }
}

