/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.msg.tools;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalAdjusters;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class SchedulerUtils {
    private static final ConcurrentMap<String, ZoneId> tzMap = new ConcurrentHashMap<String, ZoneId>();

    public static ZoneId getZoneId(String tz) {
        return tzMap.computeIfAbsent(tz == null || tz.isEmpty() ? "UTC" : tz, ZoneId::of);
    }

    public static long getStartOfCurrentHour() {
        return SchedulerUtils.getStartOfCurrentHour(ZoneOffset.UTC);
    }

    public static long getStartOfCurrentHour(ZoneId zoneId) {
        return LocalDateTime.now(ZoneOffset.UTC).atZone(zoneId).truncatedTo(ChronoUnit.HOURS).toInstant().toEpochMilli();
    }

    public static long getStartOfCurrentMonth() {
        return SchedulerUtils.getStartOfCurrentMonth(ZoneOffset.UTC);
    }

    public static long getStartOfCurrentMonth(ZoneId zoneId) {
        return LocalDate.now(ZoneOffset.UTC).withDayOfMonth(1).atStartOfDay(zoneId).toInstant().toEpochMilli();
    }

    public static long getStartOfNextMonth() {
        return SchedulerUtils.getStartOfNextMonth(ZoneOffset.UTC);
    }

    public static long getStartOfNextMonth(ZoneId zoneId) {
        return LocalDate.now(ZoneOffset.UTC).with(TemporalAdjusters.firstDayOfNextMonth()).atStartOfDay(zoneId).toInstant().toEpochMilli();
    }
}

