/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.msg.rule.engine;

import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import lombok.Generated;
import org.thingsboard.server.common.data.id.DeviceId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.kv.AttributeKey;
import org.thingsboard.server.common.data.kv.AttributeKvEntry;
import org.thingsboard.server.common.msg.MsgType;
import org.thingsboard.server.common.msg.ToDeviceActorNotificationMsg;

public class DeviceAttributesEventNotificationMsg
implements ToDeviceActorNotificationMsg {
    private static final long serialVersionUID = 2422071590415277039L;
    private final TenantId tenantId;
    private final DeviceId deviceId;
    private final Set<AttributeKey> deletedKeys;
    private final String scope;
    private final List<AttributeKvEntry> values;
    private final boolean deleted;

    public static DeviceAttributesEventNotificationMsg onUpdate(TenantId tenantId, DeviceId deviceId, String scope, List<AttributeKvEntry> values) {
        return new DeviceAttributesEventNotificationMsg(tenantId, deviceId, null, scope, values, false);
    }

    public static DeviceAttributesEventNotificationMsg onDelete(TenantId tenantId, DeviceId deviceId, String scope, List<String> keys) {
        HashSet<AttributeKey> keysToNotify = new HashSet<AttributeKey>();
        keys.forEach(key -> keysToNotify.add(new AttributeKey(scope, key)));
        return new DeviceAttributesEventNotificationMsg(tenantId, deviceId, keysToNotify, null, null, true);
    }

    @Override
    public MsgType getMsgType() {
        return MsgType.DEVICE_ATTRIBUTES_UPDATE_TO_DEVICE_ACTOR_MSG;
    }

    @ConstructorProperties(value={"tenantId", "deviceId", "deletedKeys", "scope", "values", "deleted"})
    @Generated
    public DeviceAttributesEventNotificationMsg(TenantId tenantId, DeviceId deviceId, Set<AttributeKey> deletedKeys, String scope, List<AttributeKvEntry> values, boolean deleted) {
        this.tenantId = tenantId;
        this.deviceId = deviceId;
        this.deletedKeys = deletedKeys;
        this.scope = scope;
        this.values = values;
        this.deleted = deleted;
    }

    @Override
    @Generated
    public TenantId getTenantId() {
        return this.tenantId;
    }

    @Override
    @Generated
    public DeviceId getDeviceId() {
        return this.deviceId;
    }

    @Generated
    public Set<AttributeKey> getDeletedKeys() {
        return this.deletedKeys;
    }

    @Generated
    public String getScope() {
        return this.scope;
    }

    @Generated
    public List<AttributeKvEntry> getValues() {
        return this.values;
    }

    @Generated
    public boolean isDeleted() {
        return this.deleted;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DeviceAttributesEventNotificationMsg)) {
            return false;
        }
        DeviceAttributesEventNotificationMsg other = (DeviceAttributesEventNotificationMsg)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isDeleted() != other.isDeleted()) {
            return false;
        }
        TenantId this$tenantId = this.getTenantId();
        TenantId other$tenantId = other.getTenantId();
        if (this$tenantId == null ? other$tenantId != null : !this$tenantId.equals(other$tenantId)) {
            return false;
        }
        DeviceId this$deviceId = this.getDeviceId();
        DeviceId other$deviceId = other.getDeviceId();
        if (this$deviceId == null ? other$deviceId != null : !this$deviceId.equals(other$deviceId)) {
            return false;
        }
        Set<AttributeKey> this$deletedKeys = this.getDeletedKeys();
        Set<AttributeKey> other$deletedKeys = other.getDeletedKeys();
        if (this$deletedKeys == null ? other$deletedKeys != null : !((Object)this$deletedKeys).equals(other$deletedKeys)) {
            return false;
        }
        String this$scope = this.getScope();
        String other$scope = other.getScope();
        if (this$scope == null ? other$scope != null : !this$scope.equals(other$scope)) {
            return false;
        }
        List<AttributeKvEntry> this$values = this.getValues();
        List<AttributeKvEntry> other$values = other.getValues();
        return !(this$values == null ? other$values != null : !((Object)this$values).equals(other$values));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof DeviceAttributesEventNotificationMsg;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isDeleted() ? 79 : 97);
        TenantId $tenantId = this.getTenantId();
        result = result * 59 + ($tenantId == null ? 43 : $tenantId.hashCode());
        DeviceId $deviceId = this.getDeviceId();
        result = result * 59 + ($deviceId == null ? 43 : $deviceId.hashCode());
        Set<AttributeKey> $deletedKeys = this.getDeletedKeys();
        result = result * 59 + ($deletedKeys == null ? 43 : ((Object)$deletedKeys).hashCode());
        String $scope = this.getScope();
        result = result * 59 + ($scope == null ? 43 : $scope.hashCode());
        List<AttributeKvEntry> $values = this.getValues();
        result = result * 59 + ($values == null ? 43 : ((Object)$values).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "DeviceAttributesEventNotificationMsg(tenantId=" + String.valueOf(this.getTenantId()) + ", deviceId=" + String.valueOf(this.getDeviceId()) + ", deletedKeys=" + String.valueOf(this.getDeletedKeys()) + ", scope=" + this.getScope() + ", values=" + String.valueOf(this.getValues()) + ", deleted=" + this.isDeleted() + ")";
    }
}

