/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.msg.queue;

import com.google.common.util.concurrent.SettableFuture;
import java.util.UUID;
import org.thingsboard.server.common.data.id.EntityId;

public interface TbCallback {
    public static final TbCallback EMPTY = new TbCallback(){

        @Override
        public void onSuccess() {
        }

        @Override
        public void onFailure(Throwable t) {
        }
    };

    default public UUID getId() {
        return EntityId.NULL_UUID;
    }

    public void onSuccess();

    public void onFailure(Throwable var1);

    public static <V> TbCallback wrap(final SettableFuture<V> future) {
        return new TbCallback(){

            @Override
            public void onSuccess() {
                future.set(null);
            }

            @Override
            public void onFailure(Throwable t) {
                future.setException(t);
            }
        };
    }
}

