/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.msg.queue;

import com.fasterxml.jackson.core.JsonProcessingException;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.server.common.data.id.RuleChainId;
import org.thingsboard.server.common.data.id.RuleNodeId;
import org.thingsboard.server.common.data.rule.RuleNode;
import org.thingsboard.server.common.msg.queue.RuleEngineException;

public class RuleNodeException
extends RuleEngineException {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RuleNodeException.class);
    private static final long serialVersionUID = -1776681087370749776L;
    public static final String UNKNOWN = "Unknown";
    private final String ruleChainName;
    private final String ruleNodeName;
    private final RuleChainId ruleChainId;
    private final RuleNodeId ruleNodeId;

    public RuleNodeException(String message, String ruleChainName, RuleNode ruleNode) {
        super(message);
        this.ruleChainName = ruleChainName;
        if (ruleNode != null) {
            this.ruleNodeName = ruleNode.getName();
            this.ruleChainId = ruleNode.getRuleChainId();
            this.ruleNodeId = ruleNode.getId();
        } else {
            this.ruleNodeName = UNKNOWN;
            this.ruleChainId = new RuleChainId(RuleChainId.NULL_UUID);
            this.ruleNodeId = new RuleNodeId(RuleNodeId.NULL_UUID);
        }
    }

    @Override
    public String toJsonString(int maxMessageLength) {
        try {
            return mapper.writeValueAsString((Object)mapper.createObjectNode().put("ruleNodeId", this.ruleNodeId.toString()).put("ruleChainId", this.ruleChainId.toString()).put("ruleNodeName", this.ruleNodeName).put("ruleChainName", this.ruleChainName).put("message", this.truncateIfNecessary(this.getMessage(), maxMessageLength)));
        }
        catch (JsonProcessingException e) {
            log.warn("Failed to serialize exception ", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    @Generated
    public String getRuleChainName() {
        return this.ruleChainName;
    }

    @Generated
    public String getRuleNodeName() {
        return this.ruleNodeName;
    }

    @Generated
    public RuleChainId getRuleChainId() {
        return this.ruleChainId;
    }

    @Generated
    public RuleNodeId getRuleNodeId() {
        return this.ruleNodeId;
    }
}

