/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.msg;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArrayList;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.StringUtils;
import org.thingsboard.server.common.data.id.CalculatedFieldId;
import org.thingsboard.server.common.data.id.CustomerId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.EntityIdFactory;
import org.thingsboard.server.common.data.id.RuleChainId;
import org.thingsboard.server.common.data.id.RuleNodeId;
import org.thingsboard.server.common.data.msg.TbMsgType;
import org.thingsboard.server.common.msg.TbMsgDataType;
import org.thingsboard.server.common.msg.TbMsgMetaData;
import org.thingsboard.server.common.msg.TbMsgProcessingCtx;
import org.thingsboard.server.common.msg.TbMsgProcessingStackItem;
import org.thingsboard.server.common.msg.gen.MsgProtos;
import org.thingsboard.server.common.msg.queue.TbMsgCallback;

public final class TbMsg
implements Serializable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TbMsg.class);
    public static final String EMPTY_JSON_OBJECT = "{}";
    public static final String EMPTY_JSON_ARRAY = "[]";
    public static final String EMPTY_STRING = "";
    private final String queueName;
    private final UUID id;
    private final long ts;
    private final String type;
    private final TbMsgType internalType;
    private final EntityId originator;
    private final CustomerId customerId;
    private final TbMsgMetaData metaData;
    private final TbMsgDataType dataType;
    private final String data;
    private final RuleChainId ruleChainId;
    private final RuleNodeId ruleNodeId;
    private final UUID correlationId;
    private final Integer partition;
    private final List<CalculatedFieldId> previousCalculatedFieldIds;
    @JsonIgnore
    private final TbMsgProcessingCtx ctx;
    @JsonIgnore
    private final transient TbMsgCallback callback;

    public static TbMsgBuilder newMsg() {
        return new TbMsgBuilder();
    }

    public TbMsgBuilder transform() {
        return new TbMsgTransformer(this);
    }

    public TbMsgBuilder copy() {
        return new TbMsgBuilder(this);
    }

    public TbMsg transform(String queueName) {
        return this.transform().queueName(queueName).resetRuleNodeId().build();
    }

    public static TbMsg newMsg(TbMsg tbMsg, String queueName, RuleChainId ruleChainId, RuleNodeId ruleNodeId) {
        return tbMsg.transform().id(UUID.randomUUID()).queueName(queueName).metaData(tbMsg.getMetaData()).ruleChainId(ruleChainId).ruleNodeId(ruleNodeId).callback(TbMsgCallback.EMPTY).build();
    }

    public TbMsg copyWithNewCtx() {
        return this.copy().ctx(this.ctx.copy()).callback(TbMsgCallback.EMPTY).build();
    }

    private TbMsg(String queueName, UUID id, long ts, TbMsgType internalType, String type, EntityId originator, CustomerId customerId, TbMsgMetaData metaData, TbMsgDataType dataType, String data, RuleChainId ruleChainId, RuleNodeId ruleNodeId, UUID correlationId, Integer partition, List<CalculatedFieldId> previousCalculatedFieldIds, TbMsgProcessingCtx ctx, TbMsgCallback callback) {
        this.id = id != null ? id : UUID.randomUUID();
        this.queueName = queueName;
        this.ts = ts > 0L ? ts : System.currentTimeMillis();
        this.internalType = internalType != null ? internalType : this.getInternalType(type);
        this.type = type != null ? type : this.internalType.name();
        this.originator = originator;
        this.customerId = customerId == null || customerId.isNullUid() ? (originator != null && originator.getEntityType() == EntityType.CUSTOMER ? new CustomerId(originator.getId()) : null) : customerId;
        this.metaData = metaData;
        this.dataType = dataType != null ? dataType : TbMsgDataType.JSON;
        this.data = data;
        this.ruleChainId = ruleChainId;
        this.ruleNodeId = ruleNodeId;
        this.correlationId = correlationId;
        this.partition = partition;
        this.previousCalculatedFieldIds = previousCalculatedFieldIds != null ? new CopyOnWriteArrayList<CalculatedFieldId>(previousCalculatedFieldIds) : new CopyOnWriteArrayList();
        this.ctx = ctx != null ? ctx : new TbMsgProcessingCtx();
        this.callback = Objects.requireNonNullElse(callback, TbMsgCallback.EMPTY);
    }

    public static MsgProtos.TbMsgProto toProto(TbMsg msg) {
        MsgProtos.TbMsgProto.Builder builder = MsgProtos.TbMsgProto.newBuilder();
        builder.setId(msg.getId().toString());
        builder.setTs(msg.getTs());
        builder.setType(msg.getType());
        builder.setEntityType(msg.getOriginator().getEntityType().name());
        builder.setEntityIdMSB(msg.getOriginator().getId().getMostSignificantBits());
        builder.setEntityIdLSB(msg.getOriginator().getId().getLeastSignificantBits());
        if (msg.getCustomerId() != null) {
            builder.setCustomerIdMSB(msg.getCustomerId().getId().getMostSignificantBits());
            builder.setCustomerIdLSB(msg.getCustomerId().getId().getLeastSignificantBits());
        }
        if (msg.getRuleChainId() != null) {
            builder.setRuleChainIdMSB(msg.getRuleChainId().getId().getMostSignificantBits());
            builder.setRuleChainIdLSB(msg.getRuleChainId().getId().getLeastSignificantBits());
        }
        if (msg.getRuleNodeId() != null) {
            builder.setRuleNodeIdMSB(msg.getRuleNodeId().getId().getMostSignificantBits());
            builder.setRuleNodeIdLSB(msg.getRuleNodeId().getId().getLeastSignificantBits());
        }
        if (msg.getMetaData() != null) {
            builder.setMetaData(MsgProtos.TbMsgMetaDataProto.newBuilder().putAllData(msg.getMetaData().getData()).build());
        }
        builder.setDataType(msg.getDataType().ordinal());
        builder.setData(msg.getData());
        if (msg.getCorrelationId() != null) {
            builder.setCorrelationIdMSB(msg.getCorrelationId().getMostSignificantBits());
            builder.setCorrelationIdLSB(msg.getCorrelationId().getLeastSignificantBits());
        }
        if (msg.getPartition() != null) {
            builder.setPartition(msg.getPartition());
        }
        if (msg.getPreviousCalculatedFieldIds() != null) {
            for (CalculatedFieldId calculatedFieldId : msg.getPreviousCalculatedFieldIds()) {
                MsgProtos.CalculatedFieldIdProto calculatedFieldIdProto = MsgProtos.CalculatedFieldIdProto.newBuilder().setCalculatedFieldIdMSB(calculatedFieldId.getId().getMostSignificantBits()).setCalculatedFieldIdLSB(calculatedFieldId.getId().getLeastSignificantBits()).build();
                builder.addCalculatedFields(calculatedFieldIdProto);
            }
        }
        builder.setCtx(msg.ctx.toProto());
        return builder.build();
    }

    @Deprecated(forRemoval=true, since="4.1")
    public static TbMsg fromProto(String queueName, MsgProtos.TbMsgProto proto, ByteString data, TbMsgCallback callback) {
        try {
            if (!data.isEmpty()) {
                proto = MsgProtos.TbMsgProto.parseFrom(data);
            }
        }
        catch (InvalidProtocolBufferException e) {
            throw new IllegalStateException("Could not parse protobuf for TbMsg", e);
        }
        return TbMsg.fromProto(queueName, proto, callback);
    }

    public static TbMsg fromProto(String queueName, MsgProtos.TbMsgProto proto, TbMsgCallback callback) {
        TbMsgMetaData metaData = new TbMsgMetaData(proto.getMetaData().getDataMap());
        EntityId entityId = EntityIdFactory.getByTypeAndUuid((String)proto.getEntityType(), (UUID)new UUID(proto.getEntityIdMSB(), proto.getEntityIdLSB()));
        CustomerId customerId = null;
        RuleChainId ruleChainId = null;
        RuleNodeId ruleNodeId = null;
        UUID correlationId = null;
        Integer partition = null;
        CopyOnWriteArrayList<CalculatedFieldId> calculatedFieldIds = new CopyOnWriteArrayList<CalculatedFieldId>();
        if (proto.getCustomerIdMSB() != 0L && proto.getCustomerIdLSB() != 0L) {
            customerId = new CustomerId(new UUID(proto.getCustomerIdMSB(), proto.getCustomerIdLSB()));
        }
        if (proto.getRuleChainIdMSB() != 0L && proto.getRuleChainIdLSB() != 0L) {
            ruleChainId = new RuleChainId(new UUID(proto.getRuleChainIdMSB(), proto.getRuleChainIdLSB()));
        }
        if (proto.getRuleNodeIdMSB() != 0L && proto.getRuleNodeIdLSB() != 0L) {
            ruleNodeId = new RuleNodeId(new UUID(proto.getRuleNodeIdMSB(), proto.getRuleNodeIdLSB()));
        }
        if (proto.getCorrelationIdMSB() != 0L && proto.getCorrelationIdLSB() != 0L) {
            correlationId = new UUID(proto.getCorrelationIdMSB(), proto.getCorrelationIdLSB());
            partition = proto.getPartition();
        }
        for (MsgProtos.CalculatedFieldIdProto cfIdProto : proto.getCalculatedFieldsList()) {
            CalculatedFieldId calculatedFieldId = new CalculatedFieldId(new UUID(cfIdProto.getCalculatedFieldIdMSB(), cfIdProto.getCalculatedFieldIdLSB()));
            calculatedFieldIds.add(calculatedFieldId);
        }
        TbMsgProcessingCtx ctx = TbMsgProcessingCtx.fromProto(proto.getCtx());
        TbMsgDataType dataType = TbMsgDataType.values()[proto.getDataType()];
        return new TbMsg(queueName, UUID.fromString(proto.getId()), proto.getTs(), null, proto.getType(), entityId, customerId, metaData, dataType, proto.getData(), ruleChainId, ruleNodeId, correlationId, partition, calculatedFieldIds, ctx, callback);
    }

    public int getAndIncrementRuleNodeCounter() {
        return this.ctx.getAndIncrementRuleNodeCounter();
    }

    public TbMsgCallback getCallback() {
        return Objects.requireNonNullElse(this.callback, TbMsgCallback.EMPTY);
    }

    public void pushToStack(RuleChainId ruleChainId, RuleNodeId ruleNodeId) {
        this.ctx.push(ruleChainId, ruleNodeId);
    }

    public TbMsgProcessingStackItem popFormStack() {
        return this.ctx.pop();
    }

    public boolean isValid() {
        return this.getCallback().isMsgValid();
    }

    public long getMetaDataTs() {
        String tsStr = this.metaData.getValue("ts");
        if (!StringUtils.isEmpty((String)tsStr)) {
            try {
                return Long.parseLong(tsStr);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return this.ts;
    }

    private TbMsgType getInternalType(String type) {
        if (type != null) {
            try {
                return TbMsgType.valueOf((String)type);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return TbMsgType.NA;
    }

    public boolean isTypeOf(TbMsgType tbMsgType) {
        return this.internalType.equals((Object)tbMsgType);
    }

    public boolean isTypeOneOf(TbMsgType ... types) {
        for (TbMsgType type : types) {
            if (!this.isTypeOf(type)) continue;
            return true;
        }
        return false;
    }

    @Generated
    public String getQueueName() {
        return this.queueName;
    }

    @Generated
    public UUID getId() {
        return this.id;
    }

    @Generated
    public long getTs() {
        return this.ts;
    }

    @Generated
    public String getType() {
        return this.type;
    }

    @Generated
    public TbMsgType getInternalType() {
        return this.internalType;
    }

    @Generated
    public EntityId getOriginator() {
        return this.originator;
    }

    @Generated
    public CustomerId getCustomerId() {
        return this.customerId;
    }

    @Generated
    public TbMsgMetaData getMetaData() {
        return this.metaData;
    }

    @Generated
    public TbMsgDataType getDataType() {
        return this.dataType;
    }

    @Generated
    public String getData() {
        return this.data;
    }

    @Generated
    public RuleChainId getRuleChainId() {
        return this.ruleChainId;
    }

    @Generated
    public RuleNodeId getRuleNodeId() {
        return this.ruleNodeId;
    }

    @Generated
    public UUID getCorrelationId() {
        return this.correlationId;
    }

    @Generated
    public Integer getPartition() {
        return this.partition;
    }

    @Generated
    public List<CalculatedFieldId> getPreviousCalculatedFieldIds() {
        return this.previousCalculatedFieldIds;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TbMsg)) {
            return false;
        }
        TbMsg other = (TbMsg)o;
        if (this.getTs() != other.getTs()) {
            return false;
        }
        Integer this$partition = this.getPartition();
        Integer other$partition = other.getPartition();
        if (this$partition == null ? other$partition != null : !((Object)this$partition).equals(other$partition)) {
            return false;
        }
        String this$queueName = this.getQueueName();
        String other$queueName = other.getQueueName();
        if (this$queueName == null ? other$queueName != null : !this$queueName.equals(other$queueName)) {
            return false;
        }
        UUID this$id = this.getId();
        UUID other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        TbMsgType this$internalType = this.getInternalType();
        TbMsgType other$internalType = other.getInternalType();
        if (this$internalType == null ? other$internalType != null : !this$internalType.equals(other$internalType)) {
            return false;
        }
        EntityId this$originator = this.getOriginator();
        EntityId other$originator = other.getOriginator();
        if (this$originator == null ? other$originator != null : !this$originator.equals(other$originator)) {
            return false;
        }
        CustomerId this$customerId = this.getCustomerId();
        CustomerId other$customerId = other.getCustomerId();
        if (this$customerId == null ? other$customerId != null : !this$customerId.equals(other$customerId)) {
            return false;
        }
        TbMsgMetaData this$metaData = this.getMetaData();
        TbMsgMetaData other$metaData = other.getMetaData();
        if (this$metaData == null ? other$metaData != null : !((Object)this$metaData).equals(other$metaData)) {
            return false;
        }
        TbMsgDataType this$dataType = this.getDataType();
        TbMsgDataType other$dataType = other.getDataType();
        if (this$dataType == null ? other$dataType != null : !((Object)((Object)this$dataType)).equals((Object)other$dataType)) {
            return false;
        }
        String this$data = this.getData();
        String other$data = other.getData();
        if (this$data == null ? other$data != null : !this$data.equals(other$data)) {
            return false;
        }
        RuleChainId this$ruleChainId = this.getRuleChainId();
        RuleChainId other$ruleChainId = other.getRuleChainId();
        if (this$ruleChainId == null ? other$ruleChainId != null : !this$ruleChainId.equals(other$ruleChainId)) {
            return false;
        }
        RuleNodeId this$ruleNodeId = this.getRuleNodeId();
        RuleNodeId other$ruleNodeId = other.getRuleNodeId();
        if (this$ruleNodeId == null ? other$ruleNodeId != null : !this$ruleNodeId.equals(other$ruleNodeId)) {
            return false;
        }
        UUID this$correlationId = this.getCorrelationId();
        UUID other$correlationId = other.getCorrelationId();
        if (this$correlationId == null ? other$correlationId != null : !((Object)this$correlationId).equals(other$correlationId)) {
            return false;
        }
        List<CalculatedFieldId> this$previousCalculatedFieldIds = this.getPreviousCalculatedFieldIds();
        List<CalculatedFieldId> other$previousCalculatedFieldIds = other.getPreviousCalculatedFieldIds();
        if (this$previousCalculatedFieldIds == null ? other$previousCalculatedFieldIds != null : !((Object)this$previousCalculatedFieldIds).equals(other$previousCalculatedFieldIds)) {
            return false;
        }
        TbMsgProcessingCtx this$ctx = this.ctx;
        TbMsgProcessingCtx other$ctx = other.ctx;
        return !(this$ctx == null ? other$ctx != null : !this$ctx.equals(other$ctx));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $ts = this.getTs();
        result = result * 59 + (int)($ts >>> 32 ^ $ts);
        Integer $partition = this.getPartition();
        result = result * 59 + ($partition == null ? 43 : ((Object)$partition).hashCode());
        String $queueName = this.getQueueName();
        result = result * 59 + ($queueName == null ? 43 : $queueName.hashCode());
        UUID $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        TbMsgType $internalType = this.getInternalType();
        result = result * 59 + ($internalType == null ? 43 : $internalType.hashCode());
        EntityId $originator = this.getOriginator();
        result = result * 59 + ($originator == null ? 43 : $originator.hashCode());
        CustomerId $customerId = this.getCustomerId();
        result = result * 59 + ($customerId == null ? 43 : $customerId.hashCode());
        TbMsgMetaData $metaData = this.getMetaData();
        result = result * 59 + ($metaData == null ? 43 : ((Object)$metaData).hashCode());
        TbMsgDataType $dataType = this.getDataType();
        result = result * 59 + ($dataType == null ? 43 : ((Object)((Object)$dataType)).hashCode());
        String $data = this.getData();
        result = result * 59 + ($data == null ? 43 : $data.hashCode());
        RuleChainId $ruleChainId = this.getRuleChainId();
        result = result * 59 + ($ruleChainId == null ? 43 : $ruleChainId.hashCode());
        RuleNodeId $ruleNodeId = this.getRuleNodeId();
        result = result * 59 + ($ruleNodeId == null ? 43 : $ruleNodeId.hashCode());
        UUID $correlationId = this.getCorrelationId();
        result = result * 59 + ($correlationId == null ? 43 : ((Object)$correlationId).hashCode());
        List<CalculatedFieldId> $previousCalculatedFieldIds = this.getPreviousCalculatedFieldIds();
        result = result * 59 + ($previousCalculatedFieldIds == null ? 43 : ((Object)$previousCalculatedFieldIds).hashCode());
        TbMsgProcessingCtx $ctx = this.ctx;
        result = result * 59 + ($ctx == null ? 43 : $ctx.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "TbMsg(queueName=" + this.getQueueName() + ", id=" + String.valueOf(this.getId()) + ", ts=" + this.getTs() + ", type=" + this.getType() + ", internalType=" + String.valueOf(this.getInternalType()) + ", originator=" + String.valueOf(this.getOriginator()) + ", customerId=" + String.valueOf(this.getCustomerId()) + ", metaData=" + String.valueOf(this.getMetaData()) + ", dataType=" + String.valueOf((Object)this.getDataType()) + ", data=" + this.getData() + ", ruleChainId=" + String.valueOf(this.getRuleChainId()) + ", ruleNodeId=" + String.valueOf(this.getRuleNodeId()) + ", correlationId=" + String.valueOf(this.getCorrelationId()) + ", partition=" + this.getPartition() + ", previousCalculatedFieldIds=" + String.valueOf(this.getPreviousCalculatedFieldIds()) + ", ctx=" + String.valueOf(this.ctx) + ", callback=" + String.valueOf(this.getCallback()) + ")";
    }

    public static class TbMsgBuilder {
        protected String queueName;
        protected UUID id;
        protected long ts;
        protected String type;
        protected TbMsgType internalType;
        protected EntityId originator;
        protected CustomerId customerId;
        protected TbMsgMetaData metaData;
        protected TbMsgDataType dataType;
        protected String data;
        protected RuleChainId ruleChainId;
        protected RuleNodeId ruleNodeId;
        protected UUID correlationId;
        protected Integer partition;
        protected List<CalculatedFieldId> previousCalculatedFieldIds;
        protected TbMsgProcessingCtx ctx;
        protected TbMsgCallback callback;

        TbMsgBuilder() {
        }

        TbMsgBuilder(TbMsg tbMsg) {
            this.queueName = tbMsg.queueName;
            this.id = tbMsg.id;
            this.ts = tbMsg.ts;
            this.type = tbMsg.type;
            this.internalType = tbMsg.internalType;
            this.originator = tbMsg.originator;
            this.customerId = tbMsg.customerId;
            this.metaData = tbMsg.metaData;
            this.dataType = tbMsg.dataType;
            this.data = tbMsg.data;
            this.ruleChainId = tbMsg.ruleChainId;
            this.ruleNodeId = tbMsg.ruleNodeId;
            this.correlationId = tbMsg.correlationId;
            this.partition = tbMsg.partition;
            this.previousCalculatedFieldIds = tbMsg.previousCalculatedFieldIds;
            this.ctx = tbMsg.ctx;
            this.callback = tbMsg.callback;
        }

        public TbMsgBuilder queueName(String queueName) {
            this.queueName = queueName;
            return this;
        }

        public TbMsgBuilder id(UUID id) {
            this.id = id;
            return this;
        }

        public TbMsgBuilder ts(long ts) {
            this.ts = ts;
            return this;
        }

        @Deprecated
        public TbMsgBuilder type(String type) {
            this.type = type;
            this.internalType = null;
            return this;
        }

        public TbMsgBuilder type(TbMsgType internalType) {
            this.internalType = internalType;
            this.type = internalType.name();
            return this;
        }

        public TbMsgBuilder originator(EntityId originator) {
            this.originator = originator;
            return this;
        }

        public TbMsgBuilder customerId(CustomerId customerId) {
            this.customerId = customerId;
            return this;
        }

        public TbMsgBuilder metaData(TbMsgMetaData metaData) {
            this.metaData = metaData;
            return this;
        }

        public TbMsgBuilder copyMetaData(TbMsgMetaData metaData) {
            this.metaData = metaData.copy();
            return this;
        }

        public TbMsgBuilder dataType(TbMsgDataType dataType) {
            this.dataType = dataType;
            return this;
        }

        public TbMsgBuilder data(String data) {
            this.data = data;
            return this;
        }

        public TbMsgBuilder ruleChainId(RuleChainId ruleChainId) {
            this.ruleChainId = ruleChainId;
            return this;
        }

        public TbMsgBuilder ruleNodeId(RuleNodeId ruleNodeId) {
            this.ruleNodeId = ruleNodeId;
            return this;
        }

        public TbMsgBuilder resetRuleNodeId() {
            return this.ruleNodeId(null);
        }

        public TbMsgBuilder correlationId(UUID correlationId) {
            this.correlationId = correlationId;
            return this;
        }

        public TbMsgBuilder partition(Integer partition) {
            this.partition = partition;
            return this;
        }

        public TbMsgBuilder previousCalculatedFieldIds(List<CalculatedFieldId> previousCalculatedFieldIds) {
            this.previousCalculatedFieldIds = new CopyOnWriteArrayList<CalculatedFieldId>(previousCalculatedFieldIds);
            return this;
        }

        public TbMsgBuilder ctx(TbMsgProcessingCtx ctx) {
            this.ctx = ctx;
            return this;
        }

        public TbMsgBuilder callback(TbMsgCallback callback) {
            this.callback = callback;
            return this;
        }

        public TbMsg build() {
            return new TbMsg(this.queueName, this.id, this.ts, this.internalType, this.type, this.originator, this.customerId, this.metaData, this.dataType, this.data, this.ruleChainId, this.ruleNodeId, this.correlationId, this.partition, this.previousCalculatedFieldIds, this.ctx, this.callback);
        }

        public String toString() {
            return "TbMsg.TbMsgBuilder(queueName=" + this.queueName + ", id=" + String.valueOf(this.id) + ", ts=" + this.ts + ", type=" + this.type + ", internalType=" + String.valueOf(this.internalType) + ", originator=" + String.valueOf(this.originator) + ", customerId=" + String.valueOf(this.customerId) + ", metaData=" + String.valueOf(this.metaData) + ", dataType=" + String.valueOf((Object)this.dataType) + ", data=" + this.data + ", ruleChainId=" + String.valueOf(this.ruleChainId) + ", ruleNodeId=" + String.valueOf(this.ruleNodeId) + ", correlationId=" + String.valueOf(this.correlationId) + ", partition=" + this.partition + ", previousCalculatedFields=" + String.valueOf(this.previousCalculatedFieldIds) + ", ctx=" + String.valueOf(this.ctx) + ", callback=" + String.valueOf(this.callback) + ")";
        }
    }

    public static class TbMsgTransformer
    extends TbMsgBuilder {
        TbMsgTransformer(TbMsg tbMsg) {
            super(tbMsg);
        }

        @Override
        public TbMsgTransformer metaData(TbMsgMetaData metaData) {
            this.metaData = metaData.copy();
            return this;
        }

        @Override
        public TbMsgBuilder ruleChainId(RuleChainId ruleChainId) {
            this.ruleChainId = ruleChainId;
            this.ruleNodeId = null;
            return this;
        }

        @Override
        public TbMsg build() {
            if (this.ctx != null) {
                this.ctx = this.ctx.copy();
            }
            return super.build();
        }
    }
}

