/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.msg;

import lombok.Generated;
import org.bouncycastle.crypto.digests.SHA3Digest;
import org.bouncycastle.pqc.legacy.math.linearalgebra.ByteUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EncryptionUtil {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EncryptionUtil.class);

    private EncryptionUtil() {
    }

    public static String certTrimNewLines(String input) {
        return input.replaceAll("-----BEGIN CERTIFICATE-----", "").replaceAll("\n", "").replaceAll("\r", "").replaceAll("-----END CERTIFICATE-----", "");
    }

    public static String certTrimNewLinesForChainInDeviceProfile(String input) {
        return input.replaceAll("\n", "").replaceAll("\r", "").replaceAll("-----BEGIN CERTIFICATE-----", "-----BEGIN CERTIFICATE-----\n").replaceAll("-----END CERTIFICATE-----", "\n-----END CERTIFICATE-----\n").trim();
    }

    public static String pubkTrimNewLines(String input) {
        return input.replaceAll("-----BEGIN PUBLIC KEY-----", "").replaceAll("\n", "").replaceAll("\r", "").replaceAll("-----END PUBLIC KEY-----", "");
    }

    public static String prikTrimNewLines(String input) {
        return input.replaceAll("-----BEGIN EC PRIVATE KEY-----", "").replaceAll("\n", "").replaceAll("\r", "").replaceAll("-----END EC PRIVATE KEY-----", "");
    }

    public static String getSha3Hash(String data) {
        String trimmedData = EncryptionUtil.certTrimNewLines(data);
        byte[] dataBytes = trimmedData.getBytes();
        SHA3Digest md = new SHA3Digest(256);
        md.reset();
        md.update(dataBytes, 0, dataBytes.length);
        byte[] hashedBytes = new byte[32];
        md.doFinal(hashedBytes, 0);
        String sha3Hash = ByteUtils.toHexString((byte[])hashedBytes);
        return sha3Hash;
    }

    public static String getSha3Hash(String delim, String ... tokens) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (String token : tokens) {
            if (token == null || token.isEmpty()) continue;
            if (first) {
                first = false;
            } else {
                sb.append(delim);
            }
            sb.append(token);
        }
        return EncryptionUtil.getSha3Hash(sb.toString());
    }
}

