/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.msg.queue;

import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.thingsboard.server.common.data.id.TenantId;

public class TopicPartitionInfo {
    private final String topic;
    private final TenantId tenantId;
    private final Integer partition;
    private final boolean useInternalPartition;
    private final String fullTopicName;
    private final boolean myPartition;

    public TopicPartitionInfo(String topic, TenantId tenantId, Integer partition, boolean useInternalPartition, boolean myPartition) {
        this.topic = topic;
        this.tenantId = tenantId;
        this.partition = partition;
        this.useInternalPartition = useInternalPartition;
        this.myPartition = myPartition;
        Object tmp = topic;
        if (tenantId != null && !tenantId.isNullUid()) {
            tmp = (String)tmp + ".isolated." + tenantId.getId().toString();
        }
        if (partition != null && !useInternalPartition) {
            tmp = (String)tmp + "." + partition;
        }
        this.fullTopicName = tmp;
    }

    public TopicPartitionInfo(String topic, TenantId tenantId, Integer partition, boolean myPartition) {
        this(topic, tenantId, partition, false, myPartition);
    }

    public TopicPartitionInfo newByTopic(String topic) {
        return new TopicPartitionInfo(topic, this.tenantId, this.partition, this.useInternalPartition, this.myPartition);
    }

    public String getTopic() {
        return this.topic;
    }

    public Optional<TenantId> getTenantId() {
        return Optional.ofNullable(this.tenantId);
    }

    public Optional<Integer> getPartition() {
        return Optional.ofNullable(this.partition);
    }

    public TopicPartitionInfo withTopic(String topic) {
        return new TopicPartitionInfo(topic, this.tenantId, this.partition, this.useInternalPartition, this.myPartition);
    }

    public static Set<TopicPartitionInfo> withTopic(Set<TopicPartitionInfo> partitions, String topic) {
        return partitions.stream().map(tpi -> tpi.withTopic(topic)).collect(Collectors.toSet());
    }

    public TopicPartitionInfo withUseInternalPartition(boolean useInternalPartition) {
        return new TopicPartitionInfo(this.topic, this.tenantId, this.partition, useInternalPartition, this.myPartition);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TopicPartitionInfo that = (TopicPartitionInfo)o;
        return Objects.equals(this.partition, that.partition) && this.fullTopicName.equals(that.fullTopicName);
    }

    public int hashCode() {
        return Objects.hash(this.fullTopicName, this.partition);
    }

    public String toString() {
        Object str = this.fullTopicName;
        if (this.useInternalPartition) {
            str = (String)str + "[" + this.partition + "]";
        }
        return str;
    }

    public static TopicPartitionInfoBuilder builder() {
        return new TopicPartitionInfoBuilder();
    }

    public boolean isUseInternalPartition() {
        return this.useInternalPartition;
    }

    public String getFullTopicName() {
        return this.fullTopicName;
    }

    public boolean isMyPartition() {
        return this.myPartition;
    }

    public static class TopicPartitionInfoBuilder {
        private String topic;
        private TenantId tenantId;
        private Integer partition;
        private boolean useInternalPartition;
        private boolean myPartition;

        TopicPartitionInfoBuilder() {
        }

        public TopicPartitionInfoBuilder topic(String topic) {
            this.topic = topic;
            return this;
        }

        public TopicPartitionInfoBuilder tenantId(TenantId tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        public TopicPartitionInfoBuilder partition(Integer partition) {
            this.partition = partition;
            return this;
        }

        public TopicPartitionInfoBuilder useInternalPartition(boolean useInternalPartition) {
            this.useInternalPartition = useInternalPartition;
            return this;
        }

        public TopicPartitionInfoBuilder myPartition(boolean myPartition) {
            this.myPartition = myPartition;
            return this;
        }

        public TopicPartitionInfo build() {
            return new TopicPartitionInfo(this.topic, this.tenantId, this.partition, this.useInternalPartition, this.myPartition);
        }

        public String toString() {
            return "TopicPartitionInfo.TopicPartitionInfoBuilder(topic=" + this.topic + ", tenantId=" + String.valueOf(this.tenantId) + ", partition=" + this.partition + ", useInternalPartition=" + this.useInternalPartition + ", myPartition=" + this.myPartition + ")";
        }
    }
}

