/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.msg.queue;

import java.util.Set;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.msg.MsgType;
import org.thingsboard.server.common.msg.TbActorStopReason;
import org.thingsboard.server.common.msg.TbMsg;
import org.thingsboard.server.common.msg.TbRuleEngineActorMsg;
import org.thingsboard.server.common.msg.queue.RuleEngineException;

public final class QueueToRuleEngineMsg
extends TbRuleEngineActorMsg {
    private final TenantId tenantId;
    private final Set<String> relationTypes;
    private final String failureMessage;

    public QueueToRuleEngineMsg(TenantId tenantId, TbMsg tbMsg, Set<String> relationTypes, String failureMessage) {
        super(tbMsg);
        this.tenantId = tenantId;
        this.relationTypes = relationTypes;
        this.failureMessage = failureMessage;
    }

    @Override
    public MsgType getMsgType() {
        return MsgType.QUEUE_TO_RULE_ENGINE_MSG;
    }

    @Override
    public void onTbActorStopped(TbActorStopReason reason) {
        String message = this.msg.getRuleChainId() != null ? (reason == TbActorStopReason.STOPPED ? String.format("Rule chain [%s] stopped", this.msg.getRuleChainId().getId()) : String.format("Failed to initialize rule chain [%s]!", this.msg.getRuleChainId().getId())) : (reason == TbActorStopReason.STOPPED ? "Rule chain stopped" : "Failed to initialize rule chain!");
        this.msg.getCallback().onFailure(new RuleEngineException(message));
    }

    public boolean isTellNext() {
        return this.relationTypes != null && !this.relationTypes.isEmpty();
    }

    @Override
    public String toString() {
        return "QueueToRuleEngineMsg(super=" + super.toString() + ", tenantId=" + String.valueOf(this.getTenantId()) + ", relationTypes=" + String.valueOf(this.getRelationTypes()) + ", failureMessage=" + this.getFailureMessage() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof QueueToRuleEngineMsg)) {
            return false;
        }
        QueueToRuleEngineMsg other = (QueueToRuleEngineMsg)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TenantId this$tenantId = this.getTenantId();
        TenantId other$tenantId = other.getTenantId();
        if (this$tenantId == null ? other$tenantId != null : !this$tenantId.equals(other$tenantId)) {
            return false;
        }
        Set<String> this$relationTypes = this.getRelationTypes();
        Set<String> other$relationTypes = other.getRelationTypes();
        if (this$relationTypes == null ? other$relationTypes != null : !((Object)this$relationTypes).equals(other$relationTypes)) {
            return false;
        }
        String this$failureMessage = this.getFailureMessage();
        String other$failureMessage = other.getFailureMessage();
        return !(this$failureMessage == null ? other$failureMessage != null : !this$failureMessage.equals(other$failureMessage));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof QueueToRuleEngineMsg;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        TenantId $tenantId = this.getTenantId();
        result = result * 59 + ($tenantId == null ? 43 : $tenantId.hashCode());
        Set<String> $relationTypes = this.getRelationTypes();
        result = result * 59 + ($relationTypes == null ? 43 : ((Object)$relationTypes).hashCode());
        String $failureMessage = this.getFailureMessage();
        result = result * 59 + ($failureMessage == null ? 43 : $failureMessage.hashCode());
        return result;
    }

    public TenantId getTenantId() {
        return this.tenantId;
    }

    public Set<String> getRelationTypes() {
        return this.relationTypes;
    }

    public String getFailureMessage() {
        return this.failureMessage;
    }
}

