/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.msg.plugin;

import java.util.Optional;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.RuleChainId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.plugin.ComponentLifecycleEvent;
import org.thingsboard.server.common.msg.MsgType;
import org.thingsboard.server.common.msg.aware.TenantAwareMsg;
import org.thingsboard.server.common.msg.cluster.ToAllNodesMsg;

public class ComponentLifecycleMsg
implements TenantAwareMsg,
ToAllNodesMsg {
    private static final long serialVersionUID = -5303421482781273062L;
    private final TenantId tenantId;
    private final EntityId entityId;
    private final ComponentLifecycleEvent event;
    private final String oldName;
    private final String name;
    private final EntityId oldProfileId;
    private final EntityId profileId;

    public ComponentLifecycleMsg(TenantId tenantId, EntityId entityId, ComponentLifecycleEvent event) {
        this(tenantId, entityId, event, null, null, null, null);
    }

    private ComponentLifecycleMsg(TenantId tenantId, EntityId entityId, ComponentLifecycleEvent event, String oldName, String name, EntityId oldProfileId, EntityId profileId) {
        this.tenantId = tenantId;
        this.entityId = entityId;
        this.event = event;
        this.oldName = oldName;
        this.name = name;
        this.oldProfileId = oldProfileId;
        this.profileId = profileId;
    }

    public Optional<RuleChainId> getRuleChainId() {
        return this.entityId.getEntityType() == EntityType.RULE_CHAIN ? Optional.of((RuleChainId)this.entityId) : Optional.empty();
    }

    @Override
    public MsgType getMsgType() {
        return MsgType.COMPONENT_LIFE_CYCLE_MSG;
    }

    public static ComponentLifecycleMsgBuilder builder() {
        return new ComponentLifecycleMsgBuilder();
    }

    @Override
    public TenantId getTenantId() {
        return this.tenantId;
    }

    public EntityId getEntityId() {
        return this.entityId;
    }

    public ComponentLifecycleEvent getEvent() {
        return this.event;
    }

    public String getOldName() {
        return this.oldName;
    }

    public String getName() {
        return this.name;
    }

    public EntityId getOldProfileId() {
        return this.oldProfileId;
    }

    public EntityId getProfileId() {
        return this.profileId;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ComponentLifecycleMsg)) {
            return false;
        }
        ComponentLifecycleMsg other = (ComponentLifecycleMsg)o;
        if (!other.canEqual(this)) {
            return false;
        }
        TenantId this$tenantId = this.getTenantId();
        TenantId other$tenantId = other.getTenantId();
        if (this$tenantId == null ? other$tenantId != null : !this$tenantId.equals(other$tenantId)) {
            return false;
        }
        EntityId this$entityId = this.getEntityId();
        EntityId other$entityId = other.getEntityId();
        if (this$entityId == null ? other$entityId != null : !this$entityId.equals(other$entityId)) {
            return false;
        }
        ComponentLifecycleEvent this$event = this.getEvent();
        ComponentLifecycleEvent other$event = other.getEvent();
        if (this$event == null ? other$event != null : !this$event.equals(other$event)) {
            return false;
        }
        String this$oldName = this.getOldName();
        String other$oldName = other.getOldName();
        if (this$oldName == null ? other$oldName != null : !this$oldName.equals(other$oldName)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        EntityId this$oldProfileId = this.getOldProfileId();
        EntityId other$oldProfileId = other.getOldProfileId();
        if (this$oldProfileId == null ? other$oldProfileId != null : !this$oldProfileId.equals(other$oldProfileId)) {
            return false;
        }
        EntityId this$profileId = this.getProfileId();
        EntityId other$profileId = other.getProfileId();
        return !(this$profileId == null ? other$profileId != null : !this$profileId.equals(other$profileId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ComponentLifecycleMsg;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        TenantId $tenantId = this.getTenantId();
        result = result * 59 + ($tenantId == null ? 43 : $tenantId.hashCode());
        EntityId $entityId = this.getEntityId();
        result = result * 59 + ($entityId == null ? 43 : $entityId.hashCode());
        ComponentLifecycleEvent $event = this.getEvent();
        result = result * 59 + ($event == null ? 43 : $event.hashCode());
        String $oldName = this.getOldName();
        result = result * 59 + ($oldName == null ? 43 : $oldName.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        EntityId $oldProfileId = this.getOldProfileId();
        result = result * 59 + ($oldProfileId == null ? 43 : $oldProfileId.hashCode());
        EntityId $profileId = this.getProfileId();
        result = result * 59 + ($profileId == null ? 43 : $profileId.hashCode());
        return result;
    }

    public String toString() {
        return "ComponentLifecycleMsg(tenantId=" + String.valueOf(this.getTenantId()) + ", entityId=" + String.valueOf(this.getEntityId()) + ", event=" + String.valueOf(this.getEvent()) + ", oldName=" + this.getOldName() + ", name=" + this.getName() + ", oldProfileId=" + String.valueOf(this.getOldProfileId()) + ", profileId=" + String.valueOf(this.getProfileId()) + ")";
    }

    public static class ComponentLifecycleMsgBuilder {
        private TenantId tenantId;
        private EntityId entityId;
        private ComponentLifecycleEvent event;
        private String oldName;
        private String name;
        private EntityId oldProfileId;
        private EntityId profileId;

        ComponentLifecycleMsgBuilder() {
        }

        public ComponentLifecycleMsgBuilder tenantId(TenantId tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        public ComponentLifecycleMsgBuilder entityId(EntityId entityId) {
            this.entityId = entityId;
            return this;
        }

        public ComponentLifecycleMsgBuilder event(ComponentLifecycleEvent event) {
            this.event = event;
            return this;
        }

        public ComponentLifecycleMsgBuilder oldName(String oldName) {
            this.oldName = oldName;
            return this;
        }

        public ComponentLifecycleMsgBuilder name(String name) {
            this.name = name;
            return this;
        }

        public ComponentLifecycleMsgBuilder oldProfileId(EntityId oldProfileId) {
            this.oldProfileId = oldProfileId;
            return this;
        }

        public ComponentLifecycleMsgBuilder profileId(EntityId profileId) {
            this.profileId = profileId;
            return this;
        }

        public ComponentLifecycleMsg build() {
            return new ComponentLifecycleMsg(this.tenantId, this.entityId, this.event, this.oldName, this.name, this.oldProfileId, this.profileId);
        }

        public String toString() {
            return "ComponentLifecycleMsg.ComponentLifecycleMsgBuilder(tenantId=" + String.valueOf(this.tenantId) + ", entityId=" + String.valueOf(this.entityId) + ", event=" + String.valueOf(this.event) + ", oldName=" + this.oldName + ", name=" + this.name + ", oldProfileId=" + String.valueOf(this.oldProfileId) + ", profileId=" + String.valueOf(this.profileId) + ")";
        }
    }
}

