/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.msg;

import java.beans.ConstructorProperties;
import java.io.Serializable;
import java.util.UUID;
import org.thingsboard.server.common.data.id.RuleChainId;
import org.thingsboard.server.common.data.id.RuleNodeId;
import org.thingsboard.server.common.msg.gen.MsgProtos;

public class TbMsgProcessingStackItem
implements Serializable {
    private final RuleChainId ruleChainId;
    private final RuleNodeId ruleNodeId;

    MsgProtos.TbMsgProcessingStackItemProto toProto() {
        return MsgProtos.TbMsgProcessingStackItemProto.newBuilder().setRuleChainIdMSB(this.ruleChainId.getId().getMostSignificantBits()).setRuleChainIdLSB(this.ruleChainId.getId().getLeastSignificantBits()).setRuleNodeIdMSB(this.ruleNodeId.getId().getMostSignificantBits()).setRuleNodeIdLSB(this.ruleNodeId.getId().getLeastSignificantBits()).build();
    }

    static TbMsgProcessingStackItem fromProto(MsgProtos.TbMsgProcessingStackItemProto item) {
        return new TbMsgProcessingStackItem(new RuleChainId(new UUID(item.getRuleChainIdMSB(), item.getRuleChainIdLSB())), new RuleNodeId(new UUID(item.getRuleNodeIdMSB(), item.getRuleNodeIdLSB())));
    }

    @ConstructorProperties(value={"ruleChainId", "ruleNodeId"})
    public TbMsgProcessingStackItem(RuleChainId ruleChainId, RuleNodeId ruleNodeId) {
        this.ruleChainId = ruleChainId;
        this.ruleNodeId = ruleNodeId;
    }

    public RuleChainId getRuleChainId() {
        return this.ruleChainId;
    }

    public RuleNodeId getRuleNodeId() {
        return this.ruleNodeId;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TbMsgProcessingStackItem)) {
            return false;
        }
        TbMsgProcessingStackItem other = (TbMsgProcessingStackItem)o;
        if (!other.canEqual(this)) {
            return false;
        }
        RuleChainId this$ruleChainId = this.getRuleChainId();
        RuleChainId other$ruleChainId = other.getRuleChainId();
        if (this$ruleChainId == null ? other$ruleChainId != null : !this$ruleChainId.equals(other$ruleChainId)) {
            return false;
        }
        RuleNodeId this$ruleNodeId = this.getRuleNodeId();
        RuleNodeId other$ruleNodeId = other.getRuleNodeId();
        return !(this$ruleNodeId == null ? other$ruleNodeId != null : !this$ruleNodeId.equals(other$ruleNodeId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TbMsgProcessingStackItem;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        RuleChainId $ruleChainId = this.getRuleChainId();
        result = result * 59 + ($ruleChainId == null ? 43 : $ruleChainId.hashCode());
        RuleNodeId $ruleNodeId = this.getRuleNodeId();
        result = result * 59 + ($ruleNodeId == null ? 43 : $ruleNodeId.hashCode());
        return result;
    }

    public String toString() {
        return "TbMsgProcessingStackItem(ruleChainId=" + String.valueOf(this.getRuleChainId()) + ", ruleNodeId=" + String.valueOf(this.getRuleNodeId()) + ")";
    }
}

