/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.msg.plugin;

import java.beans.ConstructorProperties;
import java.util.Optional;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.RuleChainId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.plugin.ComponentLifecycleEvent;
import org.thingsboard.server.common.msg.MsgType;
import org.thingsboard.server.common.msg.aware.TenantAwareMsg;
import org.thingsboard.server.common.msg.cluster.ToAllNodesMsg;

public class ComponentLifecycleMsg
implements TenantAwareMsg,
ToAllNodesMsg {
    private static final long serialVersionUID = -5303421482781273062L;
    private final TenantId tenantId;
    private final EntityId entityId;
    private final ComponentLifecycleEvent event;

    public Optional<RuleChainId> getRuleChainId() {
        return this.entityId.getEntityType() == EntityType.RULE_CHAIN ? Optional.of((RuleChainId)this.entityId) : Optional.empty();
    }

    @Override
    public MsgType getMsgType() {
        return MsgType.COMPONENT_LIFE_CYCLE_MSG;
    }

    @ConstructorProperties(value={"tenantId", "entityId", "event"})
    public ComponentLifecycleMsg(TenantId tenantId, EntityId entityId, ComponentLifecycleEvent event) {
        this.tenantId = tenantId;
        this.entityId = entityId;
        this.event = event;
    }

    @Override
    public TenantId getTenantId() {
        return this.tenantId;
    }

    public EntityId getEntityId() {
        return this.entityId;
    }

    public ComponentLifecycleEvent getEvent() {
        return this.event;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ComponentLifecycleMsg)) {
            return false;
        }
        ComponentLifecycleMsg other = (ComponentLifecycleMsg)o;
        if (!other.canEqual(this)) {
            return false;
        }
        TenantId this$tenantId = this.getTenantId();
        TenantId other$tenantId = other.getTenantId();
        if (this$tenantId == null ? other$tenantId != null : !this$tenantId.equals(other$tenantId)) {
            return false;
        }
        EntityId this$entityId = this.getEntityId();
        EntityId other$entityId = other.getEntityId();
        if (this$entityId == null ? other$entityId != null : !this$entityId.equals(other$entityId)) {
            return false;
        }
        ComponentLifecycleEvent this$event = this.getEvent();
        ComponentLifecycleEvent other$event = other.getEvent();
        return !(this$event == null ? other$event != null : !this$event.equals(other$event));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ComponentLifecycleMsg;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        TenantId $tenantId = this.getTenantId();
        result = result * 59 + ($tenantId == null ? 43 : $tenantId.hashCode());
        EntityId $entityId = this.getEntityId();
        result = result * 59 + ($entityId == null ? 43 : $entityId.hashCode());
        ComponentLifecycleEvent $event = this.getEvent();
        result = result * 59 + ($event == null ? 43 : $event.hashCode());
        return result;
    }

    public String toString() {
        return "ComponentLifecycleMsg(tenantId=" + this.getTenantId() + ", entityId=" + this.getEntityId() + ", event=" + this.getEvent() + ")";
    }
}

