/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.msg;

import java.io.Serializable;
import java.util.LinkedList;
import java.util.concurrent.atomic.AtomicInteger;
import org.thingsboard.server.common.data.id.RuleChainId;
import org.thingsboard.server.common.data.id.RuleNodeId;
import org.thingsboard.server.common.msg.TbMsgProcessingStackItem;
import org.thingsboard.server.common.msg.gen.MsgProtos;

public final class TbMsgProcessingCtx
implements Serializable {
    private final AtomicInteger ruleNodeExecCounter;
    private volatile LinkedList<TbMsgProcessingStackItem> stack;

    public TbMsgProcessingCtx() {
        this(0);
    }

    public TbMsgProcessingCtx(int ruleNodeExecCounter) {
        this(ruleNodeExecCounter, null);
    }

    protected TbMsgProcessingCtx(int ruleNodeExecCounter, LinkedList<TbMsgProcessingStackItem> stack) {
        this.ruleNodeExecCounter = new AtomicInteger(ruleNodeExecCounter);
        this.stack = stack;
    }

    public int getAndIncrementRuleNodeCounter() {
        return this.ruleNodeExecCounter.getAndIncrement();
    }

    public TbMsgProcessingCtx copy() {
        if (this.stack == null || this.stack.isEmpty()) {
            return new TbMsgProcessingCtx(this.ruleNodeExecCounter.get());
        }
        return new TbMsgProcessingCtx(this.ruleNodeExecCounter.get(), new LinkedList<TbMsgProcessingStackItem>(this.stack));
    }

    public void push(RuleChainId ruleChainId, RuleNodeId ruleNodeId) {
        if (this.stack == null) {
            this.stack = new LinkedList();
        }
        this.stack.add(new TbMsgProcessingStackItem(ruleChainId, ruleNodeId));
    }

    public TbMsgProcessingStackItem pop() {
        if (this.stack == null || this.stack.isEmpty()) {
            return null;
        }
        return this.stack.removeLast();
    }

    public static TbMsgProcessingCtx fromProto(MsgProtos.TbMsgProcessingCtxProto ctx) {
        int ruleNodeExecCounter = ctx.getRuleNodeExecCounter();
        if (ctx.getStackCount() > 0) {
            LinkedList<TbMsgProcessingStackItem> stack = new LinkedList<TbMsgProcessingStackItem>();
            for (MsgProtos.TbMsgProcessingStackItemProto item : ctx.getStackList()) {
                stack.add(TbMsgProcessingStackItem.fromProto(item));
            }
            return new TbMsgProcessingCtx(ruleNodeExecCounter, stack);
        }
        return new TbMsgProcessingCtx(ruleNodeExecCounter);
    }

    public MsgProtos.TbMsgProcessingCtxProto toProto() {
        MsgProtos.TbMsgProcessingCtxProto.Builder ctxBuilder = MsgProtos.TbMsgProcessingCtxProto.newBuilder();
        ctxBuilder.setRuleNodeExecCounter(this.ruleNodeExecCounter.get());
        if (this.stack != null) {
            for (TbMsgProcessingStackItem item : this.stack) {
                ctxBuilder.addStack(item.toProto());
            }
        }
        return ctxBuilder.build();
    }
}

