/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.msg;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import java.beans.ConstructorProperties;
import java.io.Serializable;
import java.util.Objects;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.StringUtils;
import org.thingsboard.server.common.data.id.CustomerId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.EntityIdFactory;
import org.thingsboard.server.common.data.id.RuleChainId;
import org.thingsboard.server.common.data.id.RuleNodeId;
import org.thingsboard.server.common.data.msg.TbMsgType;
import org.thingsboard.server.common.msg.TbMsgDataType;
import org.thingsboard.server.common.msg.TbMsgMetaData;
import org.thingsboard.server.common.msg.TbMsgProcessingCtx;
import org.thingsboard.server.common.msg.TbMsgProcessingStackItem;
import org.thingsboard.server.common.msg.gen.MsgProtos;
import org.thingsboard.server.common.msg.queue.TbMsgCallback;

@JsonIgnoreProperties(ignoreUnknown=true)
public final class TbMsg
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(TbMsg.class);
    public static final String EMPTY_JSON_OBJECT = "{}";
    public static final String EMPTY_JSON_ARRAY = "[]";
    public static final String EMPTY_STRING = "";
    private final String queueName;
    private final UUID id;
    private final long ts;
    private final String type;
    private final TbMsgType internalType;
    private final EntityId originator;
    private final CustomerId customerId;
    private final TbMsgMetaData metaData;
    private final TbMsgDataType dataType;
    private final String data;
    private final RuleChainId ruleChainId;
    private final RuleNodeId ruleNodeId;
    private final UUID correlationId;
    private final Integer partition;
    @JsonIgnore
    private final TbMsgProcessingCtx ctx;
    @JsonIgnore
    private final transient TbMsgCallback callback;

    public int getAndIncrementRuleNodeCounter() {
        return this.ctx.getAndIncrementRuleNodeCounter();
    }

    @Deprecated(since="3.6.0", forRemoval=true)
    public static TbMsg newMsg(String queueName, String type, EntityId originator, TbMsgMetaData metaData, String data, RuleChainId ruleChainId, RuleNodeId ruleNodeId) {
        return TbMsg.newMsg(queueName, type, originator, null, metaData, data, ruleChainId, ruleNodeId);
    }

    @Deprecated(since="3.6.0")
    public static TbMsg newMsg(String queueName, String type, EntityId originator, CustomerId customerId, TbMsgMetaData metaData, String data, RuleChainId ruleChainId, RuleNodeId ruleNodeId) {
        return new TbMsg(queueName, UUID.randomUUID(), System.currentTimeMillis(), null, type, originator, customerId, metaData.copy(), TbMsgDataType.JSON, data, ruleChainId, ruleNodeId, null, TbMsgCallback.EMPTY);
    }

    @Deprecated(since="3.6.0")
    public static TbMsg newMsg(String type, EntityId originator, TbMsgMetaData metaData, String data) {
        return TbMsg.newMsg(type, originator, null, metaData, data);
    }

    @Deprecated(since="3.6.0", forRemoval=true)
    public static TbMsg newMsg(String type, EntityId originator, CustomerId customerId, TbMsgMetaData metaData, String data) {
        return new TbMsg(null, UUID.randomUUID(), System.currentTimeMillis(), null, type, originator, customerId, metaData.copy(), TbMsgDataType.JSON, data, null, null, null, TbMsgCallback.EMPTY);
    }

    public static TbMsg newMsg(String queueName, TbMsgType type, EntityId originator, TbMsgMetaData metaData, String data, RuleChainId ruleChainId, RuleNodeId ruleNodeId) {
        return TbMsg.newMsg(queueName, type, originator, null, metaData, data, ruleChainId, ruleNodeId);
    }

    public static TbMsg newMsg(String queueName, TbMsgType type, EntityId originator, CustomerId customerId, TbMsgMetaData metaData, String data, RuleChainId ruleChainId, RuleNodeId ruleNodeId) {
        return new TbMsg(queueName, UUID.randomUUID(), System.currentTimeMillis(), type, originator, customerId, metaData.copy(), TbMsgDataType.JSON, data, ruleChainId, ruleNodeId, null, TbMsgCallback.EMPTY);
    }

    public static TbMsg newMsg(TbMsgType type, EntityId originator, TbMsgMetaData metaData, String data) {
        return TbMsg.newMsg(type, originator, null, metaData, data);
    }

    public static TbMsg newMsg(TbMsgType type, EntityId originator, CustomerId customerId, TbMsgMetaData metaData, String data) {
        return new TbMsg(null, UUID.randomUUID(), System.currentTimeMillis(), type, originator, customerId, metaData.copy(), TbMsgDataType.JSON, data, null, null, null, TbMsgCallback.EMPTY);
    }

    public static TbMsg newMsg(TbMsgType type, EntityId originator, TbMsgMetaData metaData, String data, long ts) {
        return new TbMsg(null, UUID.randomUUID(), ts, type, originator, null, metaData.copy(), TbMsgDataType.JSON, data, null, null, null, TbMsgCallback.EMPTY);
    }

    @Deprecated(since="3.6.0")
    public static TbMsg newMsg(String queueName, String type, EntityId originator, TbMsgMetaData metaData, String data) {
        return TbMsg.newMsg(queueName, type, originator, null, metaData, data);
    }

    @Deprecated(since="3.6.0")
    public static TbMsg newMsg(String queueName, String type, EntityId originator, CustomerId customerId, TbMsgMetaData metaData, String data) {
        return new TbMsg(queueName, UUID.randomUUID(), System.currentTimeMillis(), null, type, originator, customerId, metaData.copy(), TbMsgDataType.JSON, data, null, null, null, TbMsgCallback.EMPTY);
    }

    @Deprecated(since="3.6.0", forRemoval=true)
    public static TbMsg newMsg(String type, EntityId originator, CustomerId customerId, TbMsgMetaData metaData, TbMsgDataType dataType, String data) {
        return new TbMsg(null, UUID.randomUUID(), System.currentTimeMillis(), null, type, originator, customerId, metaData.copy(), dataType, data, null, null, null, TbMsgCallback.EMPTY);
    }

    @Deprecated(since="3.6.0")
    public static TbMsg newMsg(String type, EntityId originator, TbMsgMetaData metaData, TbMsgDataType dataType, String data) {
        return TbMsg.newMsg(type, originator, null, metaData, dataType, data);
    }

    @Deprecated(since="3.6.0", forRemoval=true)
    public static TbMsg newMsg(String queueName, String type, EntityId originator, TbMsgMetaData metaData, TbMsgDataType dataType, String data) {
        return new TbMsg(queueName, UUID.randomUUID(), System.currentTimeMillis(), null, type, originator, null, metaData.copy(), dataType, data, null, null, null, TbMsgCallback.EMPTY);
    }

    public static TbMsg newMsg(String queueName, TbMsgType type, EntityId originator, TbMsgMetaData metaData, String data) {
        return TbMsg.newMsg(queueName, type, originator, null, metaData, data);
    }

    public static TbMsg newMsg(String queueName, TbMsgType type, EntityId originator, CustomerId customerId, TbMsgMetaData metaData, String data) {
        return new TbMsg(queueName, UUID.randomUUID(), System.currentTimeMillis(), type, originator, customerId, metaData.copy(), TbMsgDataType.JSON, data, null, null, null, TbMsgCallback.EMPTY);
    }

    public static TbMsg newMsg(TbMsgType type, EntityId originator, CustomerId customerId, TbMsgMetaData metaData, TbMsgDataType dataType, String data) {
        return new TbMsg(null, UUID.randomUUID(), System.currentTimeMillis(), type, originator, customerId, metaData.copy(), dataType, data, null, null, null, TbMsgCallback.EMPTY);
    }

    public static TbMsg newMsg(TbMsgType type, EntityId originator, TbMsgMetaData metaData, TbMsgDataType dataType, String data) {
        return TbMsg.newMsg(type, originator, null, metaData, dataType, data);
    }

    @Deprecated(since="3.6.0", forRemoval=true)
    public static TbMsg newMsg(String type, EntityId originator, TbMsgMetaData metaData, TbMsgDataType dataType, String data, RuleChainId ruleChainId, RuleNodeId ruleNodeId) {
        return new TbMsg(null, UUID.randomUUID(), System.currentTimeMillis(), null, type, originator, null, metaData.copy(), dataType, data, ruleChainId, ruleNodeId, null, TbMsgCallback.EMPTY);
    }

    @Deprecated(since="3.6.0", forRemoval=true)
    public static TbMsg newMsg(String type, EntityId originator, TbMsgMetaData metaData, String data, TbMsgCallback callback) {
        return new TbMsg(null, UUID.randomUUID(), System.currentTimeMillis(), null, type, originator, null, metaData.copy(), TbMsgDataType.JSON, data, null, null, null, callback);
    }

    @Deprecated(since="3.6.0")
    public static TbMsg transformMsg(TbMsg tbMsg, String type, EntityId originator, TbMsgMetaData metaData, String data) {
        return new TbMsg(tbMsg.queueName, tbMsg.id, tbMsg.ts, null, type, originator, tbMsg.customerId, metaData.copy(), tbMsg.dataType, data, tbMsg.ruleChainId, tbMsg.ruleNodeId, tbMsg.correlationId, tbMsg.partition, tbMsg.ctx.copy(), tbMsg.callback);
    }

    public static TbMsg newMsg(TbMsgType type, EntityId originator, TbMsgMetaData metaData, TbMsgDataType dataType, String data, RuleChainId ruleChainId, RuleNodeId ruleNodeId) {
        return new TbMsg(null, UUID.randomUUID(), System.currentTimeMillis(), type, originator, null, metaData.copy(), dataType, data, ruleChainId, ruleNodeId, null, TbMsgCallback.EMPTY);
    }

    public static TbMsg newMsg(TbMsgType type, EntityId originator, TbMsgMetaData metaData, String data, TbMsgCallback callback) {
        return new TbMsg(null, UUID.randomUUID(), System.currentTimeMillis(), type, originator, null, metaData.copy(), TbMsgDataType.JSON, data, null, null, null, callback);
    }

    public static TbMsg transformMsg(TbMsg tbMsg, TbMsgType type, EntityId originator, TbMsgMetaData metaData, String data) {
        return new TbMsg(tbMsg.queueName, tbMsg.id, tbMsg.ts, type, type.name(), originator, tbMsg.customerId, metaData.copy(), tbMsg.dataType, data, tbMsg.ruleChainId, tbMsg.ruleNodeId, tbMsg.correlationId, tbMsg.partition, tbMsg.ctx.copy(), tbMsg.callback);
    }

    public static TbMsg transformMsgOriginator(TbMsg tbMsg, EntityId originatorId) {
        return new TbMsg(tbMsg.queueName, tbMsg.id, tbMsg.ts, tbMsg.internalType, tbMsg.type, originatorId, tbMsg.getCustomerId(), tbMsg.metaData, tbMsg.dataType, tbMsg.data, tbMsg.ruleChainId, tbMsg.ruleNodeId, tbMsg.correlationId, tbMsg.partition, tbMsg.ctx.copy(), tbMsg.getCallback());
    }

    public static TbMsg transformMsgData(TbMsg tbMsg, String data) {
        return new TbMsg(tbMsg.queueName, tbMsg.id, tbMsg.ts, tbMsg.internalType, tbMsg.type, tbMsg.originator, tbMsg.customerId, tbMsg.metaData, tbMsg.dataType, data, tbMsg.ruleChainId, tbMsg.ruleNodeId, tbMsg.correlationId, tbMsg.partition, tbMsg.ctx.copy(), tbMsg.getCallback());
    }

    public static TbMsg transformMsgMetadata(TbMsg tbMsg, TbMsgMetaData metadata) {
        return new TbMsg(tbMsg.queueName, tbMsg.id, tbMsg.ts, tbMsg.internalType, tbMsg.type, tbMsg.originator, tbMsg.customerId, metadata.copy(), tbMsg.dataType, tbMsg.data, tbMsg.ruleChainId, tbMsg.ruleNodeId, tbMsg.correlationId, tbMsg.partition, tbMsg.ctx.copy(), tbMsg.getCallback());
    }

    public static TbMsg transformMsg(TbMsg tbMsg, TbMsgMetaData metadata, String data) {
        return new TbMsg(tbMsg.queueName, tbMsg.id, tbMsg.ts, tbMsg.internalType, tbMsg.type, tbMsg.originator, tbMsg.customerId, metadata, tbMsg.dataType, data, tbMsg.ruleChainId, tbMsg.ruleNodeId, tbMsg.correlationId, tbMsg.partition, tbMsg.ctx.copy(), tbMsg.getCallback());
    }

    public static TbMsg transformMsgCustomerId(TbMsg tbMsg, CustomerId customerId) {
        return new TbMsg(tbMsg.queueName, tbMsg.id, tbMsg.ts, tbMsg.internalType, tbMsg.type, tbMsg.originator, customerId, tbMsg.metaData, tbMsg.dataType, tbMsg.data, tbMsg.ruleChainId, tbMsg.ruleNodeId, tbMsg.correlationId, tbMsg.partition, tbMsg.ctx.copy(), tbMsg.getCallback());
    }

    public static TbMsg transformMsgRuleChainId(TbMsg tbMsg, RuleChainId ruleChainId) {
        return new TbMsg(tbMsg.queueName, tbMsg.id, tbMsg.ts, tbMsg.internalType, tbMsg.type, tbMsg.originator, tbMsg.customerId, tbMsg.metaData, tbMsg.dataType, tbMsg.data, ruleChainId, null, tbMsg.correlationId, tbMsg.partition, tbMsg.ctx.copy(), tbMsg.getCallback());
    }

    public static TbMsg transformMsgQueueName(TbMsg tbMsg, String queueName) {
        return new TbMsg(queueName, tbMsg.id, tbMsg.ts, tbMsg.internalType, tbMsg.type, tbMsg.originator, tbMsg.customerId, tbMsg.metaData, tbMsg.dataType, tbMsg.data, tbMsg.getRuleChainId(), null, tbMsg.correlationId, tbMsg.partition, tbMsg.ctx.copy(), tbMsg.getCallback());
    }

    public static TbMsg transformMsg(TbMsg tbMsg, RuleChainId ruleChainId, String queueName) {
        return new TbMsg(queueName, tbMsg.id, tbMsg.ts, tbMsg.internalType, tbMsg.type, tbMsg.originator, tbMsg.customerId, tbMsg.metaData, tbMsg.dataType, tbMsg.data, ruleChainId, null, tbMsg.correlationId, tbMsg.partition, tbMsg.ctx.copy(), tbMsg.getCallback());
    }

    public static TbMsg newMsg(TbMsg tbMsg, String queueName, RuleChainId ruleChainId, RuleNodeId ruleNodeId) {
        return new TbMsg(queueName, UUID.randomUUID(), tbMsg.getTs(), tbMsg.getInternalType(), tbMsg.getType(), tbMsg.getOriginator(), tbMsg.customerId, tbMsg.getMetaData().copy(), tbMsg.getDataType(), tbMsg.getData(), ruleChainId, ruleNodeId, tbMsg.correlationId, tbMsg.partition, tbMsg.ctx.copy(), TbMsgCallback.EMPTY);
    }

    private TbMsg(String queueName, UUID id, long ts, TbMsgType internalType, EntityId originator, CustomerId customerId, TbMsgMetaData metaData, TbMsgDataType dataType, String data, RuleChainId ruleChainId, RuleNodeId ruleNodeId, TbMsgProcessingCtx ctx, TbMsgCallback callback) {
        this(queueName, id, ts, internalType, internalType.name(), originator, customerId, metaData, dataType, data, ruleChainId, ruleNodeId, ctx, callback);
    }

    private TbMsg(String queueName, UUID id, long ts, TbMsgType internalType, String type, EntityId originator, CustomerId customerId, TbMsgMetaData metaData, TbMsgDataType dataType, String data, RuleChainId ruleChainId, RuleNodeId ruleNodeId, TbMsgProcessingCtx ctx, TbMsgCallback callback) {
        this(queueName, id, ts, internalType, type, originator, customerId, metaData, dataType, data, ruleChainId, ruleNodeId, null, null, ctx, callback);
    }

    private TbMsg(String queueName, UUID id, long ts, TbMsgType internalType, String type, EntityId originator, CustomerId customerId, TbMsgMetaData metaData, TbMsgDataType dataType, String data, RuleChainId ruleChainId, RuleNodeId ruleNodeId, UUID correlationId, Integer partition, TbMsgProcessingCtx ctx, TbMsgCallback callback) {
        this.id = id;
        this.queueName = queueName;
        this.ts = ts > 0L ? ts : System.currentTimeMillis();
        this.type = type;
        this.internalType = internalType != null ? internalType : this.getInternalType(type);
        this.originator = originator;
        this.customerId = customerId == null || customerId.isNullUid() ? (originator != null && originator.getEntityType() == EntityType.CUSTOMER ? new CustomerId(originator.getId()) : null) : customerId;
        this.metaData = metaData;
        this.dataType = dataType;
        this.data = data;
        this.ruleChainId = ruleChainId;
        this.ruleNodeId = ruleNodeId;
        this.correlationId = correlationId;
        this.partition = partition;
        this.ctx = ctx != null ? ctx : new TbMsgProcessingCtx();
        this.callback = Objects.requireNonNullElse(callback, TbMsgCallback.EMPTY);
    }

    public static ByteString toByteString(TbMsg msg) {
        return ByteString.copyFrom((byte[])TbMsg.toByteArray(msg));
    }

    public static byte[] toByteArray(TbMsg msg) {
        MsgProtos.TbMsgProto.Builder builder = MsgProtos.TbMsgProto.newBuilder();
        builder.setId(msg.getId().toString());
        builder.setTs(msg.getTs());
        builder.setType(msg.getType());
        builder.setEntityType(msg.getOriginator().getEntityType().name());
        builder.setEntityIdMSB(msg.getOriginator().getId().getMostSignificantBits());
        builder.setEntityIdLSB(msg.getOriginator().getId().getLeastSignificantBits());
        if (msg.getCustomerId() != null) {
            builder.setCustomerIdMSB(msg.getCustomerId().getId().getMostSignificantBits());
            builder.setCustomerIdLSB(msg.getCustomerId().getId().getLeastSignificantBits());
        }
        if (msg.getRuleChainId() != null) {
            builder.setRuleChainIdMSB(msg.getRuleChainId().getId().getMostSignificantBits());
            builder.setRuleChainIdLSB(msg.getRuleChainId().getId().getLeastSignificantBits());
        }
        if (msg.getRuleNodeId() != null) {
            builder.setRuleNodeIdMSB(msg.getRuleNodeId().getId().getMostSignificantBits());
            builder.setRuleNodeIdLSB(msg.getRuleNodeId().getId().getLeastSignificantBits());
        }
        if (msg.getMetaData() != null) {
            builder.setMetaData(MsgProtos.TbMsgMetaDataProto.newBuilder().putAllData(msg.getMetaData().getData()).build());
        }
        builder.setDataType(msg.getDataType().ordinal());
        builder.setData(msg.getData());
        if (msg.getCorrelationId() != null) {
            builder.setCorrelationIdMSB(msg.getCorrelationId().getMostSignificantBits());
            builder.setCorrelationIdLSB(msg.getCorrelationId().getLeastSignificantBits());
        }
        if (msg.getPartition() != null) {
            builder.setPartition(msg.getPartition());
        }
        builder.setCtx(msg.ctx.toProto());
        return builder.build().toByteArray();
    }

    public static TbMsg fromBytes(String queueName, byte[] data, TbMsgCallback callback) {
        try {
            MsgProtos.TbMsgProto proto = MsgProtos.TbMsgProto.parseFrom(data);
            TbMsgMetaData metaData = new TbMsgMetaData(proto.getMetaData().getDataMap());
            EntityId entityId = EntityIdFactory.getByTypeAndUuid((String)proto.getEntityType(), (UUID)new UUID(proto.getEntityIdMSB(), proto.getEntityIdLSB()));
            CustomerId customerId = null;
            RuleChainId ruleChainId = null;
            RuleNodeId ruleNodeId = null;
            UUID correlationId = null;
            Integer partition = null;
            if (proto.getCustomerIdMSB() != 0L && proto.getCustomerIdLSB() != 0L) {
                customerId = new CustomerId(new UUID(proto.getCustomerIdMSB(), proto.getCustomerIdLSB()));
            }
            if (proto.getRuleChainIdMSB() != 0L && proto.getRuleChainIdLSB() != 0L) {
                ruleChainId = new RuleChainId(new UUID(proto.getRuleChainIdMSB(), proto.getRuleChainIdLSB()));
            }
            if (proto.getRuleNodeIdMSB() != 0L && proto.getRuleNodeIdLSB() != 0L) {
                ruleNodeId = new RuleNodeId(new UUID(proto.getRuleNodeIdMSB(), proto.getRuleNodeIdLSB()));
            }
            if (proto.getCorrelationIdMSB() != 0L && proto.getCorrelationIdLSB() != 0L) {
                correlationId = new UUID(proto.getCorrelationIdMSB(), proto.getCorrelationIdLSB());
                partition = proto.getPartition();
            }
            TbMsgProcessingCtx ctx = proto.hasCtx() ? TbMsgProcessingCtx.fromProto(proto.getCtx()) : new TbMsgProcessingCtx(proto.getRuleNodeExecCounter());
            TbMsgDataType dataType = TbMsgDataType.values()[proto.getDataType()];
            return new TbMsg(queueName, UUID.fromString(proto.getId()), proto.getTs(), null, proto.getType(), entityId, customerId, metaData, dataType, proto.getData(), ruleChainId, ruleNodeId, correlationId, partition, ctx, callback);
        }
        catch (InvalidProtocolBufferException e) {
            throw new IllegalStateException("Could not parse protobuf for TbMsg", e);
        }
    }

    public TbMsg copyWithRuleChainId(RuleChainId ruleChainId) {
        return this.copyWithRuleChainId(ruleChainId, this.id);
    }

    public TbMsg copyWithRuleChainId(RuleChainId ruleChainId, UUID msgId) {
        return new TbMsg(this.queueName, msgId, this.ts, this.internalType, this.type, this.originator, this.customerId, this.metaData, this.dataType, this.data, ruleChainId, null, this.correlationId, this.partition, this.ctx, this.callback);
    }

    public TbMsg copyWithRuleNodeId(RuleChainId ruleChainId, RuleNodeId ruleNodeId, UUID msgId) {
        return new TbMsg(this.queueName, msgId, this.ts, this.internalType, this.type, this.originator, this.customerId, this.metaData, this.dataType, this.data, ruleChainId, ruleNodeId, this.correlationId, this.partition, this.ctx, this.callback);
    }

    public TbMsg copyWithNewCtx() {
        return new TbMsg(this.queueName, this.id, this.ts, this.internalType, this.type, this.originator, this.customerId, this.metaData, this.dataType, this.data, this.ruleChainId, this.ruleNodeId, this.correlationId, this.partition, this.ctx.copy(), TbMsgCallback.EMPTY);
    }

    public TbMsgCallback getCallback() {
        return Objects.requireNonNullElse(this.callback, TbMsgCallback.EMPTY);
    }

    public void pushToStack(RuleChainId ruleChainId, RuleNodeId ruleNodeId) {
        this.ctx.push(ruleChainId, ruleNodeId);
    }

    public TbMsgProcessingStackItem popFormStack() {
        return this.ctx.pop();
    }

    public boolean isValid() {
        return this.getCallback().isMsgValid();
    }

    public long getMetaDataTs() {
        String tsStr = this.metaData.getValue("ts");
        if (!StringUtils.isEmpty((String)tsStr)) {
            try {
                return Long.parseLong(tsStr);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return this.ts;
    }

    private TbMsgType getInternalType(String type) {
        try {
            return TbMsgType.valueOf((String)type);
        }
        catch (IllegalArgumentException e) {
            return TbMsgType.NA;
        }
    }

    public boolean isTypeOf(TbMsgType tbMsgType) {
        return this.internalType.equals((Object)tbMsgType);
    }

    public boolean isTypeOneOf(TbMsgType ... types) {
        for (TbMsgType type : types) {
            if (!this.isTypeOf(type)) continue;
            return true;
        }
        return false;
    }

    public static TbMsgBuilder builder() {
        return new TbMsgBuilder();
    }

    public TbMsgBuilder toBuilder() {
        return new TbMsgBuilder().queueName(this.queueName).id(this.id).ts(this.ts).type(this.type).internalType(this.internalType).originator(this.originator).customerId(this.customerId).metaData(this.metaData).dataType(this.dataType).data(this.data).ruleChainId(this.ruleChainId).ruleNodeId(this.ruleNodeId).correlationId(this.correlationId).partition(this.partition).ctx(this.ctx).callback(this.callback);
    }

    public String getQueueName() {
        return this.queueName;
    }

    public UUID getId() {
        return this.id;
    }

    public long getTs() {
        return this.ts;
    }

    public String getType() {
        return this.type;
    }

    public TbMsgType getInternalType() {
        return this.internalType;
    }

    public EntityId getOriginator() {
        return this.originator;
    }

    public CustomerId getCustomerId() {
        return this.customerId;
    }

    public TbMsgMetaData getMetaData() {
        return this.metaData;
    }

    public TbMsgDataType getDataType() {
        return this.dataType;
    }

    public String getData() {
        return this.data;
    }

    public RuleChainId getRuleChainId() {
        return this.ruleChainId;
    }

    public RuleNodeId getRuleNodeId() {
        return this.ruleNodeId;
    }

    public UUID getCorrelationId() {
        return this.correlationId;
    }

    public Integer getPartition() {
        return this.partition;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TbMsg)) {
            return false;
        }
        TbMsg other = (TbMsg)o;
        if (this.getTs() != other.getTs()) {
            return false;
        }
        Integer this$partition = this.getPartition();
        Integer other$partition = other.getPartition();
        if (this$partition == null ? other$partition != null : !((Object)this$partition).equals(other$partition)) {
            return false;
        }
        String this$queueName = this.getQueueName();
        String other$queueName = other.getQueueName();
        if (this$queueName == null ? other$queueName != null : !this$queueName.equals(other$queueName)) {
            return false;
        }
        UUID this$id = this.getId();
        UUID other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        TbMsgType this$internalType = this.getInternalType();
        TbMsgType other$internalType = other.getInternalType();
        if (this$internalType == null ? other$internalType != null : !this$internalType.equals(other$internalType)) {
            return false;
        }
        EntityId this$originator = this.getOriginator();
        EntityId other$originator = other.getOriginator();
        if (this$originator == null ? other$originator != null : !this$originator.equals(other$originator)) {
            return false;
        }
        CustomerId this$customerId = this.getCustomerId();
        CustomerId other$customerId = other.getCustomerId();
        if (this$customerId == null ? other$customerId != null : !this$customerId.equals(other$customerId)) {
            return false;
        }
        TbMsgMetaData this$metaData = this.getMetaData();
        TbMsgMetaData other$metaData = other.getMetaData();
        if (this$metaData == null ? other$metaData != null : !((Object)this$metaData).equals(other$metaData)) {
            return false;
        }
        TbMsgDataType this$dataType = this.getDataType();
        TbMsgDataType other$dataType = other.getDataType();
        if (this$dataType == null ? other$dataType != null : !((Object)((Object)this$dataType)).equals((Object)other$dataType)) {
            return false;
        }
        String this$data = this.getData();
        String other$data = other.getData();
        if (this$data == null ? other$data != null : !this$data.equals(other$data)) {
            return false;
        }
        RuleChainId this$ruleChainId = this.getRuleChainId();
        RuleChainId other$ruleChainId = other.getRuleChainId();
        if (this$ruleChainId == null ? other$ruleChainId != null : !this$ruleChainId.equals(other$ruleChainId)) {
            return false;
        }
        RuleNodeId this$ruleNodeId = this.getRuleNodeId();
        RuleNodeId other$ruleNodeId = other.getRuleNodeId();
        if (this$ruleNodeId == null ? other$ruleNodeId != null : !this$ruleNodeId.equals(other$ruleNodeId)) {
            return false;
        }
        UUID this$correlationId = this.getCorrelationId();
        UUID other$correlationId = other.getCorrelationId();
        if (this$correlationId == null ? other$correlationId != null : !((Object)this$correlationId).equals(other$correlationId)) {
            return false;
        }
        TbMsgProcessingCtx this$ctx = this.ctx;
        TbMsgProcessingCtx other$ctx = other.ctx;
        return !(this$ctx == null ? other$ctx != null : !this$ctx.equals(other$ctx));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $ts = this.getTs();
        result = result * 59 + (int)($ts >>> 32 ^ $ts);
        Integer $partition = this.getPartition();
        result = result * 59 + ($partition == null ? 43 : ((Object)$partition).hashCode());
        String $queueName = this.getQueueName();
        result = result * 59 + ($queueName == null ? 43 : $queueName.hashCode());
        UUID $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        TbMsgType $internalType = this.getInternalType();
        result = result * 59 + ($internalType == null ? 43 : $internalType.hashCode());
        EntityId $originator = this.getOriginator();
        result = result * 59 + ($originator == null ? 43 : $originator.hashCode());
        CustomerId $customerId = this.getCustomerId();
        result = result * 59 + ($customerId == null ? 43 : $customerId.hashCode());
        TbMsgMetaData $metaData = this.getMetaData();
        result = result * 59 + ($metaData == null ? 43 : ((Object)$metaData).hashCode());
        TbMsgDataType $dataType = this.getDataType();
        result = result * 59 + ($dataType == null ? 43 : ((Object)((Object)$dataType)).hashCode());
        String $data = this.getData();
        result = result * 59 + ($data == null ? 43 : $data.hashCode());
        RuleChainId $ruleChainId = this.getRuleChainId();
        result = result * 59 + ($ruleChainId == null ? 43 : $ruleChainId.hashCode());
        RuleNodeId $ruleNodeId = this.getRuleNodeId();
        result = result * 59 + ($ruleNodeId == null ? 43 : $ruleNodeId.hashCode());
        UUID $correlationId = this.getCorrelationId();
        result = result * 59 + ($correlationId == null ? 43 : ((Object)$correlationId).hashCode());
        TbMsgProcessingCtx $ctx = this.ctx;
        result = result * 59 + ($ctx == null ? 43 : $ctx.hashCode());
        return result;
    }

    public String toString() {
        return "TbMsg(queueName=" + this.getQueueName() + ", id=" + this.getId() + ", ts=" + this.getTs() + ", type=" + this.getType() + ", internalType=" + this.getInternalType() + ", originator=" + this.getOriginator() + ", customerId=" + this.getCustomerId() + ", metaData=" + this.getMetaData() + ", dataType=" + this.getDataType() + ", data=" + this.getData() + ", ruleChainId=" + this.getRuleChainId() + ", ruleNodeId=" + this.getRuleNodeId() + ", correlationId=" + this.getCorrelationId() + ", partition=" + this.getPartition() + ", ctx=" + this.ctx + ", callback=" + this.getCallback() + ")";
    }

    @ConstructorProperties(value={"queueName", "id", "ts", "type", "internalType", "originator", "customerId", "metaData", "dataType", "data", "ruleChainId", "ruleNodeId", "correlationId", "partition", "ctx", "callback"})
    private TbMsg(String queueName, UUID id, long ts, String type, TbMsgType internalType, EntityId originator, CustomerId customerId, TbMsgMetaData metaData, TbMsgDataType dataType, String data, RuleChainId ruleChainId, RuleNodeId ruleNodeId, UUID correlationId, Integer partition, TbMsgProcessingCtx ctx, TbMsgCallback callback) {
        this.queueName = queueName;
        this.id = id;
        this.ts = ts;
        this.type = type;
        this.internalType = internalType;
        this.originator = originator;
        this.customerId = customerId;
        this.metaData = metaData;
        this.dataType = dataType;
        this.data = data;
        this.ruleChainId = ruleChainId;
        this.ruleNodeId = ruleNodeId;
        this.correlationId = correlationId;
        this.partition = partition;
        this.ctx = ctx;
        this.callback = callback;
    }

    public static class TbMsgBuilder {
        private String queueName;
        private UUID id;
        private long ts;
        private String type;
        private TbMsgType internalType;
        private EntityId originator;
        private CustomerId customerId;
        private TbMsgMetaData metaData;
        private TbMsgDataType dataType;
        private String data;
        private RuleChainId ruleChainId;
        private RuleNodeId ruleNodeId;
        private UUID correlationId;
        private Integer partition;
        private TbMsgProcessingCtx ctx;
        private TbMsgCallback callback;

        TbMsgBuilder() {
        }

        public TbMsgBuilder queueName(String queueName) {
            this.queueName = queueName;
            return this;
        }

        public TbMsgBuilder id(UUID id) {
            this.id = id;
            return this;
        }

        public TbMsgBuilder ts(long ts) {
            this.ts = ts;
            return this;
        }

        public TbMsgBuilder type(String type) {
            this.type = type;
            return this;
        }

        public TbMsgBuilder internalType(TbMsgType internalType) {
            this.internalType = internalType;
            return this;
        }

        public TbMsgBuilder originator(EntityId originator) {
            this.originator = originator;
            return this;
        }

        public TbMsgBuilder customerId(CustomerId customerId) {
            this.customerId = customerId;
            return this;
        }

        public TbMsgBuilder metaData(TbMsgMetaData metaData) {
            this.metaData = metaData;
            return this;
        }

        public TbMsgBuilder dataType(TbMsgDataType dataType) {
            this.dataType = dataType;
            return this;
        }

        public TbMsgBuilder data(String data) {
            this.data = data;
            return this;
        }

        public TbMsgBuilder ruleChainId(RuleChainId ruleChainId) {
            this.ruleChainId = ruleChainId;
            return this;
        }

        public TbMsgBuilder ruleNodeId(RuleNodeId ruleNodeId) {
            this.ruleNodeId = ruleNodeId;
            return this;
        }

        public TbMsgBuilder correlationId(UUID correlationId) {
            this.correlationId = correlationId;
            return this;
        }

        public TbMsgBuilder partition(Integer partition) {
            this.partition = partition;
            return this;
        }

        @JsonIgnore
        public TbMsgBuilder ctx(TbMsgProcessingCtx ctx) {
            this.ctx = ctx;
            return this;
        }

        @JsonIgnore
        public TbMsgBuilder callback(TbMsgCallback callback) {
            this.callback = callback;
            return this;
        }

        public TbMsg build() {
            return new TbMsg(this.queueName, this.id, this.ts, this.type, this.internalType, this.originator, this.customerId, this.metaData, this.dataType, this.data, this.ruleChainId, this.ruleNodeId, this.correlationId, this.partition, this.ctx, this.callback);
        }

        public String toString() {
            return "TbMsg.TbMsgBuilder(queueName=" + this.queueName + ", id=" + this.id + ", ts=" + this.ts + ", type=" + this.type + ", internalType=" + this.internalType + ", originator=" + this.originator + ", customerId=" + this.customerId + ", metaData=" + this.metaData + ", dataType=" + this.dataType + ", data=" + this.data + ", ruleChainId=" + this.ruleChainId + ", ruleNodeId=" + this.ruleNodeId + ", correlationId=" + this.correlationId + ", partition=" + this.partition + ", ctx=" + this.ctx + ", callback=" + this.callback + ")";
        }
    }
}

