/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.msg.rule.engine;

import java.beans.ConstructorProperties;
import org.thingsboard.server.common.data.id.DeviceId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.security.DeviceCredentials;
import org.thingsboard.server.common.msg.MsgType;
import org.thingsboard.server.common.msg.ToDeviceActorNotificationMsg;

public class DeviceCredentialsUpdateNotificationMsg
implements ToDeviceActorNotificationMsg {
    private static final long serialVersionUID = -3956907402411126990L;
    private final TenantId tenantId;
    private final DeviceId deviceId;
    private final DeviceCredentials deviceCredentials;

    @Override
    public MsgType getMsgType() {
        return MsgType.DEVICE_CREDENTIALS_UPDATE_TO_DEVICE_ACTOR_MSG;
    }

    @ConstructorProperties(value={"tenantId", "deviceId", "deviceCredentials"})
    public DeviceCredentialsUpdateNotificationMsg(TenantId tenantId, DeviceId deviceId, DeviceCredentials deviceCredentials) {
        this.tenantId = tenantId;
        this.deviceId = deviceId;
        this.deviceCredentials = deviceCredentials;
    }

    @Override
    public TenantId getTenantId() {
        return this.tenantId;
    }

    @Override
    public DeviceId getDeviceId() {
        return this.deviceId;
    }

    public DeviceCredentials getDeviceCredentials() {
        return this.deviceCredentials;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DeviceCredentialsUpdateNotificationMsg)) {
            return false;
        }
        DeviceCredentialsUpdateNotificationMsg other = (DeviceCredentialsUpdateNotificationMsg)o;
        if (!other.canEqual(this)) {
            return false;
        }
        TenantId this$tenantId = this.getTenantId();
        TenantId other$tenantId = other.getTenantId();
        if (this$tenantId == null ? other$tenantId != null : !this$tenantId.equals(other$tenantId)) {
            return false;
        }
        DeviceId this$deviceId = this.getDeviceId();
        DeviceId other$deviceId = other.getDeviceId();
        if (this$deviceId == null ? other$deviceId != null : !this$deviceId.equals(other$deviceId)) {
            return false;
        }
        DeviceCredentials this$deviceCredentials = this.getDeviceCredentials();
        DeviceCredentials other$deviceCredentials = other.getDeviceCredentials();
        return !(this$deviceCredentials == null ? other$deviceCredentials != null : !this$deviceCredentials.equals(other$deviceCredentials));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DeviceCredentialsUpdateNotificationMsg;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        TenantId $tenantId = this.getTenantId();
        result = result * 59 + ($tenantId == null ? 43 : $tenantId.hashCode());
        DeviceId $deviceId = this.getDeviceId();
        result = result * 59 + ($deviceId == null ? 43 : $deviceId.hashCode());
        DeviceCredentials $deviceCredentials = this.getDeviceCredentials();
        result = result * 59 + ($deviceCredentials == null ? 43 : $deviceCredentials.hashCode());
        return result;
    }

    public String toString() {
        return "DeviceCredentialsUpdateNotificationMsg(tenantId=" + this.getTenantId() + ", deviceId=" + this.getDeviceId() + ", deviceCredentials=" + this.getDeviceCredentials() + ")";
    }
}

