/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.msg.queue;

import java.util.Objects;
import java.util.Optional;
import org.thingsboard.server.common.data.id.TenantId;

public class TopicPartitionInfo {
    private final String topic;
    private final TenantId tenantId;
    private final Integer partition;
    private final String fullTopicName;
    private final boolean myPartition;

    public TopicPartitionInfo(String topic, TenantId tenantId, Integer partition, boolean myPartition) {
        this.topic = topic;
        this.tenantId = tenantId;
        this.partition = partition;
        this.myPartition = myPartition;
        Object tmp = topic;
        if (tenantId != null && !tenantId.isNullUid()) {
            tmp = (String)tmp + ".isolated." + tenantId.getId().toString();
        }
        if (partition != null) {
            tmp = (String)tmp + "." + partition;
        }
        this.fullTopicName = tmp;
    }

    public TopicPartitionInfo newByTopic(String topic) {
        return new TopicPartitionInfo(topic, this.tenantId, this.partition, this.myPartition);
    }

    public String getTopic() {
        return this.topic;
    }

    public Optional<TenantId> getTenantId() {
        return Optional.ofNullable(this.tenantId);
    }

    public Optional<Integer> getPartition() {
        return Optional.ofNullable(this.partition);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TopicPartitionInfo that = (TopicPartitionInfo)o;
        return this.topic.equals(that.topic) && Objects.equals(this.tenantId, that.tenantId) && Objects.equals(this.partition, that.partition) && this.fullTopicName.equals(that.fullTopicName);
    }

    public int hashCode() {
        return Objects.hash(this.fullTopicName);
    }

    public static TopicPartitionInfoBuilder builder() {
        return new TopicPartitionInfoBuilder();
    }

    public String toString() {
        return "TopicPartitionInfo(topic=" + this.getTopic() + ", tenantId=" + this.getTenantId() + ", partition=" + this.getPartition() + ", fullTopicName=" + this.getFullTopicName() + ", myPartition=" + this.isMyPartition() + ")";
    }

    public String getFullTopicName() {
        return this.fullTopicName;
    }

    public boolean isMyPartition() {
        return this.myPartition;
    }

    public static class TopicPartitionInfoBuilder {
        private String topic;
        private TenantId tenantId;
        private Integer partition;
        private boolean myPartition;

        TopicPartitionInfoBuilder() {
        }

        public TopicPartitionInfoBuilder topic(String topic) {
            this.topic = topic;
            return this;
        }

        public TopicPartitionInfoBuilder tenantId(TenantId tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        public TopicPartitionInfoBuilder partition(Integer partition) {
            this.partition = partition;
            return this;
        }

        public TopicPartitionInfoBuilder myPartition(boolean myPartition) {
            this.myPartition = myPartition;
            return this;
        }

        public TopicPartitionInfo build() {
            return new TopicPartitionInfo(this.topic, this.tenantId, this.partition, this.myPartition);
        }

        public String toString() {
            return "TopicPartitionInfo.TopicPartitionInfoBuilder(topic=" + this.topic + ", tenantId=" + this.tenantId + ", partition=" + this.partition + ", myPartition=" + this.myPartition + ")";
        }
    }
}

