/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.msg.queue;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.server.common.data.StringUtils;

public class RuleEngineException
extends Exception {
    private static final Logger log = LoggerFactory.getLogger(RuleEngineException.class);
    protected static final ObjectMapper mapper = new ObjectMapper();
    private final long ts = System.currentTimeMillis();

    public RuleEngineException(String message) {
        this(message, null);
    }

    public RuleEngineException(String message, Throwable t) {
        super(message != null ? message : "Unknown", t);
    }

    public String toJsonString(int maxMessageLength) {
        try {
            return mapper.writeValueAsString((Object)mapper.createObjectNode().put("message", this.truncateIfNecessary(this.getMessage(), maxMessageLength)));
        }
        catch (JsonProcessingException e) {
            log.warn("Failed to serialize exception ", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    protected String truncateIfNecessary(String message, int maxMessageLength) {
        return StringUtils.truncate((String)message, (int)maxMessageLength);
    }

    public long getTs() {
        return this.ts;
    }
}

