/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.msg.tools;

import io.github.bucket4j.Bandwidth;
import io.github.bucket4j.Bucket4j;
import io.github.bucket4j.Refill;
import io.github.bucket4j.local.LocalBucket;
import io.github.bucket4j.local.LocalBucketBuilder;
import java.time.Duration;

public class TbRateLimits {
    private final LocalBucket bucket;
    private final String configuration;

    public TbRateLimits(String limitsConfiguration) {
        this(limitsConfiguration, false);
    }

    public TbRateLimits(String limitsConfiguration, boolean refillIntervally) {
        LocalBucketBuilder builder = Bucket4j.builder();
        boolean initialized = false;
        for (String limitSrc : limitsConfiguration.split(",")) {
            long capacity = Long.parseLong(limitSrc.split(":")[0]);
            long duration = Long.parseLong(limitSrc.split(":")[1]);
            Refill refill = refillIntervally ? Refill.intervally((long)capacity, (Duration)Duration.ofSeconds(duration)) : Refill.greedy((long)capacity, (Duration)Duration.ofSeconds(duration));
            builder.addLimit(Bandwidth.classic((long)capacity, (Refill)refill));
            initialized = true;
        }
        if (!initialized) {
            throw new IllegalArgumentException("Failed to parse rate limits configuration: " + limitsConfiguration);
        }
        this.bucket = builder.build();
        this.configuration = limitsConfiguration;
    }

    public boolean tryConsume() {
        return this.bucket.tryConsume(1L);
    }

    public boolean tryConsume(long number) {
        return this.bucket.tryConsume(number);
    }

    public String getConfiguration() {
        return this.configuration;
    }
}

