/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.msg.plugin;

import java.util.Optional;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.RuleChainId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.plugin.ComponentLifecycleEvent;
import org.thingsboard.server.common.msg.MsgType;
import org.thingsboard.server.common.msg.aware.TenantAwareMsg;
import org.thingsboard.server.common.msg.cluster.ToAllNodesMsg;

public class ComponentLifecycleMsg
implements TenantAwareMsg,
ToAllNodesMsg {
    private final TenantId tenantId;
    private final EntityId entityId;
    private final ComponentLifecycleEvent event;

    public ComponentLifecycleMsg(TenantId tenantId, EntityId entityId, ComponentLifecycleEvent event) {
        this.tenantId = tenantId;
        this.entityId = entityId;
        this.event = event;
    }

    public Optional<RuleChainId> getRuleChainId() {
        return this.entityId.getEntityType() == EntityType.RULE_CHAIN ? Optional.of((RuleChainId)this.entityId) : Optional.empty();
    }

    @Override
    public MsgType getMsgType() {
        return MsgType.COMPONENT_LIFE_CYCLE_MSG;
    }

    public String toString() {
        return "ComponentLifecycleMsg(tenantId=" + this.getTenantId() + ", entityId=" + this.getEntityId() + ", event=" + this.getEvent() + ")";
    }

    @Override
    public TenantId getTenantId() {
        return this.tenantId;
    }

    public EntityId getEntityId() {
        return this.entityId;
    }

    public ComponentLifecycleEvent getEvent() {
        return this.event;
    }
}

