/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.msg.cluster;

import java.beans.ConstructorProperties;
import java.io.Serializable;
import org.thingsboard.server.common.msg.cluster.ServerType;

public class ServerAddress
implements Comparable<ServerAddress>,
Serializable {
    private final String host;
    private final int port;
    private final ServerType serverType;

    @Override
    public int compareTo(ServerAddress o) {
        int result = this.host.compareTo(o.host);
        if (result == 0) {
            result = this.port - o.port;
        }
        return result;
    }

    public String toString() {
        return '[' + this.host + ':' + this.port + ']';
    }

    @ConstructorProperties(value={"host", "port", "serverType"})
    public ServerAddress(String host, int port, ServerType serverType) {
        this.host = host;
        this.port = port;
        this.serverType = serverType;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public ServerType getServerType() {
        return this.serverType;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ServerAddress)) {
            return false;
        }
        ServerAddress other = (ServerAddress)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$host = this.getHost();
        String other$host = other.getHost();
        if (this$host == null ? other$host != null : !this$host.equals(other$host)) {
            return false;
        }
        if (this.getPort() != other.getPort()) {
            return false;
        }
        ServerType this$serverType = this.getServerType();
        ServerType other$serverType = other.getServerType();
        return !(this$serverType == null ? other$serverType != null : !((Object)((Object)this$serverType)).equals((Object)other$serverType));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ServerAddress;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $host = this.getHost();
        result = result * 59 + ($host == null ? 43 : $host.hashCode());
        result = result * 59 + this.getPort();
        ServerType $serverType = this.getServerType();
        result = result * 59 + ($serverType == null ? 43 : ((Object)((Object)$serverType)).hashCode());
        return result;
    }
}

